/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.Privilege;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListUserPrivilegeResp
implements TBase,
Serializable,
Cloneable,
Comparable<ListUserPrivilegeResp> {
    private static final TStruct STRUCT_DESC = new TStruct("ListUserPrivilegeResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField PRIVILEGES_FIELD_DESC = new TField("privileges", 13, 3);
    public ErrorCode code;
    public HostAddr leader;
    public Map<byte[], List<Privilege>> privileges;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int PRIVILEGES = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ListUserPrivilegeResp() {
    }

    public ListUserPrivilegeResp(ErrorCode code, HostAddr leader, Map<byte[], List<Privilege>> privileges) {
        this();
        this.code = code;
        this.leader = leader;
        this.privileges = privileges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListUserPrivilegeResp(ListUserPrivilegeResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetPrivileges()) {
            this.privileges = TBaseHelper.deepCopy(other.privileges);
        }
    }

    @Override
    public ListUserPrivilegeResp deepCopy() {
        return new ListUserPrivilegeResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public ListUserPrivilegeResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public ListUserPrivilegeResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Map<byte[], List<Privilege>> getPrivileges() {
        return this.privileges;
    }

    public ListUserPrivilegeResp setPrivileges(Map<byte[], List<Privilege>> privileges) {
        this.privileges = privileges;
        return this;
    }

    public void unsetPrivileges() {
        this.privileges = null;
    }

    public boolean isSetPrivileges() {
        return this.privileges != null;
    }

    public void setPrivilegesIsSet(boolean __value) {
        if (!__value) {
            this.privileges = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetPrivileges();
                    break;
                }
                this.setPrivileges((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getPrivileges();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ListUserPrivilegeResp)) {
            return false;
        }
        ListUserPrivilegeResp that = (ListUserPrivilegeResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetPrivileges(), that.isSetPrivileges(), this.privileges, that.privileges);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.privileges});
    }

    @Override
    public int compareTo(ListUserPrivilegeResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPrivileges()).compareTo(other.isSetPrivileges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.privileges, other.privileges);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map449 = iprot.readMapBegin();
                        this.privileges = new HashMap<byte[], List<Privilege>>(Math.max(0, 2 * _map449.size));
                        int _i450 = 0;
                        while (_map449.size < 0 ? iprot.peekMap() : _i450 < _map449.size) {
                            byte[] _key451 = iprot.readBinary();
                            TList _list453 = iprot.readListBegin();
                            ArrayList<Privilege> _val452 = new ArrayList<Privilege>(Math.max(0, _list453.size));
                            int _i454 = 0;
                            while (_list453.size < 0 ? iprot.peekList() : _i454 < _list453.size) {
                                Privilege _elem455 = new Privilege();
                                _elem455.read(iprot);
                                _val452.add(_elem455);
                                ++_i454;
                            }
                            iprot.readListEnd();
                            this.privileges.put(_key451, _val452);
                            ++_i450;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.privileges != null) {
            oprot.writeFieldBegin(PRIVILEGES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 15, this.privileges.size()));
            for (Map.Entry<byte[], List<Privilege>> _iter456 : this.privileges.entrySet()) {
                oprot.writeBinary(_iter456.getKey());
                oprot.writeListBegin(new TList(12, _iter456.getValue().size()));
                for (Privilege _iter457 : _iter456.getValue()) {
                    _iter457.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ListUserPrivilegeResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("privileges");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getPrivileges() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getPrivileges(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("privileges", 3, new MapMetaData(13, new FieldValueMetaData(11), new ListMetaData(15, new StructMetaData(12, Privilege.class)))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ListUserPrivilegeResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Map<byte[], List<Privilege>> privileges;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setPrivileges(Map<byte[], List<Privilege>> privileges) {
            this.privileges = privileges;
            return this;
        }

        public ListUserPrivilegeResp build() {
            ListUserPrivilegeResp result = new ListUserPrivilegeResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setPrivileges(this.privileges);
            return result;
        }
    }
}

