/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.Date;
import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.Duration;
import com.vesoft.nebula.Geography;
import com.vesoft.nebula.NList;
import com.vesoft.nebula.NMap;
import com.vesoft.nebula.NullType;
import com.vesoft.nebula.Time;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.AuthResult;
import com.vesoft.nebula.client.graph.net.NebulaPool;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import com.vesoft.nebula.graph.ExecutionResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements Serializable {
    private static final long serialVersionUID = -8855886967097862376L;
    private final long sessionID;
    private final int timezoneOffset;
    private SyncConnection connection;
    private final NebulaPool pool;
    private final Boolean retryConnect;
    private final AtomicBoolean connectionIsBroken = new AtomicBoolean(false);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Session(SyncConnection connection, AuthResult authResult, NebulaPool connPool, Boolean retryConnect) {
        this.connection = connection;
        this.sessionID = authResult.getSessionId();
        this.timezoneOffset = authResult.getTimezoneOffset();
        this.pool = connPool;
        this.retryConnect = retryConnect;
    }

    public synchronized ResultSet execute(String stmt) throws IOErrorException {
        return this.executeWithParameter(stmt, Collections.EMPTY_MAP);
    }

    public synchronized ResultSet executeWithParameter(String stmt, Map<String, Object> parameterMap) throws IOErrorException {
        if (this.connection == null) {
            throw new IOErrorException(2, "The session was released, couldn't use again.");
        }
        HashMap<byte[], Value> map = new HashMap<byte[], Value>();
        parameterMap.forEach((key, value) -> map.put(key.getBytes(), Session.value2Nvalue(value)));
        if (this.connectionIsBroken.get() && this.retryConnect.booleanValue()) {
            if (this.retryConnect()) {
                ExecutionResponse resp = this.connection.executeWithParameter(this.sessionID, stmt, map);
                return new ResultSet(resp, this.timezoneOffset);
            }
            throw new IOErrorException(1, "All servers are broken.");
        }
        try {
            ExecutionResponse resp = this.connection.executeWithParameter(this.sessionID, stmt, map);
            return new ResultSet(resp, this.timezoneOffset);
        }
        catch (IOErrorException ie) {
            if (ie.getType() == 2) {
                this.connectionIsBroken.set(true);
                this.pool.updateServerStatus();
                if (this.retryConnect.booleanValue()) {
                    if (this.retryConnect()) {
                        this.connectionIsBroken.set(false);
                        ExecutionResponse resp = this.connection.executeWithParameter(this.sessionID, stmt, map);
                        return new ResultSet(resp, this.timezoneOffset);
                    }
                    this.connectionIsBroken.set(true);
                    throw new IOErrorException(1, "All servers are broken.");
                }
            }
            throw ie;
        }
    }

    public synchronized String executeJson(String stmt) throws IOErrorException {
        return this.executeJsonWithParameter(stmt, Collections.EMPTY_MAP);
    }

    public synchronized String executeJsonWithParameter(String stmt, Map<String, Object> parameterMap) throws IOErrorException {
        if (this.connection == null) {
            throw new IOErrorException(2, "The session was released, couldn't use again.");
        }
        HashMap<byte[], Value> map = new HashMap<byte[], Value>();
        parameterMap.entrySet().stream().forEach(x -> map.put(((String)x.getKey()).getBytes(), Session.value2Nvalue(x.getValue())));
        if (this.connectionIsBroken.get() && this.retryConnect.booleanValue()) {
            if (this.retryConnect()) {
                return this.connection.executeJsonWithParameter(this.sessionID, stmt, map);
            }
            throw new IOErrorException(1, "All servers are broken.");
        }
        try {
            return this.connection.executeJsonWithParameter(this.sessionID, stmt, map);
        }
        catch (IOErrorException ie) {
            if (ie.getType() == 2) {
                this.connectionIsBroken.set(true);
                this.pool.updateServerStatus();
                if (this.retryConnect.booleanValue()) {
                    if (this.retryConnect()) {
                        this.connectionIsBroken.set(false);
                        return this.connection.executeJsonWithParameter(this.sessionID, stmt, map);
                    }
                    this.connectionIsBroken.set(true);
                    throw new IOErrorException(1, "All servers are broken.");
                }
            }
            throw ie;
        }
    }

    public synchronized boolean ping() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.ping();
    }

    public synchronized boolean pingSession() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.ping(this.sessionID);
    }

    public synchronized void release() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.signout(this.sessionID);
            this.pool.returnConnection(this.connection);
        }
        catch (Exception e) {
            this.log.warn("Release session or return object to pool failed:" + e.getMessage());
        }
        this.connection = null;
    }

    public synchronized HostAddress getGraphHost() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getServerAddress();
    }

    private boolean retryConnect() {
        try {
            this.pool.setInvalidateConnection(this.connection);
            SyncConnection newConn = this.pool.getConnection();
            if (newConn == null) {
                this.log.error("Get connection object failed.");
                return false;
            }
            this.connection = newConn;
            return true;
        }
        catch (Exception e) {
            this.log.error("Reconnected failed: " + e);
            return false;
        }
    }

    private static NList list2Nlist(List<Object> list) throws UnsupportedOperationException {
        NList nlist = new NList(new ArrayList<Value>());
        for (Object item : list) {
            nlist.values.add(Session.value2Nvalue(item));
        }
        return nlist;
    }

    private static NMap map2Nmap(Map<String, Object> map) throws UnsupportedOperationException {
        NMap nmap = new NMap(new HashMap<byte[], Value>());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            nmap.kvs.put(entry.getKey().getBytes(), Session.value2Nvalue(entry.getValue()));
        }
        return nmap;
    }

    public static Value value2Nvalue(Object value) throws UnsupportedOperationException {
        Value nvalue = new Value();
        if (value == null) {
            nvalue.setNVal(NullType.__NULL__);
        } else if (value instanceof Boolean) {
            boolean bval = (Boolean)value;
            nvalue.setBVal(bval);
        } else if (value instanceof Integer) {
            int ival = (Integer)value;
            nvalue.setIVal(ival);
        } else if (value instanceof Short) {
            short ival = (Short)value;
            nvalue.setIVal(ival);
        } else if (value instanceof Byte) {
            byte ival = (Byte)value;
            nvalue.setIVal(ival);
        } else if (value instanceof Long) {
            long ival = (Long)value;
            nvalue.setIVal(ival);
        } else if (value instanceof Float) {
            float fval = ((Float)value).floatValue();
            nvalue.setFVal(fval);
        } else if (value instanceof Double) {
            double dval = (Double)value;
            nvalue.setFVal(dval);
        } else if (value instanceof String) {
            byte[] sval = ((String)value).getBytes();
            nvalue.setSVal(sval);
        } else if (value instanceof List) {
            nvalue.setLVal(Session.list2Nlist((List)value));
        } else if (value instanceof Map) {
            nvalue.setMVal(Session.map2Nmap((Map)value));
        } else {
            if (value instanceof Value) {
                return (Value)value;
            }
            if (value instanceof Date) {
                nvalue.setDVal((Date)value);
            } else if (value instanceof Time) {
                nvalue.setTVal((Time)value);
            } else if (value instanceof Duration) {
                nvalue.setDuVal((Duration)value);
            } else if (value instanceof DateTime) {
                nvalue.setDtVal((DateTime)value);
            } else if (value instanceof Geography) {
                nvalue.setGgVal((Geography)value);
            } else {
                throw new UnsupportedOperationException("Only support convert boolean/float/int/string/map/list to nebula.Value but was" + value.getClass().getTypeName());
            }
        }
        return nvalue;
    }
}

