/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.AuthFailedException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.AuthResult;
import com.vesoft.nebula.client.graph.net.Connection;
import com.vesoft.nebula.graph.AuthResponse;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.graph.GraphService;

public class SyncConnection
extends Connection {
    protected TTransport transport = null;
    protected TProtocol protocol = null;
    private GraphService.Client client = null;
    private int timeout = 0;

    @Override
    public void open(HostAddress address, int timeout) throws IOErrorException {
        this.serverAddr = address;
        try {
            this.timeout = timeout <= 0 ? Integer.MAX_VALUE : timeout;
            this.transport = new TSocket(address.getHost(), address.getPort(), this.timeout, this.timeout);
            this.transport.open();
            this.protocol = new TCompactProtocol(this.transport);
            this.client = new GraphService.Client(this.protocol);
        }
        catch (TException e) {
            throw new IOErrorException(0, e.getMessage());
        }
    }

    @Override
    public void reopen() throws IOErrorException {
        this.close();
        this.open(this.serverAddr, this.timeout);
    }

    public AuthResult authenticate(String user, String password) throws AuthFailedException, IOErrorException {
        try {
            AuthResponse resp = this.client.authenticate(user.getBytes(), password.getBytes());
            if (resp.error_code != ErrorCode.SUCCEEDED) {
                if (resp.error_msg != null) {
                    throw new AuthFailedException(new String(resp.error_msg));
                }
                throw new AuthFailedException("The error_msg is null, maybe the service not set or the response is disorder.");
            }
            return new AuthResult(resp.getSession_id(), resp.getTime_zone_offset_seconds());
        }
        catch (TException e) {
            if (e instanceof TTransportException) {
                TTransportException te = (TTransportException)e;
                if (te.getType() == 4) {
                    throw new IOErrorException(2, te.getMessage());
                }
                if (te.getType() == 3 || te.getMessage().contains("Read timed out")) {
                    this.reopen();
                    throw new IOErrorException(4, te.getMessage());
                }
                if (te.getType() == 1) {
                    throw new IOErrorException(5, te.getMessage());
                }
            }
            throw new AuthFailedException(String.format("Authenticate failed: %s", e.getMessage()));
        }
    }

    public ExecutionResponse execute(long sessionID, String stmt) throws IOErrorException {
        try {
            return this.client.execute(sessionID, stmt.getBytes());
        }
        catch (TException e) {
            if (e instanceof TTransportException) {
                TTransportException te = (TTransportException)e;
                if (te.getType() == 4) {
                    throw new IOErrorException(2, te.getMessage());
                }
                if (te.getType() == 1) {
                    throw new IOErrorException(5, te.getMessage());
                }
                if (te.getType() == 3 || te.getMessage().contains("Read timed out")) {
                    this.reopen();
                    throw new IOErrorException(4, te.getMessage());
                }
            }
            throw new IOErrorException(0, e.getMessage());
        }
    }

    public void signout(long sessionId) {
        this.client.signout(sessionId);
    }

    @Override
    public boolean ping() {
        try {
            this.execute(0L, "YIELD 1;");
            return true;
        }
        catch (IOErrorException e) {
            return false;
        }
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }
}

