/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Row;
import com.vesoft.nebula.storage.EdgeProp;
import com.vesoft.nebula.storage.Expr;
import com.vesoft.nebula.storage.OrderBy;
import com.vesoft.nebula.storage.VertexProp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetPropRequest
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("GetPropRequest");
    private static final TField SPACE_ID_FIELD_DESC = new TField("space_id", 8, 1);
    private static final TField PARTS_FIELD_DESC = new TField("parts", 13, 2);
    private static final TField VERTEX_PROPS_FIELD_DESC = new TField("vertex_props", 15, 3);
    private static final TField EDGE_PROPS_FIELD_DESC = new TField("edge_props", 15, 4);
    private static final TField EXPRESSIONS_FIELD_DESC = new TField("expressions", 15, 5);
    private static final TField DEDUP_FIELD_DESC = new TField("dedup", 2, 6);
    private static final TField ORDER_BY_FIELD_DESC = new TField("order_by", 15, 7);
    private static final TField LIMIT_FIELD_DESC = new TField("limit", 10, 8);
    private static final TField FILTER_FIELD_DESC = new TField("filter", 11, 9);
    public int space_id;
    public Map<Integer, List<Row>> parts;
    public List<VertexProp> vertex_props;
    public List<EdgeProp> edge_props;
    public List<Expr> expressions;
    public boolean dedup;
    public List<OrderBy> order_by;
    public long limit;
    public byte[] filter;
    public static final int SPACE_ID = 1;
    public static final int PARTS = 2;
    public static final int VERTEX_PROPS = 3;
    public static final int EDGE_PROPS = 4;
    public static final int EXPRESSIONS = 5;
    public static final int DEDUP = 6;
    public static final int ORDER_BY = 7;
    public static final int LIMIT = 8;
    public static final int FILTER = 9;
    private static final int __SPACE_ID_ISSET_ID = 0;
    private static final int __DEDUP_ISSET_ID = 1;
    private static final int __LIMIT_ISSET_ID = 2;
    private BitSet __isset_bit_vector = new BitSet(3);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public GetPropRequest() {
        this.dedup = false;
    }

    public GetPropRequest(int space_id, Map<Integer, List<Row>> parts, boolean dedup) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.parts = parts;
        this.dedup = dedup;
        this.setDedupIsSet(true);
    }

    public GetPropRequest(int space_id, Map<Integer, List<Row>> parts, List<VertexProp> vertex_props, List<EdgeProp> edge_props, List<Expr> expressions, boolean dedup, List<OrderBy> order_by, long limit, byte[] filter) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.parts = parts;
        this.vertex_props = vertex_props;
        this.edge_props = edge_props;
        this.expressions = expressions;
        this.dedup = dedup;
        this.setDedupIsSet(true);
        this.order_by = order_by;
        this.limit = limit;
        this.setLimitIsSet(true);
        this.filter = filter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetPropRequest(GetPropRequest other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.space_id = TBaseHelper.deepCopy(other.space_id);
        if (other.isSetParts()) {
            this.parts = TBaseHelper.deepCopy(other.parts);
        }
        if (other.isSetVertex_props()) {
            this.vertex_props = TBaseHelper.deepCopy(other.vertex_props);
        }
        if (other.isSetEdge_props()) {
            this.edge_props = TBaseHelper.deepCopy(other.edge_props);
        }
        if (other.isSetExpressions()) {
            this.expressions = TBaseHelper.deepCopy(other.expressions);
        }
        this.dedup = TBaseHelper.deepCopy(other.dedup);
        if (other.isSetOrder_by()) {
            this.order_by = TBaseHelper.deepCopy(other.order_by);
        }
        this.limit = TBaseHelper.deepCopy(other.limit);
        if (other.isSetFilter()) {
            this.filter = TBaseHelper.deepCopy(other.filter);
        }
    }

    @Override
    public GetPropRequest deepCopy() {
        return new GetPropRequest(this);
    }

    public int getSpace_id() {
        return this.space_id;
    }

    public GetPropRequest setSpace_id(int space_id) {
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        return this;
    }

    public void unsetSpace_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSpace_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSpace_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public Map<Integer, List<Row>> getParts() {
        return this.parts;
    }

    public GetPropRequest setParts(Map<Integer, List<Row>> parts) {
        this.parts = parts;
        return this;
    }

    public void unsetParts() {
        this.parts = null;
    }

    public boolean isSetParts() {
        return this.parts != null;
    }

    public void setPartsIsSet(boolean __value) {
        if (!__value) {
            this.parts = null;
        }
    }

    public List<VertexProp> getVertex_props() {
        return this.vertex_props;
    }

    public GetPropRequest setVertex_props(List<VertexProp> vertex_props) {
        this.vertex_props = vertex_props;
        return this;
    }

    public void unsetVertex_props() {
        this.vertex_props = null;
    }

    public boolean isSetVertex_props() {
        return this.vertex_props != null;
    }

    public void setVertex_propsIsSet(boolean __value) {
        if (!__value) {
            this.vertex_props = null;
        }
    }

    public List<EdgeProp> getEdge_props() {
        return this.edge_props;
    }

    public GetPropRequest setEdge_props(List<EdgeProp> edge_props) {
        this.edge_props = edge_props;
        return this;
    }

    public void unsetEdge_props() {
        this.edge_props = null;
    }

    public boolean isSetEdge_props() {
        return this.edge_props != null;
    }

    public void setEdge_propsIsSet(boolean __value) {
        if (!__value) {
            this.edge_props = null;
        }
    }

    public List<Expr> getExpressions() {
        return this.expressions;
    }

    public GetPropRequest setExpressions(List<Expr> expressions) {
        this.expressions = expressions;
        return this;
    }

    public void unsetExpressions() {
        this.expressions = null;
    }

    public boolean isSetExpressions() {
        return this.expressions != null;
    }

    public void setExpressionsIsSet(boolean __value) {
        if (!__value) {
            this.expressions = null;
        }
    }

    public boolean isDedup() {
        return this.dedup;
    }

    public GetPropRequest setDedup(boolean dedup) {
        this.dedup = dedup;
        this.setDedupIsSet(true);
        return this;
    }

    public void unsetDedup() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetDedup() {
        return this.__isset_bit_vector.get(1);
    }

    public void setDedupIsSet(boolean __value) {
        this.__isset_bit_vector.set(1, __value);
    }

    public List<OrderBy> getOrder_by() {
        return this.order_by;
    }

    public GetPropRequest setOrder_by(List<OrderBy> order_by) {
        this.order_by = order_by;
        return this;
    }

    public void unsetOrder_by() {
        this.order_by = null;
    }

    public boolean isSetOrder_by() {
        return this.order_by != null;
    }

    public void setOrder_byIsSet(boolean __value) {
        if (!__value) {
            this.order_by = null;
        }
    }

    public long getLimit() {
        return this.limit;
    }

    public GetPropRequest setLimit(long limit) {
        this.limit = limit;
        this.setLimitIsSet(true);
        return this;
    }

    public void unsetLimit() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetLimit() {
        return this.__isset_bit_vector.get(2);
    }

    public void setLimitIsSet(boolean __value) {
        this.__isset_bit_vector.set(2, __value);
    }

    public byte[] getFilter() {
        return this.filter;
    }

    public GetPropRequest setFilter(byte[] filter) {
        this.filter = filter;
        return this;
    }

    public void unsetFilter() {
        this.filter = null;
    }

    public boolean isSetFilter() {
        return this.filter != null;
    }

    public void setFilterIsSet(boolean __value) {
        if (!__value) {
            this.filter = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetSpace_id();
                    break;
                }
                this.setSpace_id((Integer)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetParts();
                    break;
                }
                this.setParts((Map)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetVertex_props();
                    break;
                }
                this.setVertex_props((List)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetEdge_props();
                    break;
                }
                this.setEdge_props((List)__value);
                break;
            }
            case 5: {
                if (__value == null) {
                    this.unsetExpressions();
                    break;
                }
                this.setExpressions((List)__value);
                break;
            }
            case 6: {
                if (__value == null) {
                    this.unsetDedup();
                    break;
                }
                this.setDedup((Boolean)__value);
                break;
            }
            case 7: {
                if (__value == null) {
                    this.unsetOrder_by();
                    break;
                }
                this.setOrder_by((List)__value);
                break;
            }
            case 8: {
                if (__value == null) {
                    this.unsetLimit();
                    break;
                }
                this.setLimit((Long)__value);
                break;
            }
            case 9: {
                if (__value == null) {
                    this.unsetFilter();
                    break;
                }
                this.setFilter((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getSpace_id());
            }
            case 2: {
                return this.getParts();
            }
            case 3: {
                return this.getVertex_props();
            }
            case 4: {
                return this.getEdge_props();
            }
            case 5: {
                return this.getExpressions();
            }
            case 6: {
                return new Boolean(this.isDedup());
            }
            case 7: {
                return this.getOrder_by();
            }
            case 8: {
                return new Long(this.getLimit());
            }
            case 9: {
                return this.getFilter();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof GetPropRequest)) {
            return false;
        }
        GetPropRequest that = (GetPropRequest)_that;
        if (!TBaseHelper.equalsNobinary(this.space_id, that.space_id)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetParts(), that.isSetParts(), this.parts, that.parts)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetVertex_props(), that.isSetVertex_props(), this.vertex_props, that.vertex_props)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetEdge_props(), that.isSetEdge_props(), this.edge_props, that.edge_props)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetExpressions(), that.isSetExpressions(), this.expressions, that.expressions)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.dedup, that.dedup)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetOrder_by(), that.isSetOrder_by(), this.order_by, that.order_by)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLimit(), that.isSetLimit(), this.limit, that.limit)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetFilter(), that.isSetFilter(), this.filter, that.filter);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.space_id, this.parts, this.vertex_props, this.edge_props, this.expressions, this.dedup, this.order_by, this.limit, this.filter});
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.space_id = iprot.readI32();
                        this.setSpace_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 13) {
                        TMap _map49 = iprot.readMapBegin();
                        this.parts = new HashMap<Integer, List<Row>>(Math.max(0, 2 * _map49.size));
                        int _i50 = 0;
                        while (_map49.size < 0 ? iprot.peekMap() : _i50 < _map49.size) {
                            int _key51 = iprot.readI32();
                            TList _list53 = iprot.readListBegin();
                            ArrayList<Row> _val52 = new ArrayList<Row>(Math.max(0, _list53.size));
                            int _i54 = 0;
                            while (_list53.size < 0 ? iprot.peekList() : _i54 < _list53.size) {
                                Row _elem55 = new Row();
                                _elem55.read(iprot);
                                _val52.add(_elem55);
                                ++_i54;
                            }
                            iprot.readListEnd();
                            this.parts.put(_key51, _val52);
                            ++_i50;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 15) {
                        TList _list56 = iprot.readListBegin();
                        this.vertex_props = new ArrayList<VertexProp>(Math.max(0, _list56.size));
                        int _i57 = 0;
                        while (_list56.size < 0 ? iprot.peekList() : _i57 < _list56.size) {
                            VertexProp _elem58 = new VertexProp();
                            _elem58.read(iprot);
                            this.vertex_props.add(_elem58);
                            ++_i57;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 15) {
                        TList _list59 = iprot.readListBegin();
                        this.edge_props = new ArrayList<EdgeProp>(Math.max(0, _list59.size));
                        int _i60 = 0;
                        while (_list59.size < 0 ? iprot.peekList() : _i60 < _list59.size) {
                            EdgeProp _elem61 = new EdgeProp();
                            _elem61.read(iprot);
                            this.edge_props.add(_elem61);
                            ++_i60;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 5: {
                    if (__field.type == 15) {
                        TList _list62 = iprot.readListBegin();
                        this.expressions = new ArrayList<Expr>(Math.max(0, _list62.size));
                        int _i63 = 0;
                        while (_list62.size < 0 ? iprot.peekList() : _i63 < _list62.size) {
                            Expr _elem64 = new Expr();
                            _elem64.read(iprot);
                            this.expressions.add(_elem64);
                            ++_i63;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 6: {
                    if (__field.type == 2) {
                        this.dedup = iprot.readBool();
                        this.setDedupIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 7: {
                    if (__field.type == 15) {
                        TList _list65 = iprot.readListBegin();
                        this.order_by = new ArrayList<OrderBy>(Math.max(0, _list65.size));
                        int _i66 = 0;
                        while (_list65.size < 0 ? iprot.peekList() : _i66 < _list65.size) {
                            OrderBy _elem67 = new OrderBy();
                            _elem67.read(iprot);
                            this.order_by.add(_elem67);
                            ++_i66;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 8: {
                    if (__field.type == 10) {
                        this.limit = iprot.readI64();
                        this.setLimitIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 9: {
                    if (__field.type == 11) {
                        this.filter = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SPACE_ID_FIELD_DESC);
        oprot.writeI32(this.space_id);
        oprot.writeFieldEnd();
        if (this.parts != null) {
            oprot.writeFieldBegin(PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.parts.size()));
            for (Map.Entry<Integer, List<Row>> _iter68 : this.parts.entrySet()) {
                oprot.writeI32(_iter68.getKey());
                oprot.writeListBegin(new TList(12, _iter68.getValue().size()));
                for (Row _iter69 : _iter68.getValue()) {
                    _iter69.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.vertex_props != null && this.isSetVertex_props()) {
            oprot.writeFieldBegin(VERTEX_PROPS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.vertex_props.size()));
            for (VertexProp _iter70 : this.vertex_props) {
                _iter70.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.edge_props != null && this.isSetEdge_props()) {
            oprot.writeFieldBegin(EDGE_PROPS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.edge_props.size()));
            for (EdgeProp _iter71 : this.edge_props) {
                _iter71.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.expressions != null && this.isSetExpressions()) {
            oprot.writeFieldBegin(EXPRESSIONS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.expressions.size()));
            for (Expr _iter72 : this.expressions) {
                _iter72.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(DEDUP_FIELD_DESC);
        oprot.writeBool(this.dedup);
        oprot.writeFieldEnd();
        if (this.order_by != null && this.isSetOrder_by()) {
            oprot.writeFieldBegin(ORDER_BY_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.order_by.size()));
            for (OrderBy _iter73 : this.order_by) {
                _iter73.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.isSetLimit()) {
            oprot.writeFieldBegin(LIMIT_FIELD_DESC);
            oprot.writeI64(this.limit);
            oprot.writeFieldEnd();
        }
        if (this.filter != null && this.isSetFilter()) {
            oprot.writeFieldBegin(FILTER_FIELD_DESC);
            oprot.writeBinary(this.filter);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("GetPropRequest");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("space_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getSpace_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getParts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getParts(), indent + 1, prettyPrint));
        }
        first = false;
        if (this.isSetVertex_props()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("vertex_props");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVertex_props() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getVertex_props(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetEdge_props()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("edge_props");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getEdge_props() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getEdge_props(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetExpressions()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("expressions");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getExpressions() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getExpressions(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("dedup");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.isDedup(), indent + 1, prettyPrint));
        first = false;
        if (this.isSetOrder_by()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("order_by");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getOrder_by() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getOrder_by(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetLimit()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("limit");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getLimit(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.isSetFilter()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("filter");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getFilter() == null) {
                sb.append("null");
            } else {
                int __filter_size = Math.min(this.getFilter().length, 128);
                for (int i = 0; i < __filter_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getFilter()[i]).length() > 1 ? Integer.toHexString(this.getFilter()[i]).substring(Integer.toHexString(this.getFilter()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getFilter()[i]).toUpperCase());
                }
                if (this.getFilter().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("space_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("parts", 3, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new StructMetaData(12, Row.class)))));
        tmpMetaDataMap.put(3, new FieldMetaData("vertex_props", 2, new ListMetaData(15, new StructMetaData(12, VertexProp.class))));
        tmpMetaDataMap.put(4, new FieldMetaData("edge_props", 2, new ListMetaData(15, new StructMetaData(12, EdgeProp.class))));
        tmpMetaDataMap.put(5, new FieldMetaData("expressions", 2, new ListMetaData(15, new StructMetaData(12, Expr.class))));
        tmpMetaDataMap.put(6, new FieldMetaData("dedup", 3, new FieldValueMetaData(2)));
        tmpMetaDataMap.put(7, new FieldMetaData("order_by", 2, new ListMetaData(15, new StructMetaData(12, OrderBy.class))));
        tmpMetaDataMap.put(8, new FieldMetaData("limit", 2, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(9, new FieldMetaData("filter", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(GetPropRequest.class, metaDataMap);
    }

    public static class Builder {
        private int space_id;
        private Map<Integer, List<Row>> parts;
        private List<VertexProp> vertex_props;
        private List<EdgeProp> edge_props;
        private List<Expr> expressions;
        private boolean dedup;
        private List<OrderBy> order_by;
        private long limit;
        private byte[] filter;
        BitSet __optional_isset = new BitSet(3);

        public Builder setSpace_id(int space_id) {
            this.space_id = space_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setParts(Map<Integer, List<Row>> parts) {
            this.parts = parts;
            return this;
        }

        public Builder setVertex_props(List<VertexProp> vertex_props) {
            this.vertex_props = vertex_props;
            return this;
        }

        public Builder setEdge_props(List<EdgeProp> edge_props) {
            this.edge_props = edge_props;
            return this;
        }

        public Builder setExpressions(List<Expr> expressions) {
            this.expressions = expressions;
            return this;
        }

        public Builder setDedup(boolean dedup) {
            this.dedup = dedup;
            this.__optional_isset.set(1, true);
            return this;
        }

        public Builder setOrder_by(List<OrderBy> order_by) {
            this.order_by = order_by;
            return this;
        }

        public Builder setLimit(long limit) {
            this.limit = limit;
            this.__optional_isset.set(2, true);
            return this;
        }

        public Builder setFilter(byte[] filter) {
            this.filter = filter;
            return this;
        }

        public GetPropRequest build() {
            GetPropRequest result = new GetPropRequest();
            if (this.__optional_isset.get(0)) {
                result.setSpace_id(this.space_id);
            }
            result.setParts(this.parts);
            result.setVertex_props(this.vertex_props);
            result.setEdge_props(this.edge_props);
            result.setExpressions(this.expressions);
            if (this.__optional_isset.get(1)) {
                result.setDedup(this.dedup);
            }
            result.setOrder_by(this.order_by);
            if (this.__optional_isset.get(2)) {
                result.setLimit(this.limit);
            }
            result.setFilter(this.filter);
            return result;
        }
    }
}

