/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.HostRole;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class HBReq
implements TBase,
Serializable,
Cloneable,
Comparable<HBReq> {
    private static final TStruct STRUCT_DESC = new TStruct("HBReq");
    private static final TField ROLE_FIELD_DESC = new TField("role", 8, 1);
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 2);
    private static final TField CLUSTER_ID_FIELD_DESC = new TField("cluster_id", 10, 3);
    private static final TField LEADER_PART_IDS_FIELD_DESC = new TField("leader_partIds", 13, 4);
    private static final TField GIT_INFO_SHA_FIELD_DESC = new TField("git_info_sha", 11, 5);
    public int role;
    public HostAddr host;
    public long cluster_id;
    public Map<Integer, List<Integer>> leader_partIds;
    public byte[] git_info_sha;
    public static final int ROLE = 1;
    public static final int HOST = 2;
    public static final int CLUSTER_ID = 3;
    public static final int LEADER_PARTIDS = 4;
    public static final int GIT_INFO_SHA = 5;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __ROLE_ISSET_ID = 0;
    private static final int __CLUSTER_ID_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public HBReq() {
    }

    public HBReq(int role, HostAddr host, long cluster_id, byte[] git_info_sha) {
        this();
        this.role = role;
        this.setRoleIsSet(true);
        this.host = host;
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        this.git_info_sha = git_info_sha;
    }

    public HBReq(int role, HostAddr host, long cluster_id, Map<Integer, List<Integer>> leader_partIds, byte[] git_info_sha) {
        this();
        this.role = role;
        this.setRoleIsSet(true);
        this.host = host;
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        this.leader_partIds = leader_partIds;
        this.git_info_sha = git_info_sha;
    }

    public HBReq(HBReq other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.role = TBaseHelper.deepCopy(other.role);
        if (other.isSetHost()) {
            this.host = TBaseHelper.deepCopy(other.host);
        }
        this.cluster_id = TBaseHelper.deepCopy(other.cluster_id);
        if (other.isSetLeader_partIds()) {
            this.leader_partIds = TBaseHelper.deepCopy(other.leader_partIds);
        }
        if (other.isSetGit_info_sha()) {
            this.git_info_sha = TBaseHelper.deepCopy(other.git_info_sha);
        }
    }

    @Override
    public HBReq deepCopy() {
        return new HBReq(this);
    }

    @Deprecated
    public HBReq clone() {
        return new HBReq(this);
    }

    public int getRole() {
        return this.role;
    }

    public HBReq setRole(int role) {
        this.role = role;
        this.setRoleIsSet(true);
        return this;
    }

    public void unsetRole() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetRole() {
        return this.__isset_bit_vector.get(0);
    }

    public void setRoleIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public HostAddr getHost() {
        return this.host;
    }

    public HBReq setHost(HostAddr host) {
        this.host = host;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean value) {
        if (!value) {
            this.host = null;
        }
    }

    public long getCluster_id() {
        return this.cluster_id;
    }

    public HBReq setCluster_id(long cluster_id) {
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        return this;
    }

    public void unsetCluster_id() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetCluster_id() {
        return this.__isset_bit_vector.get(1);
    }

    public void setCluster_idIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public Map<Integer, List<Integer>> getLeader_partIds() {
        return this.leader_partIds;
    }

    public HBReq setLeader_partIds(Map<Integer, List<Integer>> leader_partIds) {
        this.leader_partIds = leader_partIds;
        return this;
    }

    public void unsetLeader_partIds() {
        this.leader_partIds = null;
    }

    public boolean isSetLeader_partIds() {
        return this.leader_partIds != null;
    }

    public void setLeader_partIdsIsSet(boolean value) {
        if (!value) {
            this.leader_partIds = null;
        }
    }

    public byte[] getGit_info_sha() {
        return this.git_info_sha;
    }

    public HBReq setGit_info_sha(byte[] git_info_sha) {
        this.git_info_sha = git_info_sha;
        return this;
    }

    public void unsetGit_info_sha() {
        this.git_info_sha = null;
    }

    public boolean isSetGit_info_sha() {
        return this.git_info_sha != null;
    }

    public void setGit_info_shaIsSet(boolean value) {
        if (!value) {
            this.git_info_sha = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetRole();
                    break;
                }
                this.setRole((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((HostAddr)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetCluster_id();
                    break;
                }
                this.setCluster_id((Long)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetLeader_partIds();
                    break;
                }
                this.setLeader_partIds((Map)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetGit_info_sha();
                    break;
                }
                this.setGit_info_sha((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getRole();
            }
            case 2: {
                return this.getHost();
            }
            case 3: {
                return new Long(this.getCluster_id());
            }
            case 4: {
                return this.getLeader_partIds();
            }
            case 5: {
                return this.getGit_info_sha();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetRole();
            }
            case 2: {
                return this.isSetHost();
            }
            case 3: {
                return this.isSetCluster_id();
            }
            case 4: {
                return this.isSetLeader_partIds();
            }
            case 5: {
                return this.isSetGit_info_sha();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof HBReq) {
            return this.equals((HBReq)that);
        }
        return false;
    }

    public boolean equals(HBReq that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_role = true;
        boolean that_present_role = true;
        if (this_present_role || that_present_role) {
            if (!this_present_role || !that_present_role) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.role, that.role)) {
                return false;
            }
        }
        boolean this_present_host = this.isSetHost();
        boolean that_present_host = that.isSetHost();
        if (this_present_host || that_present_host) {
            if (!this_present_host || !that_present_host) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.host, that.host)) {
                return false;
            }
        }
        boolean this_present_cluster_id = true;
        boolean that_present_cluster_id = true;
        if (this_present_cluster_id || that_present_cluster_id) {
            if (!this_present_cluster_id || !that_present_cluster_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.cluster_id, that.cluster_id)) {
                return false;
            }
        }
        boolean this_present_leader_partIds = this.isSetLeader_partIds();
        boolean that_present_leader_partIds = that.isSetLeader_partIds();
        if (this_present_leader_partIds || that_present_leader_partIds) {
            if (!this_present_leader_partIds || !that_present_leader_partIds) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.leader_partIds, that.leader_partIds)) {
                return false;
            }
        }
        boolean this_present_git_info_sha = this.isSetGit_info_sha();
        boolean that_present_git_info_sha = that.isSetGit_info_sha();
        if (this_present_git_info_sha || that_present_git_info_sha) {
            if (!this_present_git_info_sha || !that_present_git_info_sha) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.git_info_sha, that.git_info_sha)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_role = true;
        builder.append(present_role);
        if (present_role) {
            builder.append(this.role);
        }
        boolean present_host = this.isSetHost();
        builder.append(present_host);
        if (present_host) {
            builder.append((Object)this.host);
        }
        boolean present_cluster_id = true;
        builder.append(present_cluster_id);
        if (present_cluster_id) {
            builder.append(this.cluster_id);
        }
        boolean present_leader_partIds = this.isSetLeader_partIds();
        builder.append(present_leader_partIds);
        if (present_leader_partIds) {
            builder.append(this.leader_partIds);
        }
        boolean present_git_info_sha = this.isSetGit_info_sha();
        builder.append(present_git_info_sha);
        if (present_git_info_sha) {
            builder.append(this.git_info_sha);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(HBReq other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRole()).compareTo(other.isSetRole());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.role, other.role);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHost()).compareTo(other.isSetHost());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCluster_id()).compareTo(other.isSetCluster_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.cluster_id, other.cluster_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader_partIds()).compareTo(other.isSetLeader_partIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader_partIds, other.leader_partIds);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGit_info_sha()).compareTo(other.isSetGit_info_sha());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.git_info_sha, other.git_info_sha);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.role = iprot.readI32();
                        this.setRoleIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 12) {
                        this.host = new HostAddr();
                        this.host.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 10) {
                        this.cluster_id = iprot.readI64();
                        this.setCluster_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 13) {
                        TMap _map126 = iprot.readMapBegin();
                        this.leader_partIds = new HashMap<Integer, List<Integer>>(Math.max(0, 2 * _map126.size));
                        int _i127 = 0;
                        while (_map126.size < 0 ? iprot.peekMap() : _i127 < _map126.size) {
                            int _key128 = iprot.readI32();
                            TList _list130 = iprot.readListBegin();
                            ArrayList<Integer> _val129 = new ArrayList<Integer>(Math.max(0, _list130.size));
                            int _i131 = 0;
                            while (_list130.size < 0 ? iprot.peekList() : _i131 < _list130.size) {
                                int _elem132 = iprot.readI32();
                                _val129.add(_elem132);
                                ++_i131;
                            }
                            iprot.readListEnd();
                            this.leader_partIds.put(_key128, _val129);
                            ++_i127;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 11) {
                        this.git_info_sha = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(ROLE_FIELD_DESC);
        oprot.writeI32(this.role);
        oprot.writeFieldEnd();
        if (this.host != null) {
            oprot.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(CLUSTER_ID_FIELD_DESC);
        oprot.writeI64(this.cluster_id);
        oprot.writeFieldEnd();
        if (this.leader_partIds != null && this.isSetLeader_partIds()) {
            oprot.writeFieldBegin(LEADER_PART_IDS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.leader_partIds.size()));
            for (Map.Entry<Integer, List<Integer>> _iter133 : this.leader_partIds.entrySet()) {
                oprot.writeI32(_iter133.getKey());
                oprot.writeListBegin(new TList(8, _iter133.getValue().size()));
                for (int _iter134 : _iter133.getValue()) {
                    oprot.writeI32(_iter134);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.git_info_sha != null) {
            oprot.writeFieldBegin(GIT_INFO_SHA_FIELD_DESC);
            oprot.writeBinary(this.git_info_sha);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("HBReq");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("role");
        sb.append(space);
        sb.append(":").append(space);
        String role_name = HostRole.VALUES_TO_NAMES.get(this.getRole());
        if (role_name != null) {
            sb.append(role_name);
            sb.append(" (");
        }
        sb.append(this.getRole());
        if (role_name != null) {
            sb.append(")");
        }
        if (!(first = false)) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("host");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("cluster_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getCluster_id(), indent + 1, prettyPrint));
        first = false;
        if (this.isSetLeader_partIds()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("leader_partIds");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getLeader_partIds() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getLeader_partIds(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("git_info_sha");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getGit_info_sha() == null) {
            sb.append("null");
        } else {
            int __git_info_sha_size = Math.min(this.getGit_info_sha().length, 128);
            for (int i = 0; i < __git_info_sha_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getGit_info_sha()[i]).length() > 1 ? Integer.toHexString(this.getGit_info_sha()[i]).substring(Integer.toHexString(this.getGit_info_sha()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getGit_info_sha()[i]).toUpperCase());
            }
            if (this.getGit_info_sha().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetRole() && !HostRole.VALID_VALUES.contains(this.role)) {
            throw new TProtocolException("The field 'role' has been assigned the invalid value " + this.role);
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("role", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("host", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("cluster_id", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(4, new FieldMetaData("leader_partIds", 2, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new FieldValueMetaData(8)))));
        tmpMetaDataMap.put(5, new FieldMetaData("git_info_sha", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(HBReq.class, metaDataMap);
    }
}

