/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.StatType;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class StatProp
implements TBase,
Serializable,
Cloneable,
Comparable<StatProp> {
    private static final TStruct STRUCT_DESC = new TStruct("StatProp");
    private static final TField ALIAS_FIELD_DESC = new TField("alias", 11, 1);
    private static final TField PROP_FIELD_DESC = new TField("prop", 11, 2);
    private static final TField STAT_FIELD_DESC = new TField("stat", 8, 3);
    public byte[] alias;
    public byte[] prop;
    public int stat;
    public static final int ALIAS = 1;
    public static final int PROP = 2;
    public static final int STAT = 3;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __STAT_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public StatProp() {
    }

    public StatProp(byte[] alias, byte[] prop, int stat) {
        this();
        this.alias = alias;
        this.prop = prop;
        this.stat = stat;
        this.setStatIsSet(true);
    }

    public StatProp(StatProp other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetAlias()) {
            this.alias = TBaseHelper.deepCopy(other.alias);
        }
        if (other.isSetProp()) {
            this.prop = TBaseHelper.deepCopy(other.prop);
        }
        this.stat = TBaseHelper.deepCopy(other.stat);
    }

    @Override
    public StatProp deepCopy() {
        return new StatProp(this);
    }

    @Deprecated
    public StatProp clone() {
        return new StatProp(this);
    }

    public byte[] getAlias() {
        return this.alias;
    }

    public StatProp setAlias(byte[] alias) {
        this.alias = alias;
        return this;
    }

    public void unsetAlias() {
        this.alias = null;
    }

    public boolean isSetAlias() {
        return this.alias != null;
    }

    public void setAliasIsSet(boolean value) {
        if (!value) {
            this.alias = null;
        }
    }

    public byte[] getProp() {
        return this.prop;
    }

    public StatProp setProp(byte[] prop) {
        this.prop = prop;
        return this;
    }

    public void unsetProp() {
        this.prop = null;
    }

    public boolean isSetProp() {
        return this.prop != null;
    }

    public void setPropIsSet(boolean value) {
        if (!value) {
            this.prop = null;
        }
    }

    public int getStat() {
        return this.stat;
    }

    public StatProp setStat(int stat) {
        this.stat = stat;
        this.setStatIsSet(true);
        return this;
    }

    public void unsetStat() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetStat() {
        return this.__isset_bit_vector.get(0);
    }

    public void setStatIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetAlias();
                    break;
                }
                this.setAlias((byte[])value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetProp();
                    break;
                }
                this.setProp((byte[])value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetStat();
                    break;
                }
                this.setStat((Integer)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getAlias();
            }
            case 2: {
                return this.getProp();
            }
            case 3: {
                return this.getStat();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetAlias();
            }
            case 2: {
                return this.isSetProp();
            }
            case 3: {
                return this.isSetStat();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof StatProp) {
            return this.equals((StatProp)that);
        }
        return false;
    }

    public boolean equals(StatProp that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_alias = this.isSetAlias();
        boolean that_present_alias = that.isSetAlias();
        if (this_present_alias || that_present_alias) {
            if (!this_present_alias || !that_present_alias) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.alias, that.alias)) {
                return false;
            }
        }
        boolean this_present_prop = this.isSetProp();
        boolean that_present_prop = that.isSetProp();
        if (this_present_prop || that_present_prop) {
            if (!this_present_prop || !that_present_prop) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.prop, that.prop)) {
                return false;
            }
        }
        boolean this_present_stat = true;
        boolean that_present_stat = true;
        if (this_present_stat || that_present_stat) {
            if (!this_present_stat || !that_present_stat) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.stat, that.stat)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_alias = this.isSetAlias();
        builder.append(present_alias);
        if (present_alias) {
            builder.append(this.alias);
        }
        boolean present_prop = this.isSetProp();
        builder.append(present_prop);
        if (present_prop) {
            builder.append(this.prop);
        }
        boolean present_stat = true;
        builder.append(present_stat);
        if (present_stat) {
            builder.append(this.stat);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(StatProp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetAlias()).compareTo(other.isSetAlias());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.alias, other.alias);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProp()).compareTo(other.isSetProp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.prop, other.prop);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStat()).compareTo(other.isSetStat());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.stat, other.stat);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.alias = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.prop = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.stat = iprot.readI32();
                        this.setStatIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.alias != null) {
            oprot.writeFieldBegin(ALIAS_FIELD_DESC);
            oprot.writeBinary(this.alias);
            oprot.writeFieldEnd();
        }
        if (this.prop != null) {
            oprot.writeFieldBegin(PROP_FIELD_DESC);
            oprot.writeBinary(this.prop);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(STAT_FIELD_DESC);
        oprot.writeI32(this.stat);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("StatProp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("alias");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getAlias() == null) {
            sb.append("null");
        } else {
            int __alias_size = Math.min(this.getAlias().length, 128);
            for (i = 0; i < __alias_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getAlias()[i]).length() > 1 ? Integer.toHexString(this.getAlias()[i]).substring(Integer.toHexString(this.getAlias()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getAlias()[i]).toUpperCase());
            }
            if (this.getAlias().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("prop");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getProp() == null) {
            sb.append("null");
        } else {
            int __prop_size = Math.min(this.getProp().length, 128);
            for (i = 0; i < __prop_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getProp()[i]).length() > 1 ? Integer.toHexString(this.getProp()[i]).substring(Integer.toHexString(this.getProp()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getProp()[i]).toUpperCase());
            }
            if (this.getProp().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("stat");
        sb.append(space);
        sb.append(":").append(space);
        String stat_name = StatType.VALUES_TO_NAMES.get(this.getStat());
        if (stat_name != null) {
            sb.append(stat_name);
            sb.append(" (");
        }
        sb.append(this.getStat());
        if (stat_name != null) {
            sb.append(")");
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetStat() && !StatType.VALID_VALUES.contains(this.stat)) {
            throw new TProtocolException("The field 'stat' has been assigned the invalid value " + this.stat);
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("alias", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("prop", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(3, new FieldMetaData("stat", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(StatProp.class, metaDataMap);
    }
}

