/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.IndexColumnHint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IndexQueryContext
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("IndexQueryContext");
    private static final TField INDEX_ID_FIELD_DESC = new TField("index_id", 8, 1);
    private static final TField FILTER_FIELD_DESC = new TField("filter", 11, 2);
    private static final TField COLUMN_HINTS_FIELD_DESC = new TField("column_hints", 15, 3);
    public int index_id;
    public byte[] filter;
    public List<IndexColumnHint> column_hints;
    public static final int INDEX_ID = 1;
    public static final int FILTER = 2;
    public static final int COLUMN_HINTS = 3;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __INDEX_ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public IndexQueryContext() {
    }

    public IndexQueryContext(int index_id, byte[] filter, List<IndexColumnHint> column_hints) {
        this();
        this.index_id = index_id;
        this.setIndex_idIsSet(true);
        this.filter = filter;
        this.column_hints = column_hints;
    }

    public IndexQueryContext(IndexQueryContext other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.index_id = TBaseHelper.deepCopy(other.index_id);
        if (other.isSetFilter()) {
            this.filter = TBaseHelper.deepCopy(other.filter);
        }
        if (other.isSetColumn_hints()) {
            this.column_hints = TBaseHelper.deepCopy(other.column_hints);
        }
    }

    @Override
    public IndexQueryContext deepCopy() {
        return new IndexQueryContext(this);
    }

    @Deprecated
    public IndexQueryContext clone() {
        return new IndexQueryContext(this);
    }

    public int getIndex_id() {
        return this.index_id;
    }

    public IndexQueryContext setIndex_id(int index_id) {
        this.index_id = index_id;
        this.setIndex_idIsSet(true);
        return this;
    }

    public void unsetIndex_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetIndex_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setIndex_idIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public byte[] getFilter() {
        return this.filter;
    }

    public IndexQueryContext setFilter(byte[] filter) {
        this.filter = filter;
        return this;
    }

    public void unsetFilter() {
        this.filter = null;
    }

    public boolean isSetFilter() {
        return this.filter != null;
    }

    public void setFilterIsSet(boolean value) {
        if (!value) {
            this.filter = null;
        }
    }

    public List<IndexColumnHint> getColumn_hints() {
        return this.column_hints;
    }

    public IndexQueryContext setColumn_hints(List<IndexColumnHint> column_hints) {
        this.column_hints = column_hints;
        return this;
    }

    public void unsetColumn_hints() {
        this.column_hints = null;
    }

    public boolean isSetColumn_hints() {
        return this.column_hints != null;
    }

    public void setColumn_hintsIsSet(boolean value) {
        if (!value) {
            this.column_hints = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetIndex_id();
                    break;
                }
                this.setIndex_id((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetFilter();
                    break;
                }
                this.setFilter((byte[])value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetColumn_hints();
                    break;
                }
                this.setColumn_hints((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getIndex_id());
            }
            case 2: {
                return this.getFilter();
            }
            case 3: {
                return this.getColumn_hints();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetIndex_id();
            }
            case 2: {
                return this.isSetFilter();
            }
            case 3: {
                return this.isSetColumn_hints();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof IndexQueryContext) {
            return this.equals((IndexQueryContext)that);
        }
        return false;
    }

    public boolean equals(IndexQueryContext that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_index_id = true;
        boolean that_present_index_id = true;
        if (this_present_index_id || that_present_index_id) {
            if (!this_present_index_id || !that_present_index_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.index_id, that.index_id)) {
                return false;
            }
        }
        boolean this_present_filter = this.isSetFilter();
        boolean that_present_filter = that.isSetFilter();
        if (this_present_filter || that_present_filter) {
            if (!this_present_filter || !that_present_filter) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.filter, that.filter)) {
                return false;
            }
        }
        boolean this_present_column_hints = this.isSetColumn_hints();
        boolean that_present_column_hints = that.isSetColumn_hints();
        if (this_present_column_hints || that_present_column_hints) {
            if (!this_present_column_hints || !that_present_column_hints) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.column_hints, that.column_hints)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_index_id = true;
        builder.append(present_index_id);
        if (present_index_id) {
            builder.append(this.index_id);
        }
        boolean present_filter = this.isSetFilter();
        builder.append(present_filter);
        if (present_filter) {
            builder.append(this.filter);
        }
        boolean present_column_hints = this.isSetColumn_hints();
        builder.append(present_column_hints);
        if (present_column_hints) {
            builder.append(this.column_hints);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.index_id = iprot.readI32();
                        this.setIndex_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.filter = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 15) {
                        TList _list151 = iprot.readListBegin();
                        this.column_hints = new ArrayList<IndexColumnHint>(Math.max(0, _list151.size));
                        int _i152 = 0;
                        while (_list151.size < 0 ? iprot.peekList() : _i152 < _list151.size) {
                            IndexColumnHint _elem153 = new IndexColumnHint();
                            _elem153.read(iprot);
                            this.column_hints.add(_elem153);
                            ++_i152;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(INDEX_ID_FIELD_DESC);
        oprot.writeI32(this.index_id);
        oprot.writeFieldEnd();
        if (this.filter != null) {
            oprot.writeFieldBegin(FILTER_FIELD_DESC);
            oprot.writeBinary(this.filter);
            oprot.writeFieldEnd();
        }
        if (this.column_hints != null) {
            oprot.writeFieldBegin(COLUMN_HINTS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.column_hints.size()));
            for (IndexColumnHint _iter154 : this.column_hints) {
                _iter154.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("IndexQueryContext");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("index_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getIndex_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("filter");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getFilter() == null) {
            sb.append("null");
        } else {
            int __filter_size = Math.min(this.getFilter().length, 128);
            for (int i = 0; i < __filter_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getFilter()[i]).length() > 1 ? Integer.toHexString(this.getFilter()[i]).substring(Integer.toHexString(this.getFilter()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getFilter()[i]).toUpperCase());
            }
            if (this.getFilter().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("column_hints");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getColumn_hints() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getColumn_hints(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("index_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("filter", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(3, new FieldMetaData("column_hints", 3, new ListMetaData(15, new StructMetaData(12, IndexColumnHint.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(IndexQueryContext.class, metaDataMap);
    }
}

