/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.meta.AlterSchemaOp;
import com.vesoft.nebula.meta.Schema;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AlterSchemaItem
implements TBase,
Serializable,
Cloneable,
Comparable<AlterSchemaItem> {
    private static final TStruct STRUCT_DESC = new TStruct("AlterSchemaItem");
    private static final TField OP_FIELD_DESC = new TField("op", 8, 1);
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 12, 2);
    public int op;
    public Schema schema;
    public static final int OP = 1;
    public static final int SCHEMA = 2;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __OP_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public AlterSchemaItem() {
    }

    public AlterSchemaItem(int op, Schema schema) {
        this();
        this.op = op;
        this.setOpIsSet(true);
        this.schema = schema;
    }

    public AlterSchemaItem(AlterSchemaItem other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.op = TBaseHelper.deepCopy(other.op);
        if (other.isSetSchema()) {
            this.schema = TBaseHelper.deepCopy(other.schema);
        }
    }

    @Override
    public AlterSchemaItem deepCopy() {
        return new AlterSchemaItem(this);
    }

    @Deprecated
    public AlterSchemaItem clone() {
        return new AlterSchemaItem(this);
    }

    public int getOp() {
        return this.op;
    }

    public AlterSchemaItem setOp(int op) {
        this.op = op;
        this.setOpIsSet(true);
        return this;
    }

    public void unsetOp() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetOp() {
        return this.__isset_bit_vector.get(0);
    }

    public void setOpIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public AlterSchemaItem setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean value) {
        if (!value) {
            this.schema = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetOp();
                    break;
                }
                this.setOp((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((Schema)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getOp();
            }
            case 2: {
                return this.getSchema();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetOp();
            }
            case 2: {
                return this.isSetSchema();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof AlterSchemaItem) {
            return this.equals((AlterSchemaItem)that);
        }
        return false;
    }

    public boolean equals(AlterSchemaItem that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_op = true;
        boolean that_present_op = true;
        if (this_present_op || that_present_op) {
            if (!this_present_op || !that_present_op) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.op, that.op)) {
                return false;
            }
        }
        boolean this_present_schema = this.isSetSchema();
        boolean that_present_schema = that.isSetSchema();
        if (this_present_schema || that_present_schema) {
            if (!this_present_schema || !that_present_schema) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.schema, that.schema)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_op = true;
        builder.append(present_op);
        if (present_op) {
            builder.append(this.op);
        }
        boolean present_schema = this.isSetSchema();
        builder.append(present_schema);
        if (present_schema) {
            builder.append((Object)this.schema);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(AlterSchemaItem other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetOp()).compareTo(other.isSetOp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.op, other.op);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchema()).compareTo(other.isSetSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.schema, other.schema);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.op = iprot.readI32();
                        this.setOpIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 12) {
                        this.schema = new Schema();
                        this.schema.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(OP_FIELD_DESC);
        oprot.writeI32(this.op);
        oprot.writeFieldEnd();
        if (this.schema != null) {
            oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
            this.schema.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("AlterSchemaItem");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("op");
        sb.append(space);
        sb.append(":").append(space);
        String op_name = AlterSchemaOp.VALUES_TO_NAMES.get(this.getOp());
        if (op_name != null) {
            sb.append(op_name);
            sb.append(" (");
        }
        sb.append(this.getOp());
        if (op_name != null) {
            sb.append(")");
        }
        if (!(first = false)) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("schema");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getSchema() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getSchema(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetOp() && !AlterSchemaOp.VALID_VALUES.contains(this.op)) {
            throw new TProtocolException("The field 'op' has been assigned the invalid value " + this.op);
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("op", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("schema", 3, new StructMetaData(12, Schema.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(AlterSchemaItem.class, metaDataMap);
    }
}

