/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.scan;

import com.vesoft.nebula.DataSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.client.storage.data.ScanStatus;
import com.vesoft.nebula.client.storage.data.VertexRow;
import com.vesoft.nebula.client.storage.data.VertexTableRow;
import com.vesoft.nebula.client.storage.processor.VertexProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanVertexResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanVertexResult.class);
    private final List<DataSet> dataSets;
    private final ScanStatus scanStatus;
    private List<VertexTableRow> vertexTableRows;
    private List<String> propNames;
    private List<VertexRow> verticeRows;
    private Map<ValueWrapper, VertexRow> vidVertices;
    private String decodeType = "utf-8";

    public ScanVertexResult(List<DataSet> dataSets, ScanStatus status) {
        this.dataSets = dataSets;
        this.scanStatus = status;
    }

    public List<VertexTableRow> getVertexTableRows() {
        if (this.vertexTableRows == null) {
            this.constructVertexTableRow();
        }
        return this.vertexTableRows;
    }

    public List<String> getPropNames() {
        if (this.propNames == null) {
            this.constrcutPropNames();
        }
        return this.propNames;
    }

    public VertexRow getVertex(ValueWrapper vid) {
        if (this.vidVertices == null) {
            this.constructVertexRow();
        }
        if (this.vidVertices.isEmpty()) {
            return null;
        }
        return this.vidVertices.get(vid);
    }

    public List<VertexRow> getVertices() {
        if (this.verticeRows == null) {
            this.constructVertexRow();
        }
        return this.verticeRows;
    }

    public Map<ValueWrapper, VertexRow> getVidVertices() {
        if (this.vidVertices == null) {
            this.constructVertexRow();
        }
        return this.vidVertices;
    }

    public boolean isAllSuccess() {
        return this.scanStatus == ScanStatus.ALL_SUCCESS;
    }

    public boolean isEmpty() {
        if (this.dataSets == null || this.dataSets.isEmpty()) {
            return true;
        }
        for (DataSet dataSet : this.dataSets) {
            if (dataSet.getRows().size() <= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructVertexRow() {
        if (this.dataSets.isEmpty()) {
            return;
        }
        ScanVertexResult scanVertexResult = this;
        synchronized (scanVertexResult) {
            if (this.vidVertices == null) {
                this.vidVertices = VertexProcessor.constructVertexRow(this.dataSets, this.decodeType);
                this.verticeRows = new ArrayList<VertexRow>(this.vidVertices.values());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructVertexTableRow() {
        if (this.dataSets.isEmpty()) {
            return;
        }
        ScanVertexResult scanVertexResult = this;
        synchronized (scanVertexResult) {
            if (this.vertexTableRows == null) {
                this.vertexTableRows = VertexProcessor.constructVertexTableRow(this.dataSets, this.decodeType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constrcutPropNames() {
        if (this.dataSets.isEmpty()) {
            return;
        }
        ScanVertexResult scanVertexResult = this;
        synchronized (scanVertexResult) {
            if (this.propNames == null) {
                this.propNames = new ArrayList<String>();
                List<byte[]> colNames = this.dataSets.get(0).getColumn_names();
                for (byte[] colName : colNames) {
                    String name = new String(colName).split("\\.")[1];
                    this.propNames.add(name);
                }
            }
        }
    }
}

