/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.storage.GraphStorageConnection;
import com.vesoft.nebula.client.storage.StorageConnPoolFactory;
import com.vesoft.nebula.client.storage.StoragePoolConfig;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageConnPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageConnPool.class);
    private final GenericKeyedObjectPool<HostAddress, GraphStorageConnection> keyedPool;
    private final StorageConnPoolFactory poolFactory;

    public StorageConnPool(StoragePoolConfig config) {
        this.poolFactory = new StorageConnPoolFactory(config);
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMaxIdlePerKey(config.getMaxConnsSize());
        poolConfig.setMinIdlePerKey(config.getMinConnsSize());
        poolConfig.setMinEvictableIdleTimeMillis(config.getIdleTime() <= 0 ? Long.MAX_VALUE : (long)config.getIdleTime());
        poolConfig.setMaxTotal(config.getMaxTotal());
        poolConfig.setMaxTotalPerKey(config.getMaxTotalPerKey());
        this.keyedPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)this.poolFactory);
        this.keyedPool.setConfig(poolConfig);
    }

    public void close() {
        this.keyedPool.close();
    }

    public GraphStorageConnection getStorageConnection(HostAddress address) throws Exception {
        return (GraphStorageConnection)this.keyedPool.borrowObject((Object)address);
    }

    public void release(HostAddress address, GraphStorageConnection connection) {
        this.keyedPool.returnObject((Object)address, (Object)connection);
    }

    public int getNumActive(HostAddress address) {
        return this.keyedPool.getNumActive((Object)address);
    }

    public int get(HostAddress address) {
        return this.keyedPool.getNumIdle((Object)address);
    }
}

