/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.ConnObjectPool;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import com.vesoft.nebula.graph.ExecutionResponse;
import java.io.UnsupportedEncodingException;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private final long sessionID;
    private SyncConnection connection;
    private final GenericObjectPool<SyncConnection> pool;
    private final Boolean retryConnect;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Session(SyncConnection connection, long sessionID, GenericObjectPool<SyncConnection> connPool, Boolean retryConnect) {
        this.connection = connection;
        this.sessionID = sessionID;
        this.pool = connPool;
        this.retryConnect = retryConnect;
    }

    public ResultSet execute(String stmt) throws IOErrorException, UnsupportedEncodingException {
        try {
            if (this.connection == null) {
                throw new IOErrorException(2, "Connection is null");
            }
            ExecutionResponse resp = this.connection.execute(this.sessionID, stmt);
            return new ResultSet(resp);
        }
        catch (IOErrorException ie) {
            if (ie.getType() == 2) {
                if (this.pool.getFactory() instanceof ConnObjectPool) {
                    ((ConnObjectPool)this.pool.getFactory()).updateServerStatus();
                }
                if (this.retryConnect.booleanValue()) {
                    if (this.retryConnect()) {
                        ExecutionResponse resp = this.connection.execute(this.sessionID, stmt);
                        return new ResultSet(resp);
                    }
                    throw new IOErrorException(1, "All servers are broken.");
                }
            }
            throw ie;
        }
    }

    private boolean retryConnect() {
        try {
            try {
                this.pool.invalidateObject(this.connection);
            }
            catch (Exception e) {
                this.log.error("Return object failed");
            }
            SyncConnection newConn = this.pool.borrowObject();
            if (newConn == null) {
                this.log.error("Get connection object failed.");
            }
            this.connection = newConn;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean ping() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.ping();
    }

    public void release() {
        if (this.connection == null) {
            return;
        }
        this.connection.signout(this.sessionID);
        try {
            this.pool.returnObject(this.connection);
        }
        catch (Exception e) {
            this.log.warn("Return object to pool failed.");
        }
    }
}

