/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Edge;
import com.vesoft.nebula.Path;
import com.vesoft.nebula.Step;
import com.vesoft.nebula.client.graph.data.Node;
import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.exception.InvalidValueException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public class PathWrapper
implements Iterable<Segment> {
    private List<Segment> segments = new ArrayList<Segment>();
    private List<Node> nodes = new ArrayList<Node>();
    private List<Relationship> relationships = new ArrayList<Relationship>();

    public Node getStartNode() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(0);
    }

    public Node getEndNode() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    public boolean contains(Relationship relationship) {
        return this.relationships.contains(relationship);
    }

    public Iterable<Node> getNodes() {
        return this.nodes;
    }

    public Iterable<Relationship> getRelationships() {
        return this.relationships;
    }

    public Iterable<Segment> getSegments() {
        return this.segments;
    }

    public PathWrapper(Path path) throws InvalidValueException, UnsupportedEncodingException {
        if (path == null) {
            this.nodes = new ArrayList<Node>();
            this.relationships = new ArrayList<Relationship>();
            this.segments = new ArrayList<Segment>();
            return;
        }
        this.nodes.add(new Node(path.src));
        ArrayList<byte[]> vids = new ArrayList<byte[]>();
        vids.add(path.src.vid);
        for (Step step : path.steps) {
            byte[] dstId;
            byte[] srcId;
            Node endNode;
            Node startNode;
            int type = step.type;
            if (step.type > 0) {
                startNode = this.nodes.get(this.nodes.size() - 1);
                endNode = new Node(step.dst);
                this.nodes.add(endNode);
                srcId = (byte[])vids.get(vids.size() - 1);
                dstId = step.dst.vid;
            } else {
                type = -type;
                startNode = new Node(step.dst);
                endNode = this.nodes.get(this.nodes.size() - 1);
                this.nodes.add(startNode);
                dstId = (byte[])vids.get(vids.size() - 1);
                srcId = step.dst.vid;
            }
            vids.add(step.dst.vid);
            Edge edge = new Edge(srcId, dstId, type, step.name, step.ranking, step.props);
            Relationship relationShip = new Relationship(edge);
            this.relationships.add(new Relationship(edge));
            Segment segment = new Segment(startNode, relationShip, endNode);
            if (segment.getStartNode() != this.nodes.get(this.nodes.size() - 1) && segment.getEndNode() != this.nodes.get(this.nodes.size() - 1)) {
                throw new InvalidValueException(String.format("Relationship [%s] does not connect to the last node", relationShip.toString()));
            }
            this.segments.add(segment);
        }
    }

    public int length() {
        return this.segments.size();
    }

    public boolean containNode(Node node) {
        int index = this.nodes.indexOf(node);
        return index >= 0;
    }

    @Override
    public Iterator<Segment> iterator() {
        return null;
    }

    @Override
    public void forEach(Consumer<? super Segment> action) {
    }

    @Override
    public Spliterator<Segment> spliterator() {
        return null;
    }

    public boolean containRelationShip(Relationship relationShip) {
        int index = this.relationships.indexOf(relationShip);
        return index >= 0;
    }

    public String toString() {
        return this.getClass().toString() + "{segments=" + this.segments.toString() + ", nodes=" + this.nodes.toString() + ", relationShips=" + this.relationships.toString() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathWrapper segments1 = (PathWrapper)o;
        return Objects.equals(this.segments, segments1.segments) && Objects.equals(this.nodes, segments1.nodes) && Objects.equals(this.relationships, segments1.relationships);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.nodes, this.relationships);
    }

    public static class Segment {
        Node startNode;
        Relationship relationShip;
        Node endNode;

        public Segment(Node startNode, Relationship relationShip, Node endNode) {
            this.startNode = startNode;
            this.relationShip = relationShip;
            this.endNode = endNode;
        }

        public Node getStartNode() {
            return this.startNode;
        }

        public Relationship getRelationShip() {
            return this.relationShip;
        }

        public Node getEndNode() {
            return this.endNode;
        }

        public String toString() {
            return this.getClass().toString() + "{startNode=" + this.startNode.toString() + ", relationShip=" + this.relationShip.toString() + ", endNode=" + this.endNode.toString() + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment segment = (Segment)o;
            return Objects.equals(this.startNode, segment.startNode) && Objects.equals(this.relationShip, segment.relationShip) && Objects.equals(this.endNode, segment.endNode);
        }

        public int hashCode() {
            return Objects.hash(this.startNode, this.relationShip, this.endNode);
        }
    }
}

