/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Schema;
import com.vesoft.nebula.SupportedType;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ValueType
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("ValueType");
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 1);
    private static final TField VALUE_TYPE_FIELD_DESC = new TField("value_type", 12, 2);
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 12, 3);
    public int type;
    public ValueType value_type;
    public Schema schema;
    public static final int TYPE = 1;
    public static final int VALUE_TYPE = 2;
    public static final int SCHEMA = 3;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __TYPE_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ValueType() {
    }

    public ValueType(int type) {
        this();
        this.type = type;
        this.setTypeIsSet(true);
    }

    public ValueType(int type, ValueType value_type, Schema schema) {
        this();
        this.type = type;
        this.setTypeIsSet(true);
        this.value_type = value_type;
        this.schema = schema;
    }

    public ValueType(ValueType other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.type = TBaseHelper.deepCopy(other.type);
        if (other.isSetValue_type()) {
            this.value_type = TBaseHelper.deepCopy(other.value_type);
        }
        if (other.isSetSchema()) {
            this.schema = TBaseHelper.deepCopy(other.schema);
        }
    }

    @Override
    public ValueType deepCopy() {
        return new ValueType(this);
    }

    @Deprecated
    public ValueType clone() {
        return new ValueType(this);
    }

    public int getType() {
        return this.type;
    }

    public ValueType setType(int type) {
        this.type = type;
        this.setTypeIsSet(true);
        return this;
    }

    public void unsetType() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetType() {
        return this.__isset_bit_vector.get(0);
    }

    public void setTypeIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public ValueType getValue_type() {
        return this.value_type;
    }

    public ValueType setValue_type(ValueType value_type) {
        this.value_type = value_type;
        return this;
    }

    public void unsetValue_type() {
        this.value_type = null;
    }

    public boolean isSetValue_type() {
        return this.value_type != null;
    }

    public void setValue_typeIsSet(boolean value) {
        if (!value) {
            this.value_type = null;
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ValueType setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean value) {
        if (!value) {
            this.schema = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetValue_type();
                    break;
                }
                this.setValue_type((ValueType)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((Schema)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getType();
            }
            case 2: {
                return this.getValue_type();
            }
            case 3: {
                return this.getSchema();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetType();
            }
            case 2: {
                return this.isSetValue_type();
            }
            case 3: {
                return this.isSetSchema();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ValueType) {
            return this.equals((ValueType)that);
        }
        return false;
    }

    public boolean equals(ValueType that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_type = true;
        boolean that_present_type = true;
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.type, that.type)) {
                return false;
            }
        }
        boolean this_present_value_type = this.isSetValue_type();
        boolean that_present_value_type = that.isSetValue_type();
        if (this_present_value_type || that_present_value_type) {
            if (!this_present_value_type || !that_present_value_type) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.value_type, that.value_type)) {
                return false;
            }
        }
        boolean this_present_schema = this.isSetSchema();
        boolean that_present_schema = that.isSetSchema();
        if (this_present_schema || that_present_schema) {
            if (!this_present_schema || !that_present_schema) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.schema, that.schema)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_type = true;
        builder.append(present_type);
        if (present_type) {
            builder.append(this.type);
        }
        boolean present_value_type = this.isSetValue_type();
        builder.append(present_value_type);
        if (present_value_type) {
            builder.append(this.value_type);
        }
        boolean present_schema = this.isSetSchema();
        builder.append(present_schema);
        if (present_schema) {
            builder.append(this.schema);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.type = iprot.readI32();
                        this.setTypeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 12) {
                        this.value_type = new ValueType();
                        this.value_type.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 12) {
                        this.schema = new Schema();
                        this.schema.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TYPE_FIELD_DESC);
        oprot.writeI32(this.type);
        oprot.writeFieldEnd();
        if (this.value_type != null && this.isSetValue_type()) {
            oprot.writeFieldBegin(VALUE_TYPE_FIELD_DESC);
            this.value_type.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.schema != null && this.isSetSchema()) {
            oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
            this.schema.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ValueType");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("type");
        sb.append(space);
        sb.append(":").append(space);
        String type_name = SupportedType.VALUES_TO_NAMES.get(this.getType());
        if (type_name != null) {
            sb.append(type_name);
            sb.append(" (");
        }
        sb.append(this.getType());
        if (type_name != null) {
            sb.append(")");
        }
        first = false;
        if (this.isSetValue_type()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("value_type");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getValue_type() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getValue_type(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetSchema()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("schema");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getSchema() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getSchema(), indent + 1, prettyPrint));
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetType() && !SupportedType.VALID_VALUES.contains(this.type)) {
            throw new TProtocolException("The field 'type' has been assigned the invalid value " + this.type);
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("type", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("value_type", 2, new StructMetaData(12, ValueType.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("schema", 2, new StructMetaData(12, Schema.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ValueType.class, metaDataMap);
    }
}

