/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaCodec.class.getName());
    private static final int PARTITION_ID_SIZE = 4;
    private static final int VERTEX_ID_SIZE = 8;
    private static final int TAG_ID_SIZE = 4;
    private static final int TAG_VERSION_SIZE = 8;
    private static final int EDGE_TYPE_SIZE = 4;
    private static final int EDGE_RANKING_SIZE = 8;
    private static final int EDGE_VERSION_SIZE = 8;
    private static final int VERTEX_SIZE = 24;
    private static final int EDGE_SIZE = 40;
    private static final int DATA_KEY_TYPE = 1;
    private static final int TAG_MASK = -1073741825;
    private static final int EDGE_MASK = 0x40000000;

    public static byte[] createEdgeKey(int partitionId, long srcId, int edgeType, long edgeRank, long dstId, long edgeVersion) {
        ByteBuffer buffer = ByteBuffer.allocate(40);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        partitionId = partitionId << 8 | 1;
        buffer.putInt(partitionId);
        buffer.putLong(srcId);
        buffer.putInt(edgeType |= 0x40000000);
        buffer.putLong(edgeRank);
        buffer.putLong(dstId);
        buffer.putLong(edgeVersion);
        return buffer.array();
    }

    public static byte[] createVertexKey(int partitionId, long vertexId, int tagId, long tagVersion) {
        ByteBuffer buffer = ByteBuffer.allocate(24);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        partitionId = partitionId << 8 | 1;
        buffer.putInt(partitionId);
        buffer.putLong(vertexId);
        buffer.putInt(tagId &= 0xBFFFFFFF);
        buffer.putLong(tagVersion);
        return buffer.array();
    }

    public static native byte[] encode(Object[] var0);

    public static native List<byte[]> decode(byte[] var0, Pair[] var1, long var2);

    private boolean checkKey(String key) {
        return Objects.isNull(key) || key.length() == 0;
    }

    private boolean checkValues(Object[] values) {
        return Objects.isNull(values) || values.length == 0 || Arrays.asList(values).contains(null);
    }

    static {
        try {
            System.loadLibrary("nebula_codec");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
        catch (Error e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    public static class Pair {
        private String field;
        private String clazz;

        public Pair(String field, String clazz) {
            this.field = field;
            this.clazz = clazz;
        }

        public String getField() {
            return this.field;
        }

        public String getClazz() {
            return this.clazz;
        }

        public String toString() {
            return "Pair{field='" + this.field + '\'' + ", clazz=" + this.clazz + '}';
        }
    }
}

