/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.ValueType;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ColumnDef
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("ColumnDef");
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 1);
    private static final TField TYPE_FIELD_DESC = new TField("type", 12, 2);
    private static final TField DEFAULT_VALUE_FIELD_DESC = new TField("default_value", 12, 3);
    public String name;
    public ValueType type;
    public Value default_value;
    public static final int NAME = 1;
    public static final int TYPE = 2;
    public static final int DEFAULT_VALUE = 3;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ColumnDef() {
    }

    public ColumnDef(String name, ValueType type) {
        this();
        this.name = name;
        this.type = type;
    }

    public ColumnDef(String name, ValueType type, Value default_value) {
        this();
        this.name = name;
        this.type = type;
        this.default_value = default_value;
    }

    public ColumnDef(ColumnDef other) {
        if (other.isSetName()) {
            this.name = TBaseHelper.deepCopy(other.name);
        }
        if (other.isSetType()) {
            this.type = TBaseHelper.deepCopy(other.type);
        }
        if (other.isSetDefault_value()) {
            this.default_value = TBaseHelper.deepCopy(other.default_value);
        }
    }

    @Override
    public ColumnDef deepCopy() {
        return new ColumnDef(this);
    }

    @Deprecated
    public ColumnDef clone() {
        return new ColumnDef(this);
    }

    public String getName() {
        return this.name;
    }

    public ColumnDef setName(String name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public ValueType getType() {
        return this.type;
    }

    public ColumnDef setType(ValueType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public Value getDefault_value() {
        return this.default_value;
    }

    public ColumnDef setDefault_value(Value default_value) {
        this.default_value = default_value;
        return this;
    }

    public void unsetDefault_value() {
        this.default_value = null;
    }

    public boolean isSetDefault_value() {
        return this.default_value != null;
    }

    public void setDefault_valueIsSet(boolean value) {
        if (!value) {
            this.default_value = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((ValueType)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetDefault_value();
                    break;
                }
                this.setDefault_value((Value)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getType();
            }
            case 3: {
                return this.getDefault_value();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetName();
            }
            case 2: {
                return this.isSetType();
            }
            case 3: {
                return this.isSetDefault_value();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ColumnDef) {
            return this.equals((ColumnDef)that);
        }
        return false;
    }

    public boolean equals(ColumnDef that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.name, that.name)) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.type, that.type)) {
                return false;
            }
        }
        boolean this_present_default_value = this.isSetDefault_value();
        boolean that_present_default_value = that.isSetDefault_value();
        if (this_present_default_value || that_present_default_value) {
            if (!this_present_default_value || !that_present_default_value) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.default_value, that.default_value)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_name = this.isSetName();
        builder.append(present_name);
        if (present_name) {
            builder.append(this.name);
        }
        boolean present_type = this.isSetType();
        builder.append(present_type);
        if (present_type) {
            builder.append(this.type);
        }
        boolean present_default_value = this.isSetDefault_value();
        builder.append(present_default_value);
        if (present_default_value) {
            builder.append(this.default_value);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.name = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 12) {
                        this.type = new ValueType();
                        this.type.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 12) {
                        this.default_value = new Value();
                        this.default_value.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.name != null) {
            oprot.writeFieldBegin(NAME_FIELD_DESC);
            oprot.writeString(this.name);
            oprot.writeFieldEnd();
        }
        if (this.type != null) {
            oprot.writeFieldBegin(TYPE_FIELD_DESC);
            this.type.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.default_value != null && this.isSetDefault_value()) {
            oprot.writeFieldBegin(DEFAULT_VALUE_FIELD_DESC);
            this.default_value.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ColumnDef");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("name");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getName() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getName(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("type");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getType() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getType(), indent + 1, prettyPrint));
        }
        first = false;
        if (this.isSetDefault_value()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("default_value");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getDefault_value() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getDefault_value(), indent + 1, prettyPrint));
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.name == null) {
            throw new TProtocolException(6, "Required field 'name' was not present! Struct: " + this.toString());
        }
        if (this.type == null) {
            throw new TProtocolException(6, "Required field 'type' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("name", 1, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("type", 1, new StructMetaData(12, ValueType.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("default_value", 2, new StructMetaData(12, Value.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ColumnDef.class, metaDataMap);
    }
}

