/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.transport.TTransport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.vesoft.nebula.Client;
import java.util.List;

public abstract class AbstractClient
implements Client {
    protected final List<HostAndPort> addresses;
    protected final int connectionRetry;
    protected final int executionRetry;
    protected final int timeout;
    protected final int connectionTimeout;
    protected TProtocol protocol;
    protected TTransport transport;

    public AbstractClient(List<HostAndPort> addresses, int timeout, int connectionTimeout, int connectionRetry, int executionRetry) {
        Preconditions.checkArgument(timeout > 0);
        Preconditions.checkArgument(connectionTimeout >= 0);
        Preconditions.checkArgument(connectionRetry > 0);
        Preconditions.checkArgument(executionRetry > 0);
        for (HostAndPort address : addresses) {
            String host = address.getHostText();
            int port = address.getPort();
            if (InetAddresses.isInetAddress(host) && port > 0 && port < 65535) continue;
            throw new IllegalArgumentException(String.format("%s:%d is not a valid address", host, port));
        }
        this.addresses = addresses;
        this.timeout = timeout;
        this.connectionTimeout = connectionTimeout;
        this.connectionRetry = connectionRetry;
        this.executionRetry = executionRetry;
    }

    public AbstractClient(List<HostAndPort> addresses) {
        this(addresses, 1000, 3000, 3, 3);
    }

    public AbstractClient(String host, int port) {
        this(Lists.newArrayList(HostAndPort.fromParts(host, port)), 1000, 3000, 3, 3);
    }

    public AbstractClient() {
        this(Lists.newArrayList(), 1000, 3000, 3, 3);
    }

    protected abstract int doConnect(List<HostAndPort> var1) throws TException;

    @Override
    public int connect() throws TException {
        int retry = this.connectionRetry;
        while (retry-- != 0) {
            int code = this.doConnect(this.addresses);
            if (code != 0) continue;
            return 0;
        }
        return -2;
    }

    @Override
    public boolean isConnected() {
        return this.transport.isOpen();
    }

    protected boolean checkTransportOpened(TTransport transport) {
        return transport != null && transport.isOpen();
    }

    @Override
    public void close() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }
}

