/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TStruct;

public abstract class TUnion<Me extends TUnion<Me>>
implements TBase {
    protected Object value_;
    protected int setField_;

    protected TUnion() {
        this.setField_ = 0;
        this.value_ = null;
    }

    protected TUnion(int setField, Object value) {
        this.setFieldValue(setField, value);
    }

    protected TUnion(TUnion<Me> other) {
        if (!other.getClass().equals(this.getClass())) {
            throw new ClassCastException();
        }
        this.setField_ = other.setField_;
        this.value_ = TBaseHelper.deepCopyUnchecked(other.value_);
    }

    public int getSetField() {
        return this.setField_;
    }

    public Object getFieldValue() {
        return this.value_;
    }

    @Override
    public Object getFieldValue(int fieldId) {
        if (fieldId != this.setField_) {
            throw new IllegalArgumentException("Cannot get the value of field " + fieldId + " because union's set field is " + this.setField_);
        }
        return this.getFieldValue();
    }

    public boolean isSet() {
        return this.setField_ != 0;
    }

    @Override
    public boolean isSet(int fieldId) {
        return this.setField_ == fieldId;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        this.setField_ = 0;
        this.value_ = null;
        iprot.readStructBegin();
        TField field = iprot.readFieldBegin();
        this.value_ = this.readValue(iprot, field);
        if (this.value_ != null) {
            this.setField_ = field.id;
        }
        iprot.readFieldEnd();
        iprot.readFieldBegin();
        iprot.readFieldEnd();
        iprot.readStructEnd();
    }

    @Override
    public void setFieldValue(int fieldId, Object value) {
        this.checkType((short)fieldId, value);
        this.setField_ = (short)fieldId;
        this.value_ = value;
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        if (this.getSetField() == 0 || this.getFieldValue() == null) {
            throw new TProtocolException("Cannot write a TUnion with no set value!");
        }
        oprot.writeStructBegin(this.getStructDesc());
        oprot.writeFieldBegin(this.getFieldDesc(this.setField_));
        this.writeValue(oprot, (short)this.setField_, this.value_);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    protected abstract void checkType(short var1, Object var2) throws ClassCastException;

    protected abstract Object readValue(TProtocol var1, TField var2) throws TException;

    protected abstract void writeValue(TProtocol var1, short var2, Object var3) throws TException;

    protected abstract TStruct getStructDesc();

    protected abstract TField getFieldDesc(int var1);

    public abstract Me deepCopy();

    protected int compareToImpl(Me other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = TBaseHelper.compareTo(this.setField_, ((TUnion)other).setField_);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return TBaseHelper.compareToUnchecked(this.getFieldValue(), ((TUnion)other).getFieldValue());
    }

    protected boolean equalsNobinaryImpl(Me other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getSetField() != ((TUnion)other).getSetField()) {
            return false;
        }
        if (this.getFieldValue() == null || ((TUnion)other).getFieldValue() == null) {
            return this.getFieldValue() == null && ((TUnion)other).getFieldValue() == null;
        }
        return TBaseHelper.equalsNobinaryUnchecked(this.getFieldValue(), ((TUnion)other).getFieldValue());
    }

    protected boolean equalsSlowImpl(Me other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getSetField() != ((TUnion)other).getSetField()) {
            return false;
        }
        if (this.getFieldValue() == null || ((TUnion)other).getFieldValue() == null) {
            return this.getFieldValue() == null && ((TUnion)other).getFieldValue() == null;
        }
        return TBaseHelper.equalsSlowUnchecked(this.getFieldValue(), ((TUnion)other).getFieldValue());
    }

    public String toString() {
        Object v = this.getFieldValue();
        String vStr = null;
        vStr = v instanceof byte[] ? TUnion.bytesToStr((byte[])v) : v.toString();
        return "<" + this.getClass().getSimpleName() + " " + this.getFieldDesc((int)this.getSetField()).name + ":" + vStr + ">";
    }

    private static String bytesToStr(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int size = Math.min(bytes.length, 128);
        for (int i = 0; i < size; ++i) {
            String digit;
            if (i != 0) {
                sb.append(" ");
            }
            sb.append((digit = Integer.toHexString(bytes[i])).length() > 1 ? digit : "0" + digit);
        }
        if (bytes.length > 128) {
            sb.append(" ...");
        }
        return sb.toString();
    }
}

