/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ScanEdge
implements TBase,
Serializable,
Cloneable,
Comparable<ScanEdge> {
    private static final TStruct STRUCT_DESC = new TStruct("ScanEdge");
    private static final TField SRC_FIELD_DESC = new TField("src", 10, 1);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 2);
    private static final TField DST_FIELD_DESC = new TField("dst", 10, 3);
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 4);
    public long src;
    public int type;
    public long dst;
    public byte[] value;
    public static final int SRC = 1;
    public static final int TYPE = 2;
    public static final int DST = 3;
    public static final int VALUE = 4;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __SRC_ISSET_ID = 0;
    private static final int __TYPE_ISSET_ID = 1;
    private static final int __DST_ISSET_ID = 2;
    private BitSet __isset_bit_vector = new BitSet(3);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ScanEdge() {
    }

    public ScanEdge(long src, int type, long dst, byte[] value) {
        this();
        this.src = src;
        this.setSrcIsSet(true);
        this.type = type;
        this.setTypeIsSet(true);
        this.dst = dst;
        this.setDstIsSet(true);
        this.value = value;
    }

    public ScanEdge(ScanEdge other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.src = TBaseHelper.deepCopy(other.src);
        this.type = TBaseHelper.deepCopy(other.type);
        this.dst = TBaseHelper.deepCopy(other.dst);
        if (other.isSetValue()) {
            this.value = TBaseHelper.deepCopy(other.value);
        }
    }

    @Override
    public ScanEdge deepCopy() {
        return new ScanEdge(this);
    }

    @Deprecated
    public ScanEdge clone() {
        return new ScanEdge(this);
    }

    public long getSrc() {
        return this.src;
    }

    public ScanEdge setSrc(long src) {
        this.src = src;
        this.setSrcIsSet(true);
        return this;
    }

    public void unsetSrc() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSrc() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSrcIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public int getType() {
        return this.type;
    }

    public ScanEdge setType(int type) {
        this.type = type;
        this.setTypeIsSet(true);
        return this;
    }

    public void unsetType() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetType() {
        return this.__isset_bit_vector.get(1);
    }

    public void setTypeIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public long getDst() {
        return this.dst;
    }

    public ScanEdge setDst(long dst) {
        this.dst = dst;
        this.setDstIsSet(true);
        return this;
    }

    public void unsetDst() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetDst() {
        return this.__isset_bit_vector.get(2);
    }

    public void setDstIsSet(boolean value) {
        this.__isset_bit_vector.set(2, value);
    }

    public byte[] getValue() {
        return this.value;
    }

    public ScanEdge setValue(byte[] value) {
        this.value = value;
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean value) {
        if (!value) {
            this.value = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetSrc();
                    break;
                }
                this.setSrc((Long)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((Integer)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetDst();
                    break;
                }
                this.setDst((Long)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Long(this.getSrc());
            }
            case 2: {
                return new Integer(this.getType());
            }
            case 3: {
                return new Long(this.getDst());
            }
            case 4: {
                return this.getValue();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetSrc();
            }
            case 2: {
                return this.isSetType();
            }
            case 3: {
                return this.isSetDst();
            }
            case 4: {
                return this.isSetValue();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ScanEdge) {
            return this.equals((ScanEdge)that);
        }
        return false;
    }

    public boolean equals(ScanEdge that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_src = true;
        boolean that_present_src = true;
        if (this_present_src || that_present_src) {
            if (!this_present_src || !that_present_src) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.src, that.src)) {
                return false;
            }
        }
        boolean this_present_type = true;
        boolean that_present_type = true;
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.type, that.type)) {
                return false;
            }
        }
        boolean this_present_dst = true;
        boolean that_present_dst = true;
        if (this_present_dst || that_present_dst) {
            if (!this_present_dst || !that_present_dst) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.dst, that.dst)) {
                return false;
            }
        }
        boolean this_present_value = this.isSetValue();
        boolean that_present_value = that.isSetValue();
        if (this_present_value || that_present_value) {
            if (!this_present_value || !that_present_value) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.value, that.value)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_src = true;
        builder.append(present_src);
        if (present_src) {
            builder.append(this.src);
        }
        boolean present_type = true;
        builder.append(present_type);
        if (present_type) {
            builder.append(this.type);
        }
        boolean present_dst = true;
        builder.append(present_dst);
        if (present_dst) {
            builder.append(this.dst);
        }
        boolean present_value = this.isSetValue();
        builder.append(present_value);
        if (present_value) {
            builder.append(this.value);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(ScanEdge other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetSrc()).compareTo(other.isSetSrc());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.src, other.src);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.type, other.type);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDst()).compareTo(other.isSetDst());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.dst, other.dst);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(other.isSetValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.value, other.value);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 10) {
                        this.src = iprot.readI64();
                        this.setSrcIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.type = iprot.readI32();
                        this.setTypeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 10) {
                        this.dst = iprot.readI64();
                        this.setDstIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 11) {
                        this.value = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SRC_FIELD_DESC);
        oprot.writeI64(this.src);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(TYPE_FIELD_DESC);
        oprot.writeI32(this.type);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(DST_FIELD_DESC);
        oprot.writeI64(this.dst);
        oprot.writeFieldEnd();
        if (this.value != null) {
            oprot.writeFieldBegin(VALUE_FIELD_DESC);
            oprot.writeBinary(this.value);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ScanEdge");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("src");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getSrc(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("type");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getType(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("dst");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getDst(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("value");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getValue() == null) {
            sb.append("null");
        } else {
            int __value_size = Math.min(this.getValue().length, 128);
            for (int i = 0; i < __value_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getValue()[i]).length() > 1 ? Integer.toHexString(this.getValue()[i]).substring(Integer.toHexString(this.getValue()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getValue()[i]).toUpperCase());
            }
            if (this.getValue().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("src", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(2, new FieldMetaData("type", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("dst", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(4, new FieldMetaData("value", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ScanEdge.class, metaDataMap);
    }
}

