/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.transport.TSocket;
import com.google.common.net.HostAndPort;
import com.vesoft.nebula.AbstractClient;
import com.vesoft.nebula.client.graph.ConnectionException;
import com.vesoft.nebula.client.graph.GraphClient;
import com.vesoft.nebula.client.graph.NGQLException;
import com.vesoft.nebula.client.graph.ResultSet;
import com.vesoft.nebula.graph.AuthResponse;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.graph.GraphService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphClientImpl
extends AbstractClient
implements GraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphClientImpl.class);
    protected String user;
    protected String password;
    private long sessionID;
    private ThreadLocal<GraphService.Client> client = new ThreadLocal();

    public GraphClientImpl(List<HostAndPort> addresses, int timeout, int connectionRetry, int executionRetry) {
        this(addresses, timeout, 3000, connectionRetry, executionRetry);
    }

    public GraphClientImpl(List<HostAndPort> addresses, int timeout, int connectionTimeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connectionTimeout, connectionRetry, executionRetry);
    }

    public GraphClientImpl(List<HostAndPort> addresses) {
        super(addresses);
    }

    public GraphClientImpl(String host, int port) {
        super(host, port);
    }

    @Override
    public int doConnect(List<HostAndPort> addresses) throws TException {
        Random random = new Random(System.currentTimeMillis());
        int position = random.nextInt(addresses.size());
        HostAndPort address = addresses.get(position);
        this.transport = new TSocket(address.getHostText(), address.getPort(), this.timeout, this.connectionTimeout);
        this.transport.open();
        this.protocol = new TCompactProtocol(this.transport);
        GraphService.Client thriftClient = new GraphService.Client(this.protocol);
        this.client.set(thriftClient);
        AuthResponse result = this.client.get().authenticate(this.user, this.password);
        if (result.getError_code() == -4) {
            LOGGER.error("User name or password error");
            return -4;
        }
        if (result.getError_code() != 0) {
            LOGGER.error(String.format("Connect address %s failed : %s", address.toString(), result.getError_msg()));
        } else {
            this.sessionID = result.getSession_id();
        }
        return 0;
    }

    @Override
    public int switchSpace(String space) {
        return this.execute(String.format("USE %s", space));
    }

    @Override
    public int execute(String statement) {
        if (!this.checkTransportOpened(this.transport)) {
            return -1;
        }
        int retry = this.executionRetry;
        int code = -3;
        while (retry-- >= 0) {
            try {
                ExecutionResponse executionResponse = this.client.get().execute(this.sessionID, statement);
                code = executionResponse.getError_code();
                if (code == 0) break;
                LOGGER.error("execute error: " + executionResponse.getError_msg());
            }
            catch (TException e) {
                LOGGER.error("Thrift rpc call failed: " + e.getMessage());
            }
        }
        return code;
    }

    @Override
    public ResultSet executeQuery(String statement) throws ConnectionException, NGQLException, TException {
        if (!this.checkTransportOpened(this.transport)) {
            LOGGER.error("Thrift rpc call failed");
            throw new ConnectionException();
        }
        ExecutionResponse executionResponse = this.client.get().execute(this.sessionID, statement);
        int code = executionResponse.getError_code();
        if (code == 0) {
            return new ResultSet(Optional.ofNullable(executionResponse.getColumn_names()).orElse(Collections.emptyList()), Optional.ofNullable(executionResponse.getRows()).orElse(Collections.emptyList()));
        }
        LOGGER.error("Execute error: " + executionResponse.getError_msg());
        throw new NGQLException(code);
    }

    @Override
    public void close() {
        try {
            this.client.get().signout(this.sessionID);
        }
        catch (TException e) {
            LOGGER.error("Disconnect error: " + e.getMessage());
        }
        finally {
            super.close();
        }
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }
}

