/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.processor;

import com.vesoft.nebula.Schema;
import com.vesoft.nebula.client.meta.MetaClientImpl;
import com.vesoft.nebula.client.storage.processor.Processor;
import com.vesoft.nebula.data.Property;
import com.vesoft.nebula.data.Result;
import com.vesoft.nebula.data.Row;
import com.vesoft.nebula.data.RowReader;
import com.vesoft.nebula.meta.TagItem;
import com.vesoft.nebula.storage.ScanVertex;
import com.vesoft.nebula.storage.ScanVertexResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanVertexProcessor
implements Processor<ScanVertexResponse> {
    private MetaClientImpl metaClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanVertexProcessor.class);

    public ScanVertexProcessor(MetaClientImpl metaClient) {
        this.metaClient = metaClient;
    }

    @Override
    public Result process(String spaceName, ScanVertexResponse response) {
        int tagId;
        HashMap<Integer, RowReader> readers = new HashMap<Integer, RowReader>();
        HashMap<Result.RowDesc, List<Row>> rows = new HashMap<Result.RowDesc, List<Row>>();
        HashMap<Integer, Result.RowDesc> vertexTypeIndex = new HashMap<Integer, Result.RowDesc>();
        if (response.vertex_schema != null) {
            for (Map.Entry entry : response.vertex_schema.entrySet()) {
                tagId = (Integer)entry.getKey();
                Schema schema = (Schema)entry.getValue();
                String tagName = this.metaClient.getTagNameFromCache(spaceName, tagId);
                TagItem tagItem = this.metaClient.getTagItemFromCache(spaceName, tagName);
                long schemaVersion = tagItem.version;
                readers.put(tagId, new RowReader(schema, schemaVersion));
                Result.RowDesc desc = new Result.RowDesc(Result.RowType.VERTEX, tagName);
                rows.put(desc, new ArrayList());
                vertexTypeIndex.put(tagId, desc);
            }
        }
        if (response.vertex_data != null) {
            for (ScanVertex scanVertex2 : response.vertex_data) {
                tagId = scanVertex2.tagId;
                if (!readers.containsKey(tagId)) continue;
                RowReader reader = (RowReader)readers.get(tagId);
                Property[] defaultProperties = reader.vertexKey(scanVertex2.vertexId, scanVertex2.tagId);
                Property[] properties = reader.decodeValue(scanVertex2.value);
                Result.RowDesc desc = (Result.RowDesc)vertexTypeIndex.get(tagId);
                ((List)rows.get(desc)).add(new Row(defaultProperties, properties));
            }
        }
        return new Result(rows);
    }
}

