/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.facebook.thrift.TException;
import com.facebook.thrift.async.TAsyncClientManager;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.transport.TNonblockingTransport;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.vesoft.nebula.AbstractClient;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AsyncAbstractClient
extends AbstractClient {
    protected ListeningExecutorService service;
    protected TAsyncClientManager manager;
    protected TNonblockingTransport transport;
    protected TProtocolFactory protocolFactory;

    public AsyncAbstractClient(List<HostAndPort> addresses, int timeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connectionRetry, executionRetry);
    }

    public AsyncAbstractClient(List<HostAndPort> addresses) {
        super(addresses);
    }

    public AsyncAbstractClient(String host, int port) {
        super(host, port);
    }

    @Override
    public int connect() throws TException {
        int code;
        this.service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        int retry = this.connectionRetry;
        while (retry-- != 0 && (code = this.doConnect(this.addresses)) != 0) {
        }
        return -1;
    }

    @Override
    public void close() {
        this.service.shutdown();
        this.transport.close();
        try {
            this.manager.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

