/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.UpdateItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class UpdateVertexRequest
implements TBase,
Serializable,
Cloneable,
Comparable<UpdateVertexRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("UpdateVertexRequest");
    private static final TField SPACE_ID_FIELD_DESC = new TField("space_id", 8, 1);
    private static final TField VERTEX_ID_FIELD_DESC = new TField("vertex_id", 10, 2);
    private static final TField PART_ID_FIELD_DESC = new TField("part_id", 8, 3);
    private static final TField FILTER_FIELD_DESC = new TField("filter", 11, 4);
    private static final TField UPDATE_ITEMS_FIELD_DESC = new TField("update_items", 15, 5);
    private static final TField RETURN_COLUMNS_FIELD_DESC = new TField("return_columns", 15, 6);
    private static final TField INSERTABLE_FIELD_DESC = new TField("insertable", 2, 7);
    public int space_id;
    public long vertex_id;
    public int part_id;
    public byte[] filter;
    public List<UpdateItem> update_items;
    public List<byte[]> return_columns;
    public boolean insertable;
    public static final int SPACE_ID = 1;
    public static final int VERTEX_ID = 2;
    public static final int PART_ID = 3;
    public static final int FILTER = 4;
    public static final int UPDATE_ITEMS = 5;
    public static final int RETURN_COLUMNS = 6;
    public static final int INSERTABLE = 7;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __SPACE_ID_ISSET_ID = 0;
    private static final int __VERTEX_ID_ISSET_ID = 1;
    private static final int __PART_ID_ISSET_ID = 2;
    private static final int __INSERTABLE_ISSET_ID = 3;
    private BitSet __isset_bit_vector = new BitSet(4);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public UpdateVertexRequest() {
    }

    public UpdateVertexRequest(int space_id, long vertex_id, int part_id, byte[] filter, List<UpdateItem> update_items, List<byte[]> return_columns, boolean insertable) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.vertex_id = vertex_id;
        this.setVertex_idIsSet(true);
        this.part_id = part_id;
        this.setPart_idIsSet(true);
        this.filter = filter;
        this.update_items = update_items;
        this.return_columns = return_columns;
        this.insertable = insertable;
        this.setInsertableIsSet(true);
    }

    public UpdateVertexRequest(UpdateVertexRequest other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.space_id = TBaseHelper.deepCopy(other.space_id);
        this.vertex_id = TBaseHelper.deepCopy(other.vertex_id);
        this.part_id = TBaseHelper.deepCopy(other.part_id);
        if (other.isSetFilter()) {
            this.filter = TBaseHelper.deepCopy(other.filter);
        }
        if (other.isSetUpdate_items()) {
            this.update_items = TBaseHelper.deepCopy(other.update_items);
        }
        if (other.isSetReturn_columns()) {
            this.return_columns = TBaseHelper.deepCopy(other.return_columns);
        }
        this.insertable = TBaseHelper.deepCopy(other.insertable);
    }

    @Override
    public UpdateVertexRequest deepCopy() {
        return new UpdateVertexRequest(this);
    }

    @Deprecated
    public UpdateVertexRequest clone() {
        return new UpdateVertexRequest(this);
    }

    public int getSpace_id() {
        return this.space_id;
    }

    public UpdateVertexRequest setSpace_id(int space_id) {
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        return this;
    }

    public void unsetSpace_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSpace_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSpace_idIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public long getVertex_id() {
        return this.vertex_id;
    }

    public UpdateVertexRequest setVertex_id(long vertex_id) {
        this.vertex_id = vertex_id;
        this.setVertex_idIsSet(true);
        return this;
    }

    public void unsetVertex_id() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetVertex_id() {
        return this.__isset_bit_vector.get(1);
    }

    public void setVertex_idIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public int getPart_id() {
        return this.part_id;
    }

    public UpdateVertexRequest setPart_id(int part_id) {
        this.part_id = part_id;
        this.setPart_idIsSet(true);
        return this;
    }

    public void unsetPart_id() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetPart_id() {
        return this.__isset_bit_vector.get(2);
    }

    public void setPart_idIsSet(boolean value) {
        this.__isset_bit_vector.set(2, value);
    }

    public byte[] getFilter() {
        return this.filter;
    }

    public UpdateVertexRequest setFilter(byte[] filter) {
        this.filter = filter;
        return this;
    }

    public void unsetFilter() {
        this.filter = null;
    }

    public boolean isSetFilter() {
        return this.filter != null;
    }

    public void setFilterIsSet(boolean value) {
        if (!value) {
            this.filter = null;
        }
    }

    public List<UpdateItem> getUpdate_items() {
        return this.update_items;
    }

    public UpdateVertexRequest setUpdate_items(List<UpdateItem> update_items) {
        this.update_items = update_items;
        return this;
    }

    public void unsetUpdate_items() {
        this.update_items = null;
    }

    public boolean isSetUpdate_items() {
        return this.update_items != null;
    }

    public void setUpdate_itemsIsSet(boolean value) {
        if (!value) {
            this.update_items = null;
        }
    }

    public List<byte[]> getReturn_columns() {
        return this.return_columns;
    }

    public UpdateVertexRequest setReturn_columns(List<byte[]> return_columns) {
        this.return_columns = return_columns;
        return this;
    }

    public void unsetReturn_columns() {
        this.return_columns = null;
    }

    public boolean isSetReturn_columns() {
        return this.return_columns != null;
    }

    public void setReturn_columnsIsSet(boolean value) {
        if (!value) {
            this.return_columns = null;
        }
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public UpdateVertexRequest setInsertable(boolean insertable) {
        this.insertable = insertable;
        this.setInsertableIsSet(true);
        return this;
    }

    public void unsetInsertable() {
        this.__isset_bit_vector.clear(3);
    }

    public boolean isSetInsertable() {
        return this.__isset_bit_vector.get(3);
    }

    public void setInsertableIsSet(boolean value) {
        this.__isset_bit_vector.set(3, value);
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetSpace_id();
                    break;
                }
                this.setSpace_id((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetVertex_id();
                    break;
                }
                this.setVertex_id((Long)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetPart_id();
                    break;
                }
                this.setPart_id((Integer)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetFilter();
                    break;
                }
                this.setFilter((byte[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetUpdate_items();
                    break;
                }
                this.setUpdate_items((List)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetReturn_columns();
                    break;
                }
                this.setReturn_columns((List)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetInsertable();
                    break;
                }
                this.setInsertable((Boolean)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getSpace_id());
            }
            case 2: {
                return new Long(this.getVertex_id());
            }
            case 3: {
                return new Integer(this.getPart_id());
            }
            case 4: {
                return this.getFilter();
            }
            case 5: {
                return this.getUpdate_items();
            }
            case 6: {
                return this.getReturn_columns();
            }
            case 7: {
                return new Boolean(this.isInsertable());
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetSpace_id();
            }
            case 2: {
                return this.isSetVertex_id();
            }
            case 3: {
                return this.isSetPart_id();
            }
            case 4: {
                return this.isSetFilter();
            }
            case 5: {
                return this.isSetUpdate_items();
            }
            case 6: {
                return this.isSetReturn_columns();
            }
            case 7: {
                return this.isSetInsertable();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof UpdateVertexRequest) {
            return this.equals((UpdateVertexRequest)that);
        }
        return false;
    }

    public boolean equals(UpdateVertexRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_space_id = true;
        boolean that_present_space_id = true;
        if (this_present_space_id || that_present_space_id) {
            if (!this_present_space_id || !that_present_space_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.space_id, that.space_id)) {
                return false;
            }
        }
        boolean this_present_vertex_id = true;
        boolean that_present_vertex_id = true;
        if (this_present_vertex_id || that_present_vertex_id) {
            if (!this_present_vertex_id || !that_present_vertex_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.vertex_id, that.vertex_id)) {
                return false;
            }
        }
        boolean this_present_part_id = true;
        boolean that_present_part_id = true;
        if (this_present_part_id || that_present_part_id) {
            if (!this_present_part_id || !that_present_part_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.part_id, that.part_id)) {
                return false;
            }
        }
        boolean this_present_filter = this.isSetFilter();
        boolean that_present_filter = that.isSetFilter();
        if (this_present_filter || that_present_filter) {
            if (!this_present_filter || !that_present_filter) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.filter, that.filter)) {
                return false;
            }
        }
        boolean this_present_update_items = this.isSetUpdate_items();
        boolean that_present_update_items = that.isSetUpdate_items();
        if (this_present_update_items || that_present_update_items) {
            if (!this_present_update_items || !that_present_update_items) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.update_items, that.update_items)) {
                return false;
            }
        }
        boolean this_present_return_columns = this.isSetReturn_columns();
        boolean that_present_return_columns = that.isSetReturn_columns();
        if (this_present_return_columns || that_present_return_columns) {
            if (!this_present_return_columns || !that_present_return_columns) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.return_columns, that.return_columns)) {
                return false;
            }
        }
        boolean this_present_insertable = true;
        boolean that_present_insertable = true;
        if (this_present_insertable || that_present_insertable) {
            if (!this_present_insertable || !that_present_insertable) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.insertable, that.insertable)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_space_id = true;
        builder.append(present_space_id);
        if (present_space_id) {
            builder.append(this.space_id);
        }
        boolean present_vertex_id = true;
        builder.append(present_vertex_id);
        if (present_vertex_id) {
            builder.append(this.vertex_id);
        }
        boolean present_part_id = true;
        builder.append(present_part_id);
        if (present_part_id) {
            builder.append(this.part_id);
        }
        boolean present_filter = this.isSetFilter();
        builder.append(present_filter);
        if (present_filter) {
            builder.append(this.filter);
        }
        boolean present_update_items = this.isSetUpdate_items();
        builder.append(present_update_items);
        if (present_update_items) {
            builder.append(this.update_items);
        }
        boolean present_return_columns = this.isSetReturn_columns();
        builder.append(present_return_columns);
        if (present_return_columns) {
            builder.append(this.return_columns);
        }
        boolean present_insertable = true;
        builder.append(present_insertable);
        if (present_insertable) {
            builder.append(this.insertable);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(UpdateVertexRequest other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetSpace_id()).compareTo(other.isSetSpace_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.space_id, other.space_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetVertex_id()).compareTo(other.isSetVertex_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.vertex_id, other.vertex_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPart_id()).compareTo(other.isSetPart_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.part_id, other.part_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFilter()).compareTo(other.isSetFilter());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.filter, other.filter);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUpdate_items()).compareTo(other.isSetUpdate_items());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.update_items, other.update_items);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReturn_columns()).compareTo(other.isSetReturn_columns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.return_columns, other.return_columns);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetInsertable()).compareTo(other.isSetInsertable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.insertable, other.insertable);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.space_id = iprot.readI32();
                        this.setSpace_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 10) {
                        this.vertex_id = iprot.readI64();
                        this.setVertex_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.part_id = iprot.readI32();
                        this.setPart_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 11) {
                        this.filter = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 15) {
                        TList _list113 = iprot.readListBegin();
                        this.update_items = new ArrayList<UpdateItem>(Math.max(0, _list113.size));
                        int _i114 = 0;
                        while (_list113.size < 0 ? iprot.peekList() : _i114 < _list113.size) {
                            UpdateItem _elem115 = new UpdateItem();
                            _elem115.read(iprot);
                            this.update_items.add(_elem115);
                            ++_i114;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 6: {
                    if (field.type == 15) {
                        TList _list116 = iprot.readListBegin();
                        this.return_columns = new ArrayList<byte[]>(Math.max(0, _list116.size));
                        int _i117 = 0;
                        while (_list116.size < 0 ? iprot.peekList() : _i117 < _list116.size) {
                            byte[] _elem118 = iprot.readBinary();
                            this.return_columns.add(_elem118);
                            ++_i117;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 7: {
                    if (field.type == 2) {
                        this.insertable = iprot.readBool();
                        this.setInsertableIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SPACE_ID_FIELD_DESC);
        oprot.writeI32(this.space_id);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(VERTEX_ID_FIELD_DESC);
        oprot.writeI64(this.vertex_id);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(PART_ID_FIELD_DESC);
        oprot.writeI32(this.part_id);
        oprot.writeFieldEnd();
        if (this.filter != null) {
            oprot.writeFieldBegin(FILTER_FIELD_DESC);
            oprot.writeBinary(this.filter);
            oprot.writeFieldEnd();
        }
        if (this.update_items != null) {
            oprot.writeFieldBegin(UPDATE_ITEMS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.update_items.size()));
            for (UpdateItem _iter119 : this.update_items) {
                _iter119.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.return_columns != null) {
            oprot.writeFieldBegin(RETURN_COLUMNS_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.return_columns.size()));
            for (byte[] _iter120 : this.return_columns) {
                oprot.writeBinary(_iter120);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(INSERTABLE_FIELD_DESC);
        oprot.writeBool(this.insertable);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("UpdateVertexRequest");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("space_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getSpace_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("vertex_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getVertex_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("part_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getPart_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("filter");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getFilter() == null) {
            sb.append("null");
        } else {
            int __filter_size = Math.min(this.getFilter().length, 128);
            for (int i = 0; i < __filter_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getFilter()[i]).length() > 1 ? Integer.toHexString(this.getFilter()[i]).substring(Integer.toHexString(this.getFilter()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getFilter()[i]).toUpperCase());
            }
            if (this.getFilter().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("update_items");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getUpdate_items() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getUpdate_items(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("return_columns");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getReturn_columns() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getReturn_columns(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("insertable");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.isInsertable(), indent + 1, prettyPrint));
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("space_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("vertex_id", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(3, new FieldMetaData("part_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(4, new FieldMetaData("filter", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(5, new FieldMetaData("update_items", 3, new ListMetaData(15, new StructMetaData(12, UpdateItem.class))));
        tmpMetaDataMap.put(6, new FieldMetaData("return_columns", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMetaDataMap.put(7, new FieldMetaData("insertable", 3, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(UpdateVertexRequest.class, metaDataMap);
    }
}

