/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.util.connection;

import android.content.Context;
import android.net.ConnectivityManager;
import androidx.annotation.RequiresPermission;
import com.verygoodsecurity.vgsshow.util.connection.NetworkConnectionHelper;
import com.verygoodsecurity.vgsshow.util.extension.ContextKt;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/verygoodsecurity/vgsshow/util/connection/BaseNetworkConnectionHelper;", "Lcom/verygoodsecurity/vgsshow/util/connection/NetworkConnectionHelper;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "Ljava/lang/ref/WeakReference;", "isNetworkConnectionAvailable", "", "isNetworkPermissionsGranted", "vgsshow_release"})
public final class BaseNetworkConnectionHelper
implements NetworkConnectionHelper {
    private final WeakReference<Context> context;

    @Override
    public boolean isNetworkPermissionsGranted() {
        Context context = (Context)this.context.get();
        return context != null ? ContextKt.isPermissionsGranted(context, "android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE") : false;
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isNetworkConnectionAvailable() {
        Context context = (Context)this.context.get();
        Object manager = context != null ? context.getSystemService("connectivity") : null;
        Object object = manager;
        if (!(object instanceof ConnectivityManager)) {
            object = null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        return (connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null) != null;
    }

    public BaseNetworkConnectionHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = new WeakReference<Context>(context);
    }
}

