/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.core.network.client.extension;

import com.verygoodsecurity.vgsshow.core.network.client.VGSHttpMethod;
import com.verygoodsecurity.vgsshow.util.extension.StringKt;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\"\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0018\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007*\u00020\u0001H\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0001H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\rH\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\rH\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\rH\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a8\u0006\u001a"}, d2={"addHeader", "Ljava/net/HttpURLConnection;", "key", "", "value", "addHeaders", "headers", "", "callTimeout", "timeout", "", "getHeaders", "isSuccessful", "", "openConnection", "readTimeout", "setCacheEnabled", "enabled", "setInstanceFollowRedirectEnabled", "setIsUserInteractionEnabled", "setMethod", "method", "Lcom/verygoodsecurity/vgsshow/core/network/client/VGSHttpMethod;", "setSSLSocketFactory", "factory", "Ljavax/net/ssl/SSLSocketFactory;", "vgsshow_release"})
public final class HttpURLConnectionKt {
    @NotNull
    public static final HttpURLConnection openConnection(@NotNull String $this$openConnection) throws ClassCastException, MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)$this$openConnection, (String)"$this$openConnection");
        URLConnection uRLConnection = StringKt.toURL($this$openConnection).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        return (HttpURLConnection)uRLConnection;
    }

    @NotNull
    public static final HttpURLConnection callTimeout(@NotNull HttpURLConnection $this$callTimeout, long timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$callTimeout, (String)"$this$callTimeout");
        $this$callTimeout.setConnectTimeout((int)timeout);
        return $this$callTimeout;
    }

    @NotNull
    public static final HttpURLConnection readTimeout(@NotNull HttpURLConnection $this$readTimeout, long timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$readTimeout, (String)"$this$readTimeout");
        $this$readTimeout.setReadTimeout((int)timeout);
        return $this$readTimeout;
    }

    @NotNull
    public static final HttpURLConnection setSSLSocketFactory(@NotNull HttpURLConnection $this$setSSLSocketFactory, @NotNull SSLSocketFactory factory) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$setSSLSocketFactory, (String)"$this$setSSLSocketFactory");
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            HttpURLConnection httpURLConnection = $this$setSSLSocketFactory;
            if (!(httpURLConnection instanceof HttpsURLConnection)) {
                httpURLConnection = null;
            }
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            if (httpsURLConnection == null) break block1;
            httpsURLConnection.setSSLSocketFactory(factory);
        }
        return $this$setSSLSocketFactory;
    }

    @NotNull
    public static final HttpURLConnection setCacheEnabled(@NotNull HttpURLConnection $this$setCacheEnabled, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)$this$setCacheEnabled, (String)"$this$setCacheEnabled");
        $this$setCacheEnabled.setUseCaches(enabled);
        return $this$setCacheEnabled;
    }

    @NotNull
    public static final HttpURLConnection setIsUserInteractionEnabled(@NotNull HttpURLConnection $this$setIsUserInteractionEnabled, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)$this$setIsUserInteractionEnabled, (String)"$this$setIsUserInteractionEnabled");
        $this$setIsUserInteractionEnabled.setAllowUserInteraction(enabled);
        return $this$setIsUserInteractionEnabled;
    }

    @NotNull
    public static final HttpURLConnection setInstanceFollowRedirectEnabled(@NotNull HttpURLConnection $this$setInstanceFollowRedirectEnabled, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)$this$setInstanceFollowRedirectEnabled, (String)"$this$setInstanceFollowRedirectEnabled");
        $this$setInstanceFollowRedirectEnabled.setInstanceFollowRedirects(enabled);
        return $this$setInstanceFollowRedirectEnabled;
    }

    @NotNull
    public static final HttpURLConnection addHeader(@NotNull HttpURLConnection $this$addHeader, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$addHeader, (String)"$this$addHeader");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$addHeader.setRequestProperty(key, value);
        return $this$addHeader;
    }

    @NotNull
    public static final HttpURLConnection addHeaders(@NotNull HttpURLConnection $this$addHeaders, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)$this$addHeaders, (String)"$this$addHeaders");
        Map<String, String> map = headers;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map<String, String> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl2 = false;
                $this$addHeaders.setRequestProperty(it.getKey(), it.getValue());
            }
        }
        return $this$addHeaders;
    }

    @NotNull
    public static final HttpURLConnection setMethod(@NotNull HttpURLConnection $this$setMethod, @NotNull VGSHttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)$this$setMethod, (String)"$this$setMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        $this$setMethod.setRequestMethod(method.name());
        return $this$setMethod;
    }

    public static final boolean isSuccessful(@NotNull HttpURLConnection $this$isSuccessful) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuccessful, (String)"$this$isSuccessful");
        int n = $this$isSuccessful.getResponseCode();
        return 200 <= n && 299 >= n;
    }

    @NotNull
    public static final Map<String, String> getHeaders(@NotNull HttpURLConnection $this$getHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$getHeaders, (String)"$this$getHeaders");
        boolean bl = false;
        Map result = new LinkedHashMap();
        int index = 0;
        while (true) {
            String key = $this$getHeaders.getHeaderFieldKey(index);
            String value = $this$getHeaders.getHeaderField(index);
            if (key == null || value == null) {
                return result;
            }
            result.put(key, value);
            ++index;
        }
    }
}

