/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.core.network;

import android.os.NetworkOnMainThreadException;
import androidx.annotation.VisibleForTesting;
import com.verygoodsecurity.vgsshow.core.exception.VGSException;
import com.verygoodsecurity.vgsshow.core.network.HttpRequestManager$WhenMappings;
import com.verygoodsecurity.vgsshow.core.network.IHttpRequestManager;
import com.verygoodsecurity.vgsshow.core.network.client.BaseHttpClient;
import com.verygoodsecurity.vgsshow.core.network.client.HttpRequestCallback;
import com.verygoodsecurity.vgsshow.core.network.client.IHttpClient;
import com.verygoodsecurity.vgsshow.core.network.client.VGSHttpBodyFormat;
import com.verygoodsecurity.vgsshow.core.network.client.httpurl.HttpUrlClient;
import com.verygoodsecurity.vgsshow.core.network.client.model.HttpRequest;
import com.verygoodsecurity.vgsshow.core.network.client.model.HttpResponse;
import com.verygoodsecurity.vgsshow.core.network.client.okhttp.OkHttpClient;
import com.verygoodsecurity.vgsshow.core.network.extension.MapperKt;
import com.verygoodsecurity.vgsshow.core.network.headers.StaticHeadersStore;
import com.verygoodsecurity.vgsshow.core.network.model.VGSRequest;
import com.verygoodsecurity.vgsshow.core.network.model.VGSResponse;
import com.verygoodsecurity.vgsshow.core.network.model.data.response.EmptyResponseData;
import com.verygoodsecurity.vgsshow.core.network.model.data.response.JsonResponseData;
import com.verygoodsecurity.vgsshow.core.network.model.data.response.ResponseData;
import com.verygoodsecurity.vgsshow.util.extension.VersionKt;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeoutException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0019\u0010\u0018\u001a\u00020\u00162\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0001\u00a2\u0006\u0002\b\u001cJ\u001d\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"J\u001d\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b&J4\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u00032\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00100+H\u0016J\f\u0010-\u001a\u00020\u0007*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/verygoodsecurity/vgsshow/core/network/HttpRequestManager;", "Lcom/verygoodsecurity/vgsshow/core/network/IHttpRequestManager;", "baseUrl", "", "headersStore", "Lcom/verygoodsecurity/vgsshow/core/network/headers/StaticHeadersStore;", "isLogsEnabled", "", "(Ljava/lang/String;Lcom/verygoodsecurity/vgsshow/core/network/headers/StaticHeadersStore;Z)V", "client", "Lcom/verygoodsecurity/vgsshow/core/network/client/IHttpClient;", "getClient", "()Lcom/verygoodsecurity/vgsshow/core/network/client/IHttpClient;", "client$delegate", "Lkotlin/Lazy;", "cancelAll", "", "enqueue", "request", "Lcom/verygoodsecurity/vgsshow/core/network/model/VGSRequest;", "callback", "Lkotlin/Function1;", "Lcom/verygoodsecurity/vgsshow/core/network/model/VGSResponse;", "execute", "parseException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "parseException$vgsshow_release", "parseResponse", "response", "Lcom/verygoodsecurity/vgsshow/core/network/client/model/HttpResponse;", "format", "Lcom/verygoodsecurity/vgsshow/core/network/client/VGSHttpBodyFormat;", "parseResponse$vgsshow_release", "parseResponseData", "Lcom/verygoodsecurity/vgsshow/core/network/model/data/response/ResponseData;", "data", "parseResponseData$vgsshow_release", "setCname", "vaultId", "cname", "cnameResult", "Lkotlin/Function2;", "", "isInvalidPayload", "vgsshow_release"})
public final class HttpRequestManager
implements IHttpRequestManager {
    private final Lazy client$delegate;
    private final String baseUrl;
    private final StaticHeadersStore headersStore;
    private final boolean isLogsEnabled;

    private final IHttpClient getClient() {
        Lazy lazy = this.client$delegate;
        HttpRequestManager httpRequestManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (IHttpClient)lazy.getValue();
    }

    @Override
    @NotNull
    public VGSResponse execute(@NotNull VGSRequest request) {
        VGSResponse vGSResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            if (this.isInvalidPayload(request)) {
                return MapperKt.toVGSResponse(new VGSException.RequestPayloadException(request.getRequestFormat()));
            }
            HttpResponse response = this.getClient().execute(MapperKt.toHttpRequest(request, this.baseUrl, this.headersStore.getAll()));
            vGSResponse = this.parseResponse$vgsshow_release(response, request.getResponseFormat());
        }
        catch (NetworkOnMainThreadException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            vGSResponse = this.parseException$vgsshow_release(e);
        }
        return vGSResponse;
    }

    @Override
    public void enqueue(@NotNull VGSRequest request, @Nullable Function1<? super VGSResponse, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.isInvalidPayload(request)) {
            Function1<? super VGSResponse, Unit> function1 = callback;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)MapperKt.toVGSResponse(new VGSException.RequestPayloadException(request.getRequestFormat())));
            }
            return;
        }
        HttpRequest httpRequest = MapperKt.toHttpRequest(request, this.baseUrl, this.headersStore.getAll());
        boolean bl = false;
        boolean bl2 = false;
        HttpRequest $this$with = httpRequest;
        boolean bl3 = false;
        this.getClient().enqueue($this$with, new HttpRequestCallback(this, callback, request){
            final /* synthetic */ HttpRequestManager this$0;
            final /* synthetic */ Function1 $callback$inlined;
            final /* synthetic */ VGSRequest $request$inlined;
            {
                this.this$0 = httpRequestManager;
                this.$callback$inlined = function1;
                this.$request$inlined = vGSRequest;
            }

            public void onResponse(@NotNull HttpResponse response) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        Function1 function1 = this.$callback$inlined;
                        if (function1 == null) break block2;
                        Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this.this$0.parseResponse$vgsshow_release(response, this.$request$inlined.getResponseFormat()));
                    }
                    catch (Exception e) {
                        Function1 function1 = this.$callback$inlined;
                        if (function1 == null) break block2;
                        Unit cfr_ignored_1 = (Unit)function1.invoke((Object)this.this$0.parseException$vgsshow_release(e));
                    }
                }
            }

            public void onFailure(@NotNull Exception e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Function1 function1 = this.$callback$inlined;
                    if (function1 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this.this$0.parseException$vgsshow_release(e));
                }
            }
        });
    }

    @Override
    public void setCname(@NotNull String vaultId, @Nullable String cname, @NotNull Function2<? super Boolean, ? super Long, Unit> cnameResult) {
        Intrinsics.checkNotNullParameter((Object)vaultId, (String)"vaultId");
        Intrinsics.checkNotNullParameter(cnameResult, (String)"cnameResult");
        this.getClient().setCname(vaultId, cname, cnameResult);
    }

    @Override
    public void cancelAll() {
        this.getClient().cancelAll();
    }

    private final boolean isInvalidPayload(VGSRequest $this$isInvalidPayload) {
        return $this$isInvalidPayload.getPayload$vgsshow_release() != null && !$this$isInvalidPayload.getPayload$vgsshow_release().isValid();
    }

    @VisibleForTesting
    @NotNull
    public final VGSResponse parseResponse$vgsshow_release(@NotNull HttpResponse response, @NotNull VGSHttpBodyFormat format) throws Exception {
        VGSResponse vGSResponse;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        boolean bl = false;
        boolean bl2 = false;
        HttpResponse $this$with = response;
        boolean bl3 = false;
        if (!$this$with.isSuccessful()) {
            vGSResponse = VGSResponse.Error.Companion.create(new VGSException.Exception($this$with.getCode(), $this$with.getMessage()));
        } else {
            int n = $this$with.getCode();
            String string = $this$with.getResponseBody();
            if (string == null) {
                string = "";
            }
            vGSResponse = VGSResponse.Success.Companion.create(n, this.parseResponseData$vgsshow_release(string, format));
        }
        return vGSResponse;
    }

    @VisibleForTesting
    @NotNull
    public final ResponseData parseResponseData$vgsshow_release(@NotNull String data, @NotNull VGSHttpBodyFormat format) throws Exception {
        ResponseData responseData;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        switch (HttpRequestManager$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                responseData = new JsonResponseData(new JSONObject(data));
                break;
            }
            case 2: {
                responseData = new EmptyResponseData();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return responseData;
    }

    @VisibleForTesting
    @NotNull
    public final VGSResponse parseException$vgsshow_release(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Exception exception = e;
        return MapperKt.toVGSResponse(exception instanceof MalformedURLException ? (VGSException)new VGSException.UrlNotValid() : (exception instanceof InterruptedIOException || exception instanceof TimeoutException ? (VGSException)new VGSException.RequestTimeout() : (exception instanceof JSONException ? (VGSException)new VGSException.ResponsePayloadException() : (VGSException)new VGSException.Exception(0, e.getMessage(), 1, null))));
    }

    public HttpRequestManager(@NotNull String baseUrl, @NotNull StaticHeadersStore headersStore, boolean isLogsEnabled) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)headersStore, (String)"headersStore");
        this.baseUrl = baseUrl;
        this.headersStore = headersStore;
        this.isLogsEnabled = isLogsEnabled;
        this.client$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BaseHttpClient>(this){
            final /* synthetic */ HttpRequestManager this$0;

            @NotNull
            public final BaseHttpClient invoke() {
                return VersionKt.isLollipopOrGreater() ? (BaseHttpClient)new OkHttpClient(HttpRequestManager.access$isLogsEnabled$p(this.this$0)) : (BaseHttpClient)new HttpUrlClient(HttpRequestManager.access$isLogsEnabled$p(this.this$0));
            }
            {
                this.this$0 = httpRequestManager;
                super(0);
            }
        }));
    }

    public /* synthetic */ HttpRequestManager(String string, StaticHeadersStore staticHeadersStore, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, staticHeadersStore, bl);
    }

    public static final /* synthetic */ boolean access$isLogsEnabled$p(HttpRequestManager $this) {
        return $this.isLogsEnabled;
    }
}

