/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.core.helper;

import androidx.annotation.MainThread;
import com.verygoodsecurity.vgsshow.core.network.model.data.response.ResponseData;
import com.verygoodsecurity.vgsshow.util.extension.LogKt;
import com.verygoodsecurity.vgsshow.widget.VGSTextView;
import com.verygoodsecurity.vgsshow.widget.core.VGSView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004J\u0006\u0010\f\u001a\u00020\u0007J\u0012\u0010\r\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0012\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/verygoodsecurity/vgsshow/core/helper/ViewsStore;", "", "()V", "views", "", "Lcom/verygoodsecurity/vgsshow/widget/core/VGSView;", "add", "", "view", "clear", "", "getViews", "isEmpty", "remove", "update", "data", "Lcom/verygoodsecurity/vgsshow/core/network/model/data/response/ResponseData;", "vgsshow_release"})
public final class ViewsStore {
    private final Set<VGSView<?>> views;

    public final boolean add(@NotNull VGSView<?> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        return this.views.add(view);
    }

    public final boolean remove(@NotNull VGSView<?> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        return this.views.remove(view);
    }

    public final void clear() {
        this.views.clear();
    }

    @MainThread
    public final void update(@Nullable ResponseData data) {
        if (this.views.isEmpty()) {
            LogKt.logWaring$default(this, "No subscribed views to reveal data.", null, 2, null);
            return;
        }
        LogKt.logStartViewsUpdate(this, this.views);
        boolean bl = false;
        List unrevealedContentPaths = new ArrayList();
        for (VGSView<?> view : this.views) {
            String revealedData;
            if (view.getIgnoreField()) continue;
            ResponseData responseData = data;
            String string = revealedData = responseData != null ? responseData.getValue(view.getContentPath()) : null;
            if (revealedData == null) {
                unrevealedContentPaths.add(view.getContentPath());
                continue;
            }
            VGSView<?> vGSView = view;
            if (vGSView instanceof VGSTextView) {
                ((VGSTextView)view).setText$vgsshow_release(revealedData);
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Not implemented yet!");
        }
        Collection collection = unrevealedContentPaths;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            LogKt.logWaring$default(this, "Cannot reveal data for contentPaths: " + unrevealedContentPaths, null, 2, null);
        }
    }

    public final boolean isEmpty() {
        return this.views.isEmpty();
    }

    @NotNull
    public final Set<VGSView<?>> getViews() {
        return this.views;
    }

    public ViewsStore() {
        boolean bl = false;
        this.views = new LinkedHashSet();
    }
}

