/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.core.analytics;

import android.os.Build;
import com.verygoodsecurity.vgsshow.core.Session;
import com.verygoodsecurity.vgsshow.core.VGSEnvironment;
import com.verygoodsecurity.vgsshow.core.analytics.IAnalyticsManager;
import com.verygoodsecurity.vgsshow.core.analytics.event.Event;
import com.verygoodsecurity.vgsshow.core.analytics.event.Status;
import com.verygoodsecurity.vgsshow.core.network.HttpRequestManager;
import com.verygoodsecurity.vgsshow.core.network.IHttpRequestManager;
import com.verygoodsecurity.vgsshow.core.network.client.VGSHttpBodyFormat;
import com.verygoodsecurity.vgsshow.core.network.client.VGSHttpMethod;
import com.verygoodsecurity.vgsshow.core.network.extension.MapperKt;
import com.verygoodsecurity.vgsshow.core.network.headers.AnalyticsStaticHeadersStore;
import com.verygoodsecurity.vgsshow.core.network.model.VGSRequest;
import com.verygoodsecurity.vgsshow.util.connection.NetworkConnectionHelper;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/verygoodsecurity/vgsshow/core/analytics/AnalyticsManager;", "Lcom/verygoodsecurity/vgsshow/core/analytics/IAnalyticsManager;", "tenantId", "", "environment", "Lcom/verygoodsecurity/vgsshow/core/VGSEnvironment;", "isSatelliteMode", "", "connectionHelper", "Lcom/verygoodsecurity/vgsshow/util/connection/NetworkConnectionHelper;", "(Ljava/lang/String;Lcom/verygoodsecurity/vgsshow/core/VGSEnvironment;ZLcom/verygoodsecurity/vgsshow/util/connection/NetworkConnectionHelper;)V", "defaultInfo", "", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "requestManager", "Lcom/verygoodsecurity/vgsshow/core/network/IHttpRequestManager;", "getRequestManager", "()Lcom/verygoodsecurity/vgsshow/core/network/IHttpRequestManager;", "requestManager$delegate", "Lkotlin/Lazy;", "buildRequest", "Lcom/verygoodsecurity/vgsshow/core/network/model/VGSRequest;", "payload", "cancelAll", "", "getHeadersStore", "Lcom/verygoodsecurity/vgsshow/core/network/headers/AnalyticsStaticHeadersStore;", "log", "event", "Lcom/verygoodsecurity/vgsshow/core/analytics/event/Event;", "Companion", "vgsshow_release"})
public final class AnalyticsManager
implements IAnalyticsManager {
    private boolean isEnabled;
    private final Lazy requestManager$delegate;
    private final Map<String, Object> defaultInfo;
    private final NetworkConnectionHelper connectionHelper;
    private static final String BASE_URL = "https://vgs-collect-keeper.apps.verygood.systems";
    private static final String PATH = "/vgs";
    private static final String KEY_SATELLITE = "vgsSatellite";
    private static final String KEY_SESSION_ID = "vgsShowSessionId";
    private static final String KEY_FORM_ID = "formId";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_TENANT_ID = "tnt";
    private static final String KEY_ENVIRONMENT = "env";
    private static final String KEY_VERSION = "version";
    private static final String KEY_STATUS = "status";
    private static final String KEY_USER_AGENT = "ua";
    private static final String KEY_PLATFORM = "platform";
    private static final String KEY_DEVICE = "device";
    private static final String KEY_DEVICE_MODEL = "device";
    private static final String KEY_DEVICE_OS = "osVersion";
    private static final String ANDROID = "android";
    private static final String ANDROID_SDK = "show-androidSDK";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    private final IHttpRequestManager getRequestManager() {
        Lazy lazy = this.requestManager$delegate;
        AnalyticsManager analyticsManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (IHttpRequestManager)lazy.getValue();
    }

    @Override
    public void log(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isEnabled() && this.connectionHelper.isNetworkPermissionsGranted() && this.connectionHelper.isNetworkConnectionAvailable()) {
            String payload = String.valueOf(MapperKt.toJsonOrNull(MapsKt.plus(this.defaultInfo, event.getAttributes())));
            this.getRequestManager().enqueue(this.buildRequest(payload), null);
        }
    }

    @Override
    public void cancelAll() {
        this.getRequestManager().cancelAll();
    }

    private final AnalyticsStaticHeadersStore getHeadersStore() {
        return new AnalyticsStaticHeadersStore();
    }

    private final VGSRequest buildRequest(String payload) {
        return new VGSRequest.Builder(PATH, VGSHttpMethod.POST).body(payload, VGSHttpBodyFormat.X_WWW_FORM_URLENCODED).build();
    }

    public AnalyticsManager(@NotNull String tenantId, @NotNull VGSEnvironment environment, boolean isSatelliteMode, @NotNull NetworkConnectionHelper connectionHelper) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)connectionHelper, (String)"connectionHelper");
        this.connectionHelper = connectionHelper;
        this.isEnabled = true;
        this.requestManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpRequestManager>(this){
            final /* synthetic */ AnalyticsManager this$0;

            @NotNull
            public final HttpRequestManager invoke() {
                return new HttpRequestManager("https://vgs-collect-keeper.apps.verygood.systems", AnalyticsManager.access$getHeadersStore(this.this$0), false);
            }
            {
                this.this$0 = analyticsManager;
                super(0);
            }
        }));
        this.defaultInfo = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)KEY_SATELLITE, (Object)isSatelliteMode), TuplesKt.to((Object)KEY_SESSION_ID, (Object)Session.INSTANCE.getId()), TuplesKt.to((Object)KEY_FORM_ID, (Object)UUID.randomUUID().toString()), TuplesKt.to((Object)KEY_SOURCE, (Object)ANDROID_SDK), TuplesKt.to((Object)KEY_TENANT_ID, (Object)tenantId), TuplesKt.to((Object)KEY_ENVIRONMENT, (Object)environment.getValue()), TuplesKt.to((Object)KEY_VERSION, (Object)"1.1.0"), TuplesKt.to((Object)KEY_STATUS, (Object)Status.OK.getValue()), TuplesKt.to((Object)KEY_USER_AGENT, (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)KEY_PLATFORM, (Object)ANDROID), TuplesKt.to((Object)"device", (Object)Build.BRAND), TuplesKt.to((Object)"device", (Object)Build.MODEL), TuplesKt.to((Object)KEY_DEVICE_OS, (Object)String.valueOf(Build.VERSION.SDK_INT))}))});
    }

    public static final /* synthetic */ AnalyticsStaticHeadersStore access$getHeadersStore(AnalyticsManager $this) {
        return $this.getHeadersStore();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/verygoodsecurity/vgsshow/core/analytics/AnalyticsManager$Companion;", "", "()V", "ANDROID", "", "ANDROID_SDK", "BASE_URL", "KEY_DEVICE", "KEY_DEVICE_MODEL", "KEY_DEVICE_OS", "KEY_ENVIRONMENT", "KEY_FORM_ID", "KEY_PLATFORM", "KEY_SATELLITE", "KEY_SESSION_ID", "KEY_SOURCE", "KEY_STATUS", "KEY_TENANT_ID", "KEY_USER_AGENT", "KEY_VERSION", "PATH", "vgsshow_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

