/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.NetworkOnMainThreadException;
import androidx.annotation.AnyThread;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.verygoodsecurity.vgsshow.VGSShow;
import com.verygoodsecurity.vgsshow.core.VGSEnvironment;
import com.verygoodsecurity.vgsshow.core.analytics.AnalyticsManager;
import com.verygoodsecurity.vgsshow.core.analytics.IAnalyticsManager;
import com.verygoodsecurity.vgsshow.core.analytics.event.CnameValidationEvent;
import com.verygoodsecurity.vgsshow.core.analytics.event.CopyToClipboardEvent;
import com.verygoodsecurity.vgsshow.core.analytics.event.InitEvent;
import com.verygoodsecurity.vgsshow.core.analytics.event.RequestEvent;
import com.verygoodsecurity.vgsshow.core.analytics.event.ResponseEvent;
import com.verygoodsecurity.vgsshow.core.analytics.event.SetSecureTextEvent;
import com.verygoodsecurity.vgsshow.core.analytics.event.UnsubscribeFieldEvent;
import com.verygoodsecurity.vgsshow.core.exception.VGSException;
import com.verygoodsecurity.vgsshow.core.helper.ViewsStore;
import com.verygoodsecurity.vgsshow.core.listener.VGSOnResponseListener;
import com.verygoodsecurity.vgsshow.core.network.HttpRequestManager;
import com.verygoodsecurity.vgsshow.core.network.IHttpRequestManager;
import com.verygoodsecurity.vgsshow.core.network.client.VGSHttpMethod;
import com.verygoodsecurity.vgsshow.core.network.extension.MapperKt;
import com.verygoodsecurity.vgsshow.core.network.headers.ProxyStaticHeadersStore;
import com.verygoodsecurity.vgsshow.core.network.model.VGSRequest;
import com.verygoodsecurity.vgsshow.core.network.model.VGSResponse;
import com.verygoodsecurity.vgsshow.util.connection.BaseNetworkConnectionHelper;
import com.verygoodsecurity.vgsshow.util.connection.NetworkConnectionHelper;
import com.verygoodsecurity.vgsshow.util.extension.LogKt;
import com.verygoodsecurity.vgsshow.util.extension.StringKt;
import com.verygoodsecurity.vgsshow.util.extension.ValidatorKt;
import com.verygoodsecurity.vgsshow.util.url.UrlHelper;
import com.verygoodsecurity.vgsshow.widget.VGSTextView;
import com.verygoodsecurity.vgsshow.widget.core.VGSView;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0002%(\u0018\u00002\u00020\u0001:\u0001WB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001dJ\b\u00102\u001a\u00020,H\u0002J\u0006\u00103\u001a\u000200J\u0010\u00104\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0013\u00105\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0001\u00a2\u0006\u0002\b6J\r\u00107\u001a\u00020.H\u0001\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u0002002\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010C\u001a\u0002002\u0006\u0010:\u001a\u00020;H\u0003J\u0006\u0010D\u001a\u000200J\u000e\u0010E\u001a\u0002002\u0006\u00101\u001a\u00020\u001dJ\u0010\u0010@\u001a\u00020;2\u0006\u0010@\u001a\u00020AH\u0007J,\u0010@\u001a\u00020;2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020H2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010JH\u0007J\u0010\u0010K\u001a\u0002002\u0006\u0010@\u001a\u00020AH\u0007J,\u0010K\u001a\u0002002\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020H2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010JH\u0007J\u000e\u0010L\u001a\u0002002\u0006\u0010M\u001a\u00020\u0013J\u001a\u0010N\u001a\u0002002\u0006\u0010O\u001a\u00020,2\b\u0010P\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020\u00052\u0006\u0010S\u001a\u00020\u0005J\u0012\u0010T\u001a\u0002002\n\u0010=\u001a\u0006\u0012\u0002\b\u00030UJ\u0012\u0010V\u001a\u0002002\n\u0010=\u001a\u0006\u0012\u0002\b\u00030UR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u00020\u00158\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u0010\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/verygoodsecurity/vgsshow/VGSShow;", "", "context", "Landroid/content/Context;", "vaultId", "", "environment", "Lcom/verygoodsecurity/vgsshow/core/VGSEnvironment;", "(Landroid/content/Context;Ljava/lang/String;Lcom/verygoodsecurity/vgsshow/core/VGSEnvironment;)V", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "url", "port", "", "(Landroid/content/Context;Ljava/lang/String;Lcom/verygoodsecurity/vgsshow/core/VGSEnvironment;Ljava/lang/String;Ljava/lang/Integer;)V", "analyticsManager", "Lcom/verygoodsecurity/vgsshow/core/analytics/IAnalyticsManager;", "connectionHelper", "Lcom/verygoodsecurity/vgsshow/util/connection/NetworkConnectionHelper;", "hasCustomHostname", "", "headersStore", "Lcom/verygoodsecurity/vgsshow/core/network/headers/ProxyStaticHeadersStore;", "getHeadersStore$vgsshow_release$annotations", "()V", "getHeadersStore$vgsshow_release", "()Lcom/verygoodsecurity/vgsshow/core/network/headers/ProxyStaticHeadersStore;", "isSatelliteMode", "listeners", "", "Lcom/verygoodsecurity/vgsshow/core/listener/VGSOnResponseListener;", "getListeners", "()Ljava/util/Set;", "listeners$delegate", "Lkotlin/Lazy;", "mainHandler", "Landroid/os/Handler;", "onSecureTextRangeListener", "com/verygoodsecurity/vgsshow/VGSShow$onSecureTextRangeListener$1", "Lcom/verygoodsecurity/vgsshow/VGSShow$onSecureTextRangeListener$1;", "onTextCopyListener", "com/verygoodsecurity/vgsshow/VGSShow$onTextCopyListener$1", "Lcom/verygoodsecurity/vgsshow/VGSShow$onTextCopyListener$1;", "Ljava/lang/Integer;", "proxyRequestManager", "Lcom/verygoodsecurity/vgsshow/core/network/IHttpRequestManager;", "viewsStore", "Lcom/verygoodsecurity/vgsshow/core/helper/ViewsStore;", "addOnResponseListener", "", "listener", "buildNetworkManager", "clearResponseListeners", "getHost", "getResponseListeners", "getResponseListeners$vgsshow_release", "getViewsStore", "getViewsStore$vgsshow_release", "handleResponse", "response", "Lcom/verygoodsecurity/vgsshow/core/network/model/VGSResponse;", "handleTextViewSubscription", "view", "Lcom/verygoodsecurity/vgsshow/widget/VGSTextView;", "logRequestEvent", "request", "Lcom/verygoodsecurity/vgsshow/core/network/model/VGSRequest;", "logResponseEvent", "notifyResponseListeners", "onDestroy", "removeOnResponseListener", "path", "method", "Lcom/verygoodsecurity/vgsshow/core/network/client/VGSHttpMethod;", "payload", "", "requestAsync", "setAnalyticsEnabled", "isEnabled", "setCname", "manager", "cname", "setCustomHeader", "header", "value", "subscribe", "Lcom/verygoodsecurity/vgsshow/widget/core/VGSView;", "unsubscribe", "Builder", "vgsshow_release"})
public final class VGSShow {
    private final Lazy listeners$delegate;
    private final ViewsStore viewsStore;
    private final Handler mainHandler;
    @NotNull
    private final ProxyStaticHeadersStore headersStore;
    private final NetworkConnectionHelper connectionHelper;
    private final IHttpRequestManager proxyRequestManager;
    private boolean isSatelliteMode;
    private boolean hasCustomHostname;
    private final IAnalyticsManager analyticsManager;
    private final onTextCopyListener.1 onTextCopyListener;
    private final onSecureTextRangeListener.1 onSecureTextRangeListener;
    private final String vaultId;
    private final VGSEnvironment environment;
    private String url;
    private Integer port;

    private final Set<VGSOnResponseListener> getListeners() {
        Lazy lazy = this.listeners$delegate;
        VGSShow vGSShow = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Set)lazy.getValue();
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getHeadersStore$vgsshow_release$annotations() {
    }

    @NotNull
    public final ProxyStaticHeadersStore getHeadersStore$vgsshow_release() {
        return this.headersStore;
    }

    @WorkerThread
    @NotNull
    public final VGSResponse request(@NotNull String path, @NotNull VGSHttpMethod method, @NotNull Map<String, ? extends Object> payload) throws NetworkOnMainThreadException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        return this.request(new VGSRequest.Builder(path, method).body(payload).build());
    }

    @WorkerThread
    @NotNull
    public final VGSResponse request(@NotNull VGSRequest request) throws NetworkOnMainThreadException {
        VGSResponse vGSResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!this.connectionHelper.isNetworkPermissionsGranted()) {
            vGSResponse = MapperKt.toVGSResponse(new VGSException.NoInternetPermission());
        } else if (!this.connectionHelper.isNetworkConnectionAvailable()) {
            vGSResponse = MapperKt.toVGSResponse(new VGSException.NoInternetConnection());
        } else {
            this.logRequestEvent(request);
            VGSResponse vGSResponse2 = this.proxyRequestManager.execute(request);
            boolean bl = false;
            boolean bl2 = false;
            VGSResponse $this$with = vGSResponse2;
            boolean bl3 = false;
            this.logResponseEvent($this$with);
            this.mainHandler.post(new Runnable($this$with, this){
                final /* synthetic */ VGSResponse $this_with;
                final /* synthetic */ VGSShow this$0;
                {
                    this.$this_with = vGSResponse;
                    this.this$0 = vGSShow;
                }

                public final void run() {
                    ViewsStore viewsStore = VGSShow.access$getViewsStore$p(this.this$0);
                    VGSResponse vGSResponse = this.$this_with;
                    if (!(vGSResponse instanceof VGSResponse.Success)) {
                        vGSResponse = null;
                    }
                    VGSResponse.Success success = (VGSResponse.Success)vGSResponse;
                    viewsStore.update(success != null ? success.getData$vgsshow_release() : null);
                }
            });
            vGSResponse = $this$with;
        }
        return vGSResponse;
    }

    @AnyThread
    public final void requestAsync(@NotNull String path, @NotNull VGSHttpMethod method, @NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        this.requestAsync(new VGSRequest.Builder(path, method).body(payload).build());
    }

    @AnyThread
    public final void requestAsync(@NotNull VGSRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!this.connectionHelper.isNetworkPermissionsGranted()) {
            this.handleResponse(MapperKt.toVGSResponse(new VGSException.NoInternetPermission()));
            return;
        }
        if (!this.connectionHelper.isNetworkConnectionAvailable()) {
            this.handleResponse(MapperKt.toVGSResponse(new VGSException.NoInternetConnection()));
            return;
        }
        this.logRequestEvent(request);
        this.proxyRequestManager.enqueue(request, (Function1<? super VGSResponse, Unit>)((Function1)new Function1<VGSResponse, Unit>(this){
            final /* synthetic */ VGSShow this$0;

            public final void invoke(@NotNull VGSResponse it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                VGSShow.access$logResponseEvent(this.this$0, it);
                VGSShow.access$handleResponse(this.this$0, it);
            }
            {
                this.this$0 = vGSShow;
                super(1);
            }
        }));
    }

    public final void addOnResponseListener(@NotNull VGSOnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.getListeners().add(listener);
    }

    public final void removeOnResponseListener(@NotNull VGSOnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.getListeners().remove(listener);
    }

    public final void clearResponseListeners() {
        this.getListeners().clear();
    }

    public final void subscribe(@NotNull VGSView<?> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        if (this.viewsStore.add(view)) {
            this.analyticsManager.log(new InitEvent(com.verygoodsecurity.vgsshow.core.analytics.extension.MapperKt.toAnalyticTag(view.getFieldType())));
            if (view instanceof VGSTextView) {
                this.handleTextViewSubscription((VGSTextView)view);
            }
            view.onViewSubscribed$vgsshow_release();
        }
    }

    public final void unsubscribe(@NotNull VGSView<?> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        if (this.viewsStore.remove(view)) {
            this.analyticsManager.log(new UnsubscribeFieldEvent(com.verygoodsecurity.vgsshow.core.analytics.extension.MapperKt.toAnalyticTag(view.getFieldType())));
            if (view instanceof VGSTextView) {
                ((VGSTextView)view).removeOnCopyTextListener(this.onTextCopyListener);
                ((VGSTextView)view).setOnSecureTextRangeSetListener$vgsshow_release(null);
            }
        }
    }

    public final void setCustomHeader(@NotNull String header, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.headersStore.add(header, value);
    }

    public final void setAnalyticsEnabled(boolean isEnabled) {
        this.analyticsManager.setEnabled(isEnabled);
        this.headersStore.setAnalyticsEnabled(isEnabled);
    }

    public final void onDestroy() {
        this.proxyRequestManager.cancelAll();
        this.analyticsManager.cancelAll();
        this.getListeners().clear();
        Iterable $this$forEach$iv = this.viewsStore.getViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VGSView it = (VGSView)((Object)element$iv);
            boolean bl = false;
            VGSView vGSView = it;
            if (!(vGSView instanceof VGSTextView)) {
                vGSView = null;
            }
            VGSTextView vGSTextView = (VGSTextView)vGSView;
            if (vGSTextView == null) continue;
            vGSTextView.removeOnCopyTextListener(this.onTextCopyListener);
        }
        this.viewsStore.clear();
        this.headersStore.clear();
    }

    @VisibleForTesting
    @NotNull
    public final Set<VGSOnResponseListener> getResponseListeners$vgsshow_release() {
        return this.getListeners();
    }

    @VisibleForTesting
    @NotNull
    public final ViewsStore getViewsStore$vgsshow_release() {
        return this.viewsStore;
    }

    private final IHttpRequestManager buildNetworkManager() {
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Function0<Unit> $fun$printPortDenied$1 = new Function0<Unit>(this){
            final /* synthetic */ VGSShow this$0;

            public final void invoke() {
                if (ValidatorKt.isValidPort(VGSShow.access$getPort$p(this.this$0))) {
                    LogKt.logWaring$default(this.this$0, "To protect your device we allow to use PORT only on localhost. PORT will be ignored", null, 2, null);
                }
            }
            {
                this.this$0 = vGSShow;
                super(0);
            }
        };
        Object object2 = this.url;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            object2 = ValidatorKt.isValidUrl((String)it) ? object : null;
            if (object2 != null) {
                IHttpRequestManager iHttpRequestManager;
                object = object2;
                bl2 = false;
                bl = false;
                Object url = object;
                boolean bl4 = false;
                String host = this.getHost((String)url);
                if (ValidatorKt.isValidIp(host)) {
                    if (!ValidatorKt.isIpAllowed(host)) {
                        LogKt.logWaring$default(this, "Current IP is not allowed, use localhost or private network IP.", null, 2, null);
                        return new HttpRequestManager(UrlHelper.INSTANCE.buildProxyUrl(this.vaultId, this.environment), this.headersStore, false, 4, null);
                    }
                    if (!(this.environment instanceof VGSEnvironment.Sandbox)) {
                        LogKt.logWaring$default(this, "Custom local IP and PORT can be used only in a sandbox environment.", null, 2, null);
                        return new HttpRequestManager(UrlHelper.INSTANCE.buildProxyUrl(this.vaultId, this.environment), this.headersStore, false, 4, null);
                    }
                    this.isSatelliteMode = true;
                    iHttpRequestManager = new HttpRequestManager(UrlHelper.INSTANCE.buildLocalhostUrl(host, this.port), this.headersStore, false, 4, null);
                } else {
                    HttpRequestManager httpRequestManager = new HttpRequestManager(UrlHelper.INSTANCE.buildProxyUrl(this.vaultId, this.environment), this.headersStore, false, 4, null);
                    boolean bl5 = false;
                    boolean bl6 = false;
                    HttpRequestManager it2 = httpRequestManager;
                    boolean bl7 = false;
                    $fun$printPortDenied$1.invoke();
                    this.setCname(it2, host);
                    iHttpRequestManager = httpRequestManager;
                }
                return iHttpRequestManager;
            }
        }
        object = new HttpRequestManager(UrlHelper.INSTANCE.buildProxyUrl(this.vaultId, this.environment), this.headersStore, false, 4, null);
        bl2 = false;
        bl = false;
        it = object;
        boolean bl8 = false;
        $fun$printPortDenied$1.invoke();
        return (IHttpRequestManager)object;
    }

    private final String getHost(String url) {
        String string = StringKt.toHost(url);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)it, (Object)url) ^ true) {
            LogKt.logDebug$default(this, "Hostname will be normalized to the " + it, null, 2, null);
        }
        return string;
    }

    private final void setCname(IHttpRequestManager manager, String cname) {
        manager.setCname(this.vaultId, cname, (Function2<? super Boolean, ? super Long, Unit>)((Function2)new Function2<Boolean, Long, Unit>(this, cname){
            final /* synthetic */ VGSShow this$0;
            final /* synthetic */ String $cname;

            public final void invoke(boolean isSuccessful, long latency) {
                VGSShow.access$setHasCustomHostname$p(this.this$0, isSuccessful);
                VGSShow.access$getAnalyticsManager$p(this.this$0).log(isSuccessful ? CnameValidationEvent.Companion.createSuccessful(this.$cname, latency) : CnameValidationEvent.Companion.createFailed(this.$cname, latency));
            }
            {
                this.this$0 = vGSShow;
                this.$cname = string;
                super(2);
            }
        }));
    }

    private final void handleTextViewSubscription(VGSTextView view) {
        view.addOnCopyTextListener(this.onTextCopyListener);
        view.setOnSecureTextRangeSetListener$vgsshow_release(this.onSecureTextRangeListener);
    }

    @MainThread
    private final void notifyResponseListeners(VGSResponse response) {
        Iterable $this$forEach$iv = this.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VGSOnResponseListener it = (VGSOnResponseListener)element$iv;
            boolean bl = false;
            it.onResponse(response);
        }
    }

    private final void handleResponse(VGSResponse response) {
        this.mainHandler.post(new Runnable(this, response){
            final /* synthetic */ VGSShow this$0;
            final /* synthetic */ VGSResponse $response;

            public final void run() {
                ViewsStore viewsStore = VGSShow.access$getViewsStore$p(this.this$0);
                VGSResponse vGSResponse = this.$response;
                if (!(vGSResponse instanceof VGSResponse.Success)) {
                    vGSResponse = null;
                }
                VGSResponse.Success success = (VGSResponse.Success)vGSResponse;
                viewsStore.update(success != null ? success.getData$vgsshow_release() : null);
                VGSShow.access$notifyResponseListeners(this.this$0, this.$response);
            }
            {
                this.this$0 = vGSShow;
                this.$response = vGSResponse;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final void logRequestEvent(VGSRequest request) {
        block2: {
            hasFields = this.viewsStore.isEmpty() == false;
            v0 = request.getHeaders();
            if (v0 == null) break block2;
            var4_3 = v0;
            var5_4 = false;
            if (var4_3.isEmpty() == false) ** GOTO lbl-1000
        }
        var4_3 = this.headersStore.getCustom();
        var5_4 = false;
        if (var4_3.isEmpty() == false) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        hasHeaders = v1;
        this.analyticsManager.log(RequestEvent.Companion.createSuccessful(hasFields, hasHeaders, this.hasCustomHostname));
    }

    private final void logResponseEvent(VGSResponse response) {
        ResponseEvent responseEvent;
        VGSResponse vGSResponse = response;
        if (vGSResponse instanceof VGSResponse.Success) {
            responseEvent = ResponseEvent.Companion.createSuccessful(response.getCode());
        } else if (vGSResponse instanceof VGSResponse.Error) {
            responseEvent = ResponseEvent.Companion.createFailed(response.getCode(), ((VGSResponse.Error)response).getMessage());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.analyticsManager.log(responseEvent);
    }

    private VGSShow(Context context, String vaultId, VGSEnvironment environment, String url, Integer port) {
        this.vaultId = vaultId;
        this.environment = environment;
        this.url = url;
        this.port = port;
        this.listeners$delegate = LazyKt.lazy((Function0)listeners.2.INSTANCE);
        this.viewsStore = new ViewsStore();
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.headersStore = new ProxyStaticHeadersStore(false, 1, null);
        this.connectionHelper = new BaseNetworkConnectionHelper(context);
        this.proxyRequestManager = this.buildNetworkManager();
        this.analyticsManager = new AnalyticsManager(this.vaultId, this.environment, this.isSatelliteMode, this.connectionHelper);
        this.onTextCopyListener = new VGSTextView.OnTextCopyListener(this){
            final /* synthetic */ VGSShow this$0;

            public void onTextCopied(@NotNull VGSTextView view, @NotNull VGSTextView.CopyTextFormat format) {
                Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
                Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
                VGSShow.access$getAnalyticsManager$p(this.this$0).log(new CopyToClipboardEvent(format, null, 2, null));
            }
            {
                this.this$0 = this$0;
            }
        };
        this.onSecureTextRangeListener = new VGSTextView.OnSetSecureTextRangeSetListener(this){
            final /* synthetic */ VGSShow this$0;

            public void onSecureTextRangeSet(@NotNull VGSTextView view) {
                Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
                VGSShow.access$getAnalyticsManager$p(this.this$0).log(new SetSecureTextEvent(view.getContentPath(), com.verygoodsecurity.vgsshow.core.analytics.extension.MapperKt.toAnalyticTag(view.getFieldType())));
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public VGSShow(@NotNull Context context, @NotNull String vaultId, @NotNull VGSEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vaultId, (String)"vaultId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this(context, vaultId, environment, null, null);
    }

    public VGSShow(@NotNull Context context, @NotNull String vaultId, @NotNull String environment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vaultId, (String)"vaultId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this(context, vaultId, VGSEnvironment.Companion.toVGSEnvironment(environment), null, null);
    }

    public /* synthetic */ VGSShow(Context context, String vaultId, VGSEnvironment environment, String url, Integer port, DefaultConstructorMarker $constructor_marker) {
        this(context, vaultId, environment, url, port);
    }

    public static final /* synthetic */ ViewsStore access$getViewsStore$p(VGSShow $this) {
        return $this.viewsStore;
    }

    public static final /* synthetic */ void access$logResponseEvent(VGSShow $this, VGSResponse response) {
        $this.logResponseEvent(response);
    }

    public static final /* synthetic */ void access$handleResponse(VGSShow $this, VGSResponse response) {
        $this.handleResponse(response);
    }

    public static final /* synthetic */ Integer access$getPort$p(VGSShow $this) {
        return $this.port;
    }

    public static final /* synthetic */ void access$setPort$p(VGSShow $this, Integer n) {
        $this.port = n;
    }

    public static final /* synthetic */ boolean access$getHasCustomHostname$p(VGSShow $this) {
        return $this.hasCustomHostname;
    }

    public static final /* synthetic */ void access$setHasCustomHostname$p(VGSShow $this, boolean bl) {
        $this.hasCustomHostname = bl;
    }

    public static final /* synthetic */ IAnalyticsManager access$getAnalyticsManager$p(VGSShow $this) {
        return $this.analyticsManager;
    }

    public static final /* synthetic */ void access$notifyResponseListeners(VGSShow $this, VGSResponse response) {
        $this.notifyResponseListeners(response);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/verygoodsecurity/vgsshow/VGSShow$Builder;", "", "context", "Landroid/content/Context;", "id", "", "(Landroid/content/Context;Ljava/lang/String;)V", "environment", "Lcom/verygoodsecurity/vgsshow/core/VGSEnvironment;", "host", "port", "", "Ljava/lang/Integer;", "build", "Lcom/verygoodsecurity/vgsshow/VGSShow;", "setEnvironment", "setHostname", "cname", "setPort", "vgsshow_release"})
    public static final class Builder {
        private VGSEnvironment environment;
        private String host;
        private Integer port;
        private final Context context;
        private final String id;

        @NotNull
        public final Builder setEnvironment(@NotNull VGSEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.environment = environment;
            return builder;
        }

        @NotNull
        public final Builder setHostname(@NotNull String cname) {
            Intrinsics.checkNotNullParameter((Object)cname, (String)"cname");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            if (!ValidatorKt.isValidUrl(cname)) {
                LogKt.logWaring$default($this$apply, "A specified host(" + $this$apply.host + ") is not valid url.", null, 2, null);
            } else {
                $this$apply.host = cname;
            }
            return builder;
        }

        @NotNull
        public final Builder setPort(@IntRange(from=1L, to=65353L) int port) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.port = port;
            return builder;
        }

        @NotNull
        public final VGSShow build() {
            return new VGSShow(this.context, this.id, this.environment, this.host, this.port, null);
        }

        public Builder(@NotNull Context context, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.context = context;
            this.id = id;
            this.environment = new VGSEnvironment.Sandbox(null, 1, null);
        }
    }
}

