/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.predicates;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.Header;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.predicates.Predicate;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SimpleConfig;
import java.util.Iterator;
import java.util.Map;

public class HasHeaderKey<R extends ConnectRecord<R>>
implements Predicate<R> {
    private static final String NAME_CONFIG = "name";
    public static final String OVERVIEW_DOC = "A predicate which is true for records with at least one header with the configured name.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("name", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, "The header name.");
    private String name;

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    @Override
    public boolean test(R record) {
        Iterator<Header> headerIterator = ((ConnectRecord)record).headers().allWithName(this.name);
        return headerIterator != null && headerIterator.hasNext();
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.name = new SimpleConfig(this.config(), configs).getString(NAME_CONFIG);
    }

    public String toString() {
        return "HasHeaderKey{name='" + this.name + '\'' + '}';
    }
}

