/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.ListGroupsRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.ListGroupsResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ListGroupsResponse;
import java.nio.ByteBuffer;
import java.util.Collections;

public class ListGroupsRequest
extends AbstractRequest {
    private final ListGroupsRequestData data;

    public ListGroupsRequest(ListGroupsRequestData data, short version) {
        super(ApiKeys.LIST_GROUPS, version);
        this.data = data;
    }

    @Override
    public ListGroupsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ListGroupsResponseData listGroupsResponseData = new ListGroupsResponseData().setGroups(Collections.emptyList()).setErrorCode(Errors.forException(e).code());
        if (this.version() >= 1) {
            listGroupsResponseData.setThrottleTimeMs(throttleTimeMs);
        }
        return new ListGroupsResponse(listGroupsResponseData);
    }

    public static ListGroupsRequest parse(ByteBuffer buffer, short version) {
        return new ListGroupsRequest(new ListGroupsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public ListGroupsRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<ListGroupsRequest> {
        private final ListGroupsRequestData data;

        public Builder(ListGroupsRequestData data) {
            super(ApiKeys.LIST_GROUPS);
            this.data = data;
        }

        @Override
        public ListGroupsRequest build(short version) {
            if (!this.data.statesFilter().isEmpty() && version < 4) {
                throw new UnsupportedVersionException("The broker only supports ListGroups v" + version + ", but we need v4 or newer to request groups by states.");
            }
            return new ListGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

