/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.typeutils;

import com.ververica.cdc.common.annotation.PublicEvolving;
import com.ververica.cdc.common.data.binary.BinaryRecordData;
import com.ververica.cdc.common.types.DataType;
import com.ververica.cdc.common.types.RowType;
import com.ververica.cdc.common.utils.Preconditions;
import com.ververica.cdc.runtime.serializer.InternalSerializers;
import com.ververica.cdc.runtime.serializer.NullableSerializerWrapper;
import com.ververica.cdc.runtime.serializer.data.writer.BinaryRecordDataWriter;
import com.ververica.cdc.runtime.serializer.data.writer.BinaryWriter;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@PublicEvolving
public class BinaryRecordDataGenerator {
    private final DataType[] dataTypes;
    private final TypeSerializer[] serializers;
    private transient BinaryRecordData reuseRecordData;
    private transient BinaryRecordDataWriter reuseWriter;

    public BinaryRecordDataGenerator(RowType recordType) {
        this(recordType.getChildren().toArray(new DataType[0]));
    }

    public BinaryRecordDataGenerator(DataType[] dataTypes) {
        this(dataTypes, (TypeSerializer[])Arrays.stream(dataTypes).map(InternalSerializers::create).map(NullableSerializerWrapper::new).toArray(TypeSerializer[]::new));
    }

    public BinaryRecordDataGenerator(DataType[] dataTypes, TypeSerializer[] serializers) {
        Preconditions.checkArgument((dataTypes.length == serializers.length ? 1 : 0) != 0, (String)String.format("The types and serializers must have the same length. But types is %d and serializers is %d", dataTypes.length, serializers.length), (Object[])new Object[0]);
        this.dataTypes = dataTypes;
        this.serializers = serializers;
        this.reuseRecordData = new BinaryRecordData(dataTypes.length);
        this.reuseWriter = new BinaryRecordDataWriter(this.reuseRecordData);
    }

    public BinaryRecordData generate(Object[] rowFields) {
        Preconditions.checkArgument((this.dataTypes.length == rowFields.length ? 1 : 0) != 0, (String)String.format("The types and values must have the same length. But types is %d and values is %d", this.dataTypes.length, rowFields.length), (Object[])new Object[0]);
        this.reuseWriter.reset();
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (rowFields[i] == null) {
                this.reuseWriter.setNullAt(i);
                continue;
            }
            BinaryWriter.write(this.reuseWriter, i, rowFields[i], this.dataTypes[i], this.serializers[i]);
        }
        this.reuseWriter.complete();
        return this.reuseRecordData.copy();
    }
}

