/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.schema;

import com.ververica.cdc.common.types.DataField;
import com.ververica.cdc.common.types.DataType;
import com.ververica.cdc.common.types.DataTypes;
import com.ververica.cdc.runtime.serializer.StringSerializer;
import com.ververica.cdc.runtime.serializer.TypeSerializerSingleton;
import com.ververica.cdc.runtime.serializer.schema.DataTypeSerializer;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class DataFieldSerializer
extends TypeSerializerSingleton<DataField> {
    private static final long serialVersionUID = 1L;
    public static final DataFieldSerializer INSTANCE = new DataFieldSerializer();
    private final StringSerializer stringSerializer = StringSerializer.INSTANCE;
    private final DataTypeSerializer dataTypeSerializer = new DataTypeSerializer();

    public boolean isImmutableType() {
        return false;
    }

    public DataField createInstance() {
        return new DataField("unknown", (DataType)DataTypes.BIGINT());
    }

    public DataField copy(DataField from) {
        return new DataField(this.stringSerializer.copy(from.getName()), this.dataTypeSerializer.copy(from.getType()), this.stringSerializer.copy(from.getDescription()));
    }

    public DataField copy(DataField from, DataField reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DataField record, DataOutputView target) throws IOException {
        this.stringSerializer.serialize(record.getName(), target);
        this.dataTypeSerializer.serialize(record.getType(), target);
        this.stringSerializer.serialize(record.getDescription(), target);
    }

    public DataField deserialize(DataInputView source) throws IOException {
        String name = this.stringSerializer.deserialize(source);
        DataType type = this.dataTypeSerializer.deserialize(source);
        String desc = this.stringSerializer.deserialize(source);
        return new DataField(name, type, desc);
    }

    public DataField deserialize(DataField reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<DataField> snapshotConfiguration() {
        return new DataFieldSerializerSnapshot();
    }

    public static final class DataFieldSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<DataField> {
        public DataFieldSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

