/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.event;

import com.ververica.cdc.common.event.AddColumnEvent;
import com.ververica.cdc.common.event.AlterColumnTypeEvent;
import com.ververica.cdc.common.event.CreateTableEvent;
import com.ververica.cdc.common.event.DropColumnEvent;
import com.ververica.cdc.common.event.RenameColumnEvent;
import com.ververica.cdc.common.event.SchemaChangeEvent;
import com.ververica.cdc.common.event.TableId;
import com.ververica.cdc.runtime.serializer.EnumSerializer;
import com.ververica.cdc.runtime.serializer.TypeSerializerSingleton;
import com.ververica.cdc.runtime.serializer.event.AddColumnEventSerializer;
import com.ververica.cdc.runtime.serializer.event.AlterColumnTypeEventSerializer;
import com.ververica.cdc.runtime.serializer.event.CreateTableEventSerializer;
import com.ververica.cdc.runtime.serializer.event.DropColumnEventSerializer;
import com.ververica.cdc.runtime.serializer.event.RenameColumnEventSerializer;
import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class SchemaChangeEventSerializer
extends TypeSerializerSingleton<SchemaChangeEvent> {
    private static final long serialVersionUID = 1L;
    public static final SchemaChangeEventSerializer INSTANCE = new SchemaChangeEventSerializer();
    private final EnumSerializer<SchemaChangeEventClass> enumSerializer = new EnumSerializer<SchemaChangeEventClass>(SchemaChangeEventClass.class);

    public boolean isImmutableType() {
        return false;
    }

    public SchemaChangeEvent createInstance() {
        return (SchemaChangeEvent & Serializable)() -> TableId.tableId((String)"unknown", (String)"unknown", (String)"unknown");
    }

    public SchemaChangeEvent copy(SchemaChangeEvent from) {
        if (from instanceof AlterColumnTypeEvent) {
            return AlterColumnTypeEventSerializer.INSTANCE.copy((AlterColumnTypeEvent)from);
        }
        if (from instanceof CreateTableEvent) {
            return CreateTableEventSerializer.INSTANCE.copy((CreateTableEvent)from);
        }
        if (from instanceof RenameColumnEvent) {
            return RenameColumnEventSerializer.INSTANCE.copy((RenameColumnEvent)from);
        }
        if (from instanceof AddColumnEvent) {
            return AddColumnEventSerializer.INSTANCE.copy((AddColumnEvent)from);
        }
        if (from instanceof DropColumnEvent) {
            return DropColumnEventSerializer.INSTANCE.copy((DropColumnEvent)from);
        }
        throw new IllegalArgumentException("Unknown schema change event: " + from);
    }

    public SchemaChangeEvent copy(SchemaChangeEvent from, SchemaChangeEvent reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(SchemaChangeEvent record, DataOutputView target) throws IOException {
        if (record instanceof AlterColumnTypeEvent) {
            this.enumSerializer.serialize(SchemaChangeEventClass.ALTER_COLUMN_TYPE, target);
            AlterColumnTypeEventSerializer.INSTANCE.serialize((AlterColumnTypeEvent)record, target);
        } else if (record instanceof CreateTableEvent) {
            this.enumSerializer.serialize(SchemaChangeEventClass.CREATE_TABLE, target);
            CreateTableEventSerializer.INSTANCE.serialize((CreateTableEvent)record, target);
        } else if (record instanceof RenameColumnEvent) {
            this.enumSerializer.serialize(SchemaChangeEventClass.RENAME_COLUMN, target);
            RenameColumnEventSerializer.INSTANCE.serialize((RenameColumnEvent)record, target);
        } else if (record instanceof AddColumnEvent) {
            this.enumSerializer.serialize(SchemaChangeEventClass.ADD_COLUMN, target);
            AddColumnEventSerializer.INSTANCE.serialize((AddColumnEvent)record, target);
        } else if (record instanceof DropColumnEvent) {
            this.enumSerializer.serialize(SchemaChangeEventClass.DROP_COLUMN, target);
            DropColumnEventSerializer.INSTANCE.serialize((DropColumnEvent)record, target);
        } else {
            throw new IllegalArgumentException("Unknown schema change event: " + record);
        }
    }

    public SchemaChangeEvent deserialize(DataInputView source) throws IOException {
        SchemaChangeEventClass schemaChangeEventClass = (SchemaChangeEventClass)((Object)this.enumSerializer.deserialize(source));
        switch (schemaChangeEventClass) {
            case ADD_COLUMN: {
                return AddColumnEventSerializer.INSTANCE.deserialize(source);
            }
            case DROP_COLUMN: {
                return DropColumnEventSerializer.INSTANCE.deserialize(source);
            }
            case CREATE_TABLE: {
                return CreateTableEventSerializer.INSTANCE.deserialize(source);
            }
            case RENAME_COLUMN: {
                return RenameColumnEventSerializer.INSTANCE.deserialize(source);
            }
            case ALTER_COLUMN_TYPE: {
                return AlterColumnTypeEventSerializer.INSTANCE.deserialize(source);
            }
        }
        throw new IllegalArgumentException("Unknown schema change event class: " + (Object)((Object)schemaChangeEventClass));
    }

    public SchemaChangeEvent deserialize(SchemaChangeEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<SchemaChangeEvent> snapshotConfiguration() {
        return new SchemaChangeEventSerializerSnapshot();
    }

    static enum SchemaChangeEventClass {
        ALTER_COLUMN_TYPE,
        RENAME_COLUMN,
        ADD_COLUMN,
        DROP_COLUMN,
        CREATE_TABLE;

    }

    public static final class SchemaChangeEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<SchemaChangeEvent> {
        public SchemaChangeEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

