/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.event;

import com.ververica.cdc.common.event.DataChangeEvent;
import com.ververica.cdc.common.event.Event;
import com.ververica.cdc.common.event.FlushEvent;
import com.ververica.cdc.common.event.SchemaChangeEvent;
import com.ververica.cdc.runtime.serializer.EnumSerializer;
import com.ververica.cdc.runtime.serializer.TableIdSerializer;
import com.ververica.cdc.runtime.serializer.TypeSerializerSingleton;
import com.ververica.cdc.runtime.serializer.event.DataChangeEventSerializer;
import com.ververica.cdc.runtime.serializer.event.SchemaChangeEventSerializer;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class EventSerializer
extends TypeSerializerSingleton<Event> {
    private static final long serialVersionUID = 1L;
    public static final EventSerializer INSTANCE = new EventSerializer();
    private final SchemaChangeEventSerializer schemaChangeEventSerializer = SchemaChangeEventSerializer.INSTANCE;
    private final TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
    private final EnumSerializer<EventClass> enumSerializer = new EnumSerializer<EventClass>(EventClass.class);
    private final TypeSerializer<DataChangeEvent> dataChangeEventSerializer = DataChangeEventSerializer.INSTANCE;

    public boolean isImmutableType() {
        return false;
    }

    public Event createInstance() {
        return new Event(){};
    }

    public Event copy(Event from) {
        if (from instanceof FlushEvent) {
            return new FlushEvent(this.tableIdSerializer.copy(((FlushEvent)from).getTableId()));
        }
        if (from instanceof SchemaChangeEvent) {
            return this.schemaChangeEventSerializer.copy((SchemaChangeEvent)from);
        }
        if (from instanceof DataChangeEvent) {
            return (Event)this.dataChangeEventSerializer.copy((Object)((DataChangeEvent)from));
        }
        throw new UnsupportedOperationException("Unknown event type: " + from.toString());
    }

    public Event copy(Event from, Event reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Event record, DataOutputView target) throws IOException {
        if (record instanceof FlushEvent) {
            this.enumSerializer.serialize(EventClass.FLUSH_EVENT, target);
            this.tableIdSerializer.serialize(((FlushEvent)record).getTableId(), target);
        } else if (record instanceof SchemaChangeEvent) {
            this.enumSerializer.serialize(EventClass.SCHEME_CHANGE_EVENT, target);
            this.schemaChangeEventSerializer.serialize((SchemaChangeEvent)record, target);
        } else if (record instanceof DataChangeEvent) {
            this.enumSerializer.serialize(EventClass.DATA_CHANGE_EVENT, target);
            this.dataChangeEventSerializer.serialize((Object)((DataChangeEvent)record), target);
        } else {
            throw new UnsupportedOperationException("Unknown event type: " + record.toString());
        }
    }

    public Event deserialize(DataInputView source) throws IOException {
        EventClass eventClass = (EventClass)((Object)this.enumSerializer.deserialize(source));
        switch (eventClass) {
            case FLUSH_EVENT: {
                return new FlushEvent(this.tableIdSerializer.deserialize(source));
            }
            case DATA_CHANGE_EVENT: {
                return (Event)this.dataChangeEventSerializer.deserialize(source);
            }
            case SCHEME_CHANGE_EVENT: {
                return this.schemaChangeEventSerializer.deserialize(source);
            }
        }
        throw new UnsupportedOperationException("Unknown event type: " + (Object)((Object)eventClass));
    }

    public Event deserialize(Event reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<Event> snapshotConfiguration() {
        return new EventSerializerSnapshot();
    }

    static enum EventClass {
        DATA_CHANGE_EVENT,
        SCHEME_CHANGE_EVENT,
        FLUSH_EVENT;

    }

    public static final class EventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Event> {
        public EventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

