/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.event;

import com.ververica.cdc.common.event.DropColumnEvent;
import com.ververica.cdc.common.event.TableId;
import com.ververica.cdc.common.schema.Column;
import com.ververica.cdc.runtime.serializer.ListSerializer;
import com.ververica.cdc.runtime.serializer.TableIdSerializer;
import com.ververica.cdc.runtime.serializer.TypeSerializerSingleton;
import com.ververica.cdc.runtime.serializer.schema.ColumnSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class DropColumnEventSerializer
extends TypeSerializerSingleton<DropColumnEvent> {
    private static final long serialVersionUID = 1L;
    public static final DropColumnEventSerializer INSTANCE = new DropColumnEventSerializer();
    private final TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
    private final ListSerializer<Column> columnsSerializer = new ListSerializer<Column>(ColumnSerializer.INSTANCE);

    public boolean isImmutableType() {
        return false;
    }

    public DropColumnEvent createInstance() {
        return new DropColumnEvent(TableId.tableId((String)"unknown"), Collections.emptyList());
    }

    public DropColumnEvent copy(DropColumnEvent from) {
        return new DropColumnEvent(from.tableId(), this.columnsSerializer.copy(from.getDroppedColumns()));
    }

    public DropColumnEvent copy(DropColumnEvent from, DropColumnEvent reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DropColumnEvent record, DataOutputView target) throws IOException {
        this.tableIdSerializer.serialize(record.tableId(), target);
        this.columnsSerializer.serialize(record.getDroppedColumns(), target);
    }

    public DropColumnEvent deserialize(DataInputView source) throws IOException {
        return new DropColumnEvent(this.tableIdSerializer.deserialize(source), (List)this.columnsSerializer.deserialize(source));
    }

    public DropColumnEvent deserialize(DropColumnEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<DropColumnEvent> snapshotConfiguration() {
        return new DropColumnEventSerializerSnapshot();
    }

    public static final class DropColumnEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<DropColumnEvent> {
        public DropColumnEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

