/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.event;

import com.ververica.cdc.common.data.RecordData;
import com.ververica.cdc.common.event.DataChangeEvent;
import com.ververica.cdc.common.event.OperationType;
import com.ververica.cdc.common.event.TableId;
import com.ververica.cdc.runtime.serializer.EnumSerializer;
import com.ververica.cdc.runtime.serializer.MapSerializer;
import com.ververica.cdc.runtime.serializer.NullableSerializerWrapper;
import com.ververica.cdc.runtime.serializer.StringSerializer;
import com.ververica.cdc.runtime.serializer.TableIdSerializer;
import com.ververica.cdc.runtime.serializer.TypeSerializerSingleton;
import com.ververica.cdc.runtime.serializer.data.RecordDataSerializer;
import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class DataChangeEventSerializer
extends TypeSerializerSingleton<DataChangeEvent> {
    private static final long serialVersionUID = 1L;
    public static final DataChangeEventSerializer INSTANCE = new DataChangeEventSerializer();
    private final TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
    private final TypeSerializer<Map<String, String>> metaSerializer = new NullableSerializerWrapper<Map<String, String>>(new MapSerializer<String, String>(StringSerializer.INSTANCE, StringSerializer.INSTANCE));
    private final EnumSerializer<OperationType> opSerializer = new EnumSerializer<OperationType>(OperationType.class);
    private final RecordDataSerializer recordDataSerializer = RecordDataSerializer.INSTANCE;

    public DataChangeEvent createInstance() {
        return DataChangeEvent.deleteEvent((TableId)TableId.tableId((String)"unknown"), null);
    }

    public void serialize(DataChangeEvent event, DataOutputView target) throws IOException {
        this.opSerializer.serialize(event.op(), target);
        this.tableIdSerializer.serialize(event.tableId(), target);
        if (event.before() != null) {
            this.recordDataSerializer.serialize(event.before(), target);
        }
        if (event.after() != null) {
            this.recordDataSerializer.serialize(event.after(), target);
        }
        this.metaSerializer.serialize((Object)event.meta(), target);
    }

    public DataChangeEvent deserialize(DataInputView source) throws IOException {
        OperationType op = (OperationType)this.opSerializer.deserialize(source);
        TableId tableId = this.tableIdSerializer.deserialize(source);
        switch (op) {
            case DELETE: {
                return DataChangeEvent.deleteEvent((TableId)tableId, (RecordData)this.recordDataSerializer.deserialize(source), (Map)((Map)this.metaSerializer.deserialize(source)));
            }
            case INSERT: {
                return DataChangeEvent.insertEvent((TableId)tableId, (RecordData)this.recordDataSerializer.deserialize(source), (Map)((Map)this.metaSerializer.deserialize(source)));
            }
            case UPDATE: {
                return DataChangeEvent.updateEvent((TableId)tableId, (RecordData)this.recordDataSerializer.deserialize(source), (RecordData)this.recordDataSerializer.deserialize(source), (Map)((Map)this.metaSerializer.deserialize(source)));
            }
            case REPLACE: {
                return DataChangeEvent.replaceEvent((TableId)tableId, (RecordData)this.recordDataSerializer.deserialize(source), (Map)((Map)this.metaSerializer.deserialize(source)));
            }
        }
        throw new IllegalArgumentException("Unsupported data change event: " + op);
    }

    public DataChangeEvent deserialize(DataChangeEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public DataChangeEvent copy(DataChangeEvent from) {
        OperationType op = from.op();
        switch (op) {
            case DELETE: {
                return DataChangeEvent.deleteEvent((TableId)this.tableIdSerializer.copy(from.tableId()), (RecordData)this.recordDataSerializer.copy(from.before()), (Map)((Map)this.metaSerializer.copy((Object)from.meta())));
            }
            case INSERT: {
                return DataChangeEvent.insertEvent((TableId)this.tableIdSerializer.copy(from.tableId()), (RecordData)this.recordDataSerializer.copy(from.after()), (Map)((Map)this.metaSerializer.copy((Object)from.meta())));
            }
            case UPDATE: {
                return DataChangeEvent.updateEvent((TableId)this.tableIdSerializer.copy(from.tableId()), (RecordData)this.recordDataSerializer.copy(from.before()), (RecordData)this.recordDataSerializer.copy(from.after()), (Map)((Map)this.metaSerializer.copy((Object)from.meta())));
            }
            case REPLACE: {
                return DataChangeEvent.replaceEvent((TableId)this.tableIdSerializer.copy(from.tableId()), (RecordData)this.recordDataSerializer.copy(from.after()), (Map)((Map)this.metaSerializer.copy((Object)from.meta())));
            }
        }
        throw new IllegalArgumentException("Unsupported data change event: " + op);
    }

    public DataChangeEvent copy(DataChangeEvent from, DataChangeEvent reuse) {
        return this.copy(from);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean isImmutableType() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public TypeSerializerSnapshot<DataChangeEvent> snapshotConfiguration() {
        return new DataChangeEventSerializerSnapshot();
    }

    public static final class DataChangeEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<DataChangeEvent> {
        public DataChangeEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

