/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.data.writer;

import com.ververica.cdc.common.annotation.Internal;
import com.ververica.cdc.common.data.ArrayData;
import com.ververica.cdc.common.data.DecimalData;
import com.ververica.cdc.common.data.LocalZonedTimestampData;
import com.ververica.cdc.common.data.MapData;
import com.ververica.cdc.common.data.RecordData;
import com.ververica.cdc.common.data.StringData;
import com.ververica.cdc.common.data.TimestampData;
import com.ververica.cdc.common.data.ZonedTimestampData;
import com.ververica.cdc.common.types.DataType;
import com.ververica.cdc.common.types.DecimalType;
import com.ververica.cdc.common.types.LocalZonedTimestampType;
import com.ververica.cdc.common.types.TimestampType;
import com.ververica.cdc.common.types.ZonedTimestampType;
import com.ververica.cdc.runtime.serializer.data.ArrayDataSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public interface BinaryWriter {
    public void reset();

    public void setNullAt(int var1);

    public void writeBoolean(int var1, boolean var2);

    public void writeByte(int var1, byte var2);

    public void writeShort(int var1, short var2);

    public void writeInt(int var1, int var2);

    public void writeLong(int var1, long var2);

    public void writeFloat(int var1, float var2);

    public void writeDouble(int var1, double var2);

    public void writeString(int var1, StringData var2);

    public void writeBinary(int var1, byte[] var2);

    public void writeDecimal(int var1, DecimalData var2, int var3);

    public void writeTimestamp(int var1, TimestampData var2, int var3);

    public void writeLocalZonedTimestamp(int var1, LocalZonedTimestampData var2, int var3);

    public void writeZonedTimestamp(int var1, ZonedTimestampData var2, int var3);

    public void writeArray(int var1, ArrayData var2, ArrayDataSerializer var3);

    public void writeMap(int var1, MapData var2, TypeSerializer<MapData> var3);

    public void writeRecord(int var1, RecordData var2, TypeSerializer<RecordData> var3);

    public void complete();

    public static void write(BinaryWriter writer, int pos, Object o, DataType type, TypeSerializer<?> serializer) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                writer.writeBoolean(pos, (Boolean)o);
                break;
            }
            case TINYINT: {
                writer.writeByte(pos, (Byte)o);
                break;
            }
            case SMALLINT: {
                writer.writeShort(pos, (Short)o);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                writer.writeInt(pos, (Integer)o);
                break;
            }
            case BIGINT: {
                writer.writeLong(pos, (Long)o);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                writer.writeTimestamp(pos, (TimestampData)o, timestampType.getPrecision());
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)type;
                writer.writeLocalZonedTimestamp(pos, (LocalZonedTimestampData)o, lzTs.getPrecision());
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                ZonedTimestampType zTs = (ZonedTimestampType)type;
                writer.writeZonedTimestamp(pos, (ZonedTimestampData)o, zTs.getPrecision());
                break;
            }
            case FLOAT: {
                writer.writeFloat(pos, ((Float)o).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble(pos, (Double)o);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                writer.writeString(pos, (StringData)o);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                writer.writeDecimal(pos, (DecimalData)o, decimalType.getPrecision());
                break;
            }
            case ARRAY: {
                writer.writeArray(pos, (ArrayData)o, (ArrayDataSerializer)serializer);
                break;
            }
            case MAP: {
                writer.writeMap(pos, (MapData)o, serializer);
                break;
            }
            case ROW: {
                writer.writeRecord(pos, (RecordData)o, serializer);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                writer.writeBinary(pos, (byte[])o);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not support type: " + type);
            }
        }
    }
}

