/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.data.writer;

import com.ververica.cdc.common.annotation.Internal;
import com.ververica.cdc.common.data.binary.BinaryRecordData;
import com.ververica.cdc.common.data.binary.BinarySegmentUtils;
import com.ververica.cdc.runtime.serializer.data.writer.AbstractBinaryWriter;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;

@Internal
public final class BinaryRecordDataWriter
extends AbstractBinaryWriter {
    private final int nullBitsSizeInBytes;
    private final BinaryRecordData row;
    private final int fixedSize;

    public BinaryRecordDataWriter(BinaryRecordData row) {
        this(row, 0);
    }

    public BinaryRecordDataWriter(BinaryRecordData row, int initialSize) {
        this.nullBitsSizeInBytes = BinaryRecordData.calculateBitSetWidthInBytes((int)row.getArity());
        this.cursor = this.fixedSize = row.getFixedLengthPartSize();
        this.segment = MemorySegmentFactory.wrap((byte[])new byte[this.fixedSize + initialSize]);
        this.row = row;
        this.row.pointTo(this.segment, 0, this.segment.size());
    }

    @Override
    public void reset() {
        this.cursor = this.fixedSize;
        for (int i = 0; i < this.nullBitsSizeInBytes; i += 8) {
            this.segment.putLong(i, 0L);
        }
    }

    @Override
    public void setNullAt(int pos) {
        this.setNullBit(pos);
        this.segment.putLong(this.getFieldOffset(pos), 0L);
    }

    @Override
    public void setNullBit(int pos) {
        BinarySegmentUtils.bitSet((MemorySegment)this.segment, (int)0, (int)(pos + 8));
    }

    @Override
    public void writeBoolean(int pos, boolean value) {
        this.segment.putBoolean(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeByte(int pos, byte value) {
        this.segment.put(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeShort(int pos, short value) {
        this.segment.putShort(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeInt(int pos, int value) {
        this.segment.putInt(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeLong(int pos, long value) {
        this.segment.putLong(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeFloat(int pos, float value) {
        this.segment.putFloat(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeDouble(int pos, double value) {
        this.segment.putDouble(this.getFieldOffset(pos), value);
    }

    @Override
    public void complete() {
        this.row.setTotalSize(this.cursor);
    }

    @Override
    public int getFieldOffset(int pos) {
        return this.nullBitsSizeInBytes + 8 * pos;
    }

    @Override
    public void setOffsetAndSize(int pos, int offset, long size) {
        long offsetAndSize = (long)offset << 32 | size;
        this.segment.putLong(this.getFieldOffset(pos), offsetAndSize);
    }

    @Override
    public void afterGrow() {
        this.row.pointTo(this.segment, 0, this.segment.size());
    }
}

