/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.data;

import com.ververica.cdc.common.data.DecimalData;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class DecimalDataSerializer
extends TypeSerializer<DecimalData> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;

    public DecimalDataSerializer(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    public boolean isImmutableType() {
        return false;
    }

    public DecimalData createInstance() {
        return DecimalData.zero((int)this.precision, (int)this.scale);
    }

    public DecimalData copy(DecimalData from) {
        return from.copy();
    }

    public DecimalData copy(DecimalData from, DecimalData reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DecimalData record, DataOutputView target) throws IOException {
        if (DecimalData.isCompact((int)this.precision)) {
            assert (record.isCompact());
            target.writeLong(record.toUnscaledLong());
        } else {
            byte[] bytes = record.toUnscaledBytes();
            target.writeInt(bytes.length);
            target.write(bytes);
        }
    }

    public DecimalData deserialize(DataInputView source) throws IOException {
        if (DecimalData.isCompact((int)this.precision)) {
            long longVal = source.readLong();
            return DecimalData.fromUnscaledLong((long)longVal, (int)this.precision, (int)this.scale);
        }
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return DecimalData.fromUnscaledBytes((byte[])bytes, (int)this.precision, (int)this.scale);
    }

    public DecimalData deserialize(DecimalData record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (DecimalData.isCompact((int)this.precision)) {
            target.writeLong(source.readLong());
        } else {
            int len = source.readInt();
            target.writeInt(len);
            target.write(source, len);
        }
    }

    public DecimalDataSerializer duplicate() {
        return new DecimalDataSerializer(this.precision, this.scale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DecimalDataSerializer that = (DecimalDataSerializer)((Object)o);
        return this.precision == that.precision && this.scale == that.scale;
    }

    public int hashCode() {
        int result = this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    public TypeSerializerSnapshot<DecimalData> snapshotConfiguration() {
        return new DecimalSerializerSnapshot(this.precision, this.scale);
    }

    public static final class DecimalSerializerSnapshot
    implements TypeSerializerSnapshot<DecimalData> {
        private static final int CURRENT_VERSION = 3;
        private int previousPrecision;
        private int previousScale;

        public DecimalSerializerSnapshot() {
        }

        DecimalSerializerSnapshot(int precision, int scale) {
            this.previousPrecision = precision;
            this.previousScale = scale;
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousPrecision);
            out.writeInt(this.previousScale);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.previousPrecision = in.readInt();
            this.previousScale = in.readInt();
        }

        public TypeSerializer<DecimalData> restoreSerializer() {
            return new DecimalDataSerializer(this.previousPrecision, this.previousScale);
        }

        public TypeSerializerSchemaCompatibility<DecimalData> resolveSchemaCompatibility(TypeSerializer<DecimalData> newSerializer) {
            if (!(newSerializer instanceof DecimalDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            DecimalDataSerializer newDecimalDataSerializer = (DecimalDataSerializer)newSerializer;
            if (this.previousPrecision != newDecimalDataSerializer.precision || this.previousScale != newDecimalDataSerializer.scale) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

