/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.data;

import com.ververica.cdc.common.annotation.VisibleForTesting;
import com.ververica.cdc.common.data.ArrayData;
import com.ververica.cdc.common.data.GenericArrayData;
import com.ververica.cdc.common.types.DataType;
import com.ververica.cdc.common.types.utils.DataTypeUtils;
import com.ververica.cdc.common.utils.InstantiationUtil;
import com.ververica.cdc.runtime.serializer.InternalSerializers;
import com.ververica.cdc.runtime.serializer.NullableSerializerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class ArrayDataSerializer
extends TypeSerializer<ArrayData> {
    private static final long serialVersionUID = 1L;
    private final DataType eleType;
    private final TypeSerializer<Object> eleSer;
    private final ArrayData.ElementGetter elementGetter;

    public ArrayDataSerializer(DataType eleType) {
        this(eleType, InternalSerializers.create(eleType));
    }

    private ArrayDataSerializer(DataType eleType, TypeSerializer<Object> eleSer) {
        this.eleType = eleType;
        this.eleSer = new NullableSerializerWrapper<Object>(eleSer);
        this.elementGetter = ArrayData.createElementGetter((DataType)eleType);
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<ArrayData> duplicate() {
        return new ArrayDataSerializer(this.eleType, (TypeSerializer<Object>)this.eleSer.duplicate());
    }

    public ArrayData createInstance() {
        return new GenericArrayData(new Object[0]);
    }

    public ArrayData copy(ArrayData from) {
        return this.copyGenericArray((GenericArrayData)from);
    }

    public ArrayData copy(ArrayData from, ArrayData reuse) {
        return this.copy(from);
    }

    private GenericArrayData copyGenericArray(GenericArrayData array) {
        if (array.isPrimitiveArray()) {
            switch (this.eleType.getTypeRoot()) {
                case BOOLEAN: {
                    return new GenericArrayData(Arrays.copyOf(array.toBooleanArray(), array.size()));
                }
                case TINYINT: {
                    return new GenericArrayData(Arrays.copyOf(array.toByteArray(), array.size()));
                }
                case SMALLINT: {
                    return new GenericArrayData(Arrays.copyOf(array.toShortArray(), array.size()));
                }
                case INTEGER: {
                    return new GenericArrayData(Arrays.copyOf(array.toIntArray(), array.size()));
                }
                case BIGINT: {
                    return new GenericArrayData(Arrays.copyOf(array.toLongArray(), array.size()));
                }
                case FLOAT: {
                    return new GenericArrayData(Arrays.copyOf(array.toFloatArray(), array.size()));
                }
                case DOUBLE: {
                    return new GenericArrayData(Arrays.copyOf(array.toDoubleArray(), array.size()));
                }
            }
            throw new RuntimeException("Unknown type: " + this.eleType);
        }
        Object[] objectArray = array.toObjectArray();
        Object[] newArray = (Object[])Array.newInstance(DataTypeUtils.toInternalConversionClass((DataType)this.eleType), array.size());
        for (int i = 0; i < array.size(); ++i) {
            if (objectArray[i] == null) continue;
            newArray[i] = this.eleSer.copy(objectArray[i]);
        }
        return new GenericArrayData(newArray);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(ArrayData record, DataOutputView target) throws IOException {
        target.writeInt(record.size());
        for (int i = 0; i < record.size(); ++i) {
            this.eleSer.serialize(this.elementGetter.getElementOrNull(record, i), target);
        }
    }

    public ArrayData deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.eleSer.deserialize(source);
        }
        return new GenericArrayData(array);
    }

    public ArrayData deserialize(ArrayData reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ArrayDataSerializer that = (ArrayDataSerializer)((Object)o);
        return this.eleType.equals((Object)that.eleType);
    }

    public int hashCode() {
        return this.eleType.hashCode();
    }

    @VisibleForTesting
    public TypeSerializer getEleSer() {
        return this.eleSer;
    }

    public TypeSerializerSnapshot<ArrayData> snapshotConfiguration() {
        return new ArrayDataSerializerSnapshot(this.eleType, this.eleSer);
    }

    public static final class ArrayDataSerializerSnapshot
    implements TypeSerializerSnapshot<ArrayData> {
        private static final int CURRENT_VERSION = 3;
        private DataType previousType;
        private TypeSerializer previousEleSer;

        public ArrayDataSerializerSnapshot() {
        }

        ArrayDataSerializerSnapshot(DataType eleType, TypeSerializer eleSer) {
            this.previousType = eleType;
            this.previousEleSer = eleSer;
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            DataOutputViewStream outStream = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousType);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousEleSer);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            try {
                DataInputViewStream inStream = new DataInputViewStream(in);
                this.previousType = (DataType)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
                this.previousEleSer = (TypeSerializer)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public TypeSerializer<ArrayData> restoreSerializer() {
            return new ArrayDataSerializer(this.previousType, this.previousEleSer);
        }

        public TypeSerializerSchemaCompatibility<ArrayData> resolveSchemaCompatibility(TypeSerializer<ArrayData> newSerializer) {
            if (!(newSerializer instanceof ArrayDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            ArrayDataSerializer newArrayDataSerializer = (ArrayDataSerializer)newSerializer;
            if (!this.previousType.equals((Object)newArrayDataSerializer.eleType) || !this.previousEleSer.equals((Object)newArrayDataSerializer.eleSer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

