/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer;

import com.ververica.cdc.common.types.ArrayType;
import com.ververica.cdc.common.types.DataType;
import com.ververica.cdc.common.types.DataTypeChecks;
import com.ververica.cdc.runtime.serializer.BooleanSerializer;
import com.ververica.cdc.runtime.serializer.BytePrimitiveArraySerializer;
import com.ververica.cdc.runtime.serializer.ByteSerializer;
import com.ververica.cdc.runtime.serializer.DoubleSerializer;
import com.ververica.cdc.runtime.serializer.FloatSerializer;
import com.ververica.cdc.runtime.serializer.IntSerializer;
import com.ververica.cdc.runtime.serializer.LongSerializer;
import com.ververica.cdc.runtime.serializer.ShortSerializer;
import com.ververica.cdc.runtime.serializer.data.ArrayDataSerializer;
import com.ververica.cdc.runtime.serializer.data.DecimalDataSerializer;
import com.ververica.cdc.runtime.serializer.data.LocalZonedTimestampDataSerializer;
import com.ververica.cdc.runtime.serializer.data.RecordDataSerializer;
import com.ververica.cdc.runtime.serializer.data.StringDataSerializer;
import com.ververica.cdc.runtime.serializer.data.TimestampDataSerializer;
import com.ververica.cdc.runtime.serializer.data.ZonedTimestampDataSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializer;

public class InternalSerializers {
    public static <T> TypeSerializer<T> create(DataType type) {
        return InternalSerializers.createInternal(type);
    }

    private static TypeSerializer<?> createInternal(DataType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return StringDataSerializer.INSTANCE;
            }
            case BOOLEAN: {
                return BooleanSerializer.INSTANCE;
            }
            case BINARY: 
            case VARBINARY: {
                return BytePrimitiveArraySerializer.INSTANCE;
            }
            case DECIMAL: {
                return new DecimalDataSerializer(DataTypeChecks.getPrecision((DataType)type), DataTypeChecks.getScale((DataType)type));
            }
            case TINYINT: {
                return ByteSerializer.INSTANCE;
            }
            case SMALLINT: {
                return ShortSerializer.INSTANCE;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return IntSerializer.INSTANCE;
            }
            case BIGINT: {
                return LongSerializer.INSTANCE;
            }
            case FLOAT: {
                return FloatSerializer.INSTANCE;
            }
            case DOUBLE: {
                return DoubleSerializer.INSTANCE;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return new TimestampDataSerializer(DataTypeChecks.getPrecision((DataType)type));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new LocalZonedTimestampDataSerializer(DataTypeChecks.getPrecision((DataType)type));
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return new ZonedTimestampDataSerializer(DataTypeChecks.getPrecision((DataType)type));
            }
            case ARRAY: {
                return new ArrayDataSerializer(((ArrayType)type).getElementType());
            }
            case ROW: {
                return new RecordDataSerializer();
            }
        }
        throw new UnsupportedOperationException("Unsupported type '" + type + "' to get internal serializer");
    }

    private InternalSerializers() {
    }
}

