/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer;

import com.ververica.cdc.runtime.serializer.TypeSerializerSingleton;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class BytePrimitiveArraySerializer
extends TypeSerializerSingleton<byte[]> {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY = new byte[0];
    public static final BytePrimitiveArraySerializer INSTANCE = new BytePrimitiveArraySerializer();

    public boolean isImmutableType() {
        return false;
    }

    public byte[] createInstance() {
        return EMPTY;
    }

    public byte[] copy(byte[] from) {
        byte[] copy = new byte[from.length];
        System.arraycopy(from, 0, copy, 0, from.length);
        return copy;
    }

    public byte[] copy(byte[] from, byte[] reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(byte[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        target.write(record);
    }

    public byte[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        byte[] result = new byte[len];
        source.readFully(result);
        return result;
    }

    public byte[] deserialize(byte[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len);
    }

    public TypeSerializerSnapshot<byte[]> snapshotConfiguration() {
        return new BytePrimitiveArraySerializerSnapshot();
    }

    public static final class BytePrimitiveArraySerializerSnapshot
    extends SimpleTypeSerializerSnapshot<byte[]> {
        public BytePrimitiveArraySerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

