/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.operators.sink;

import com.ververica.cdc.common.annotation.Internal;
import com.ververica.cdc.common.event.ChangeEvent;
import com.ververica.cdc.common.event.CreateTableEvent;
import com.ververica.cdc.common.event.Event;
import com.ververica.cdc.common.event.FlushEvent;
import com.ververica.cdc.common.event.TableId;
import com.ververica.cdc.common.schema.Schema;
import com.ververica.cdc.runtime.operators.sink.SchemaEvolutionClient;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

@Internal
public class DataSinkWriterOperator<CommT>
extends AbstractStreamOperator<CommittableMessage<CommT>>
implements OneInputStreamOperator<Event, CommittableMessage<CommT>>,
BoundedOneInput {
    private SchemaEvolutionClient schemaEvolutionClient;
    private final OperatorID schemaOperatorID;
    private final Sink<Event> sink;
    private final ProcessingTimeService processingTimeService;
    private final MailboxExecutor mailboxExecutor;
    private Object flinkWriterOperator;
    private SinkWriter<Event> copySinkWriter;
    private final Set<TableId> processedTableIds;

    public DataSinkWriterOperator(Sink<Event> sink, ProcessingTimeService processingTimeService, MailboxExecutor mailboxExecutor, OperatorID schemaOperatorID) {
        this.sink = sink;
        this.processingTimeService = processingTimeService;
        this.mailboxExecutor = mailboxExecutor;
        this.schemaOperatorID = schemaOperatorID;
        this.processedTableIds = new HashSet<TableId>();
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<CommittableMessage<CommT>>> output) {
        super.setup(containingTask, config, output);
        this.flinkWriterOperator = this.createFlinkWriterOperator();
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).setup(containingTask, config, output);
        this.schemaEvolutionClient = new SchemaEvolutionClient(containingTask.getEnvironment().getOperatorCoordinatorEventGateway(), this.schemaOperatorID);
    }

    public void open() throws Exception {
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).open();
        this.copySinkWriter = (SinkWriter)this.getFieldValue("sinkWriter");
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        this.schemaEvolutionClient.registerSubtask(this.getRuntimeContext().getIndexOfThisSubtask());
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).initializeState(context);
    }

    public void processElement(StreamRecord<Event> element) throws Exception {
        Event event = (Event)element.getValue();
        if (event instanceof FlushEvent) {
            this.handleFlushEvent((FlushEvent)event);
            return;
        }
        if (event instanceof CreateTableEvent) {
            this.processedTableIds.add(((CreateTableEvent)event).tableId());
            ((OneInputStreamOperator)this.getFlinkWriterOperator()).processElement(element);
            return;
        }
        ChangeEvent changeEvent = (ChangeEvent)event;
        if (!this.processedTableIds.contains(changeEvent.tableId())) {
            this.emitLatestSchema(changeEvent.tableId());
            this.processedTableIds.add(changeEvent.tableId());
        }
        this.processedTableIds.add(changeEvent.tableId());
        ((OneInputStreamOperator)this.getFlinkWriterOperator()).processElement(element);
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).prepareSnapshotPreBarrier(checkpointId);
    }

    public void close() throws Exception {
        ((OneInputStreamOperator)this.getFlinkWriterOperator()).close();
    }

    public void endInput() throws Exception {
        ((BoundedOneInput)this.getFlinkWriterOperator()).endInput();
    }

    private void handleFlushEvent(FlushEvent event) throws Exception {
        this.copySinkWriter.flush(false);
        this.schemaEvolutionClient.notifyFlushSuccess(this.getRuntimeContext().getIndexOfThisSubtask(), event.getTableId());
    }

    private void emitLatestSchema(TableId tableId) throws Exception {
        Optional<Schema> schema = this.schemaEvolutionClient.getLatestSchema(tableId);
        if (!schema.isPresent()) {
            throw new RuntimeException("Could not find schema message from SchemaRegistry for " + tableId);
        }
        ((OneInputStreamOperator)this.getFlinkWriterOperator()).processElement(new StreamRecord((Object)new CreateTableEvent(tableId, schema.get())));
        this.processedTableIds.add(tableId);
    }

    private Object createFlinkWriterOperator() {
        try {
            Class<?> flinkWriterClass = this.getRuntimeContext().getUserCodeClassLoader().loadClass("org.apache.flink.streaming.runtime.operators.sink.SinkWriterOperator");
            Constructor<?> constructor = flinkWriterClass.getDeclaredConstructor(Sink.class, ProcessingTimeService.class, MailboxExecutor.class);
            constructor.setAccessible(true);
            return constructor.newInstance(this.sink, this.processingTimeService, this.mailboxExecutor);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SinkWriterOperator in Flink", e);
        }
    }

    private <T> T getFieldValue(String fieldName) throws IllegalAccessException {
        for (Class<?> clazz = this.flinkWriterOperator.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return (T)field.get(this.flinkWriterOperator);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new RuntimeException("failed to get sinkWriter");
    }

    private <T> T getFlinkWriterOperator() {
        return (T)this.flinkWriterOperator;
    }
}

