/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.semver4j;

import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.SemverException;
import java.util.Objects;

public class Semver
implements Comparable<Semver> {
    private final String originalValue;
    private final String value;
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    private final String[] suffixTokens;
    private final String build;
    private final SemverType type;

    public Semver(String value) {
        this(value, SemverType.STRICT);
    }

    public Semver(String value, SemverType type) {
        String[] tmp;
        this.originalValue = value;
        this.type = type;
        value = value.trim();
        if (type == SemverType.NPM && (value.startsWith("v") || value.startsWith("V"))) {
            value = value.substring(1).trim();
        }
        this.value = value;
        String[] tokens = value.split("-");
        String build = null;
        Integer minor = null;
        Integer patch = null;
        try {
            String[] mainTokens;
            block23: {
                if (tokens.length == 1) {
                    if (tokens[0].endsWith("+")) {
                        throw new SemverException("The build cannot be empty.");
                    }
                    tmp = tokens[0].split("\\+");
                    mainTokens = tmp[0].split("\\.");
                    if (tmp.length == 2) {
                        build = tmp[1];
                    }
                } else {
                    mainTokens = tokens[0].split("\\.");
                }
                try {
                    this.major = Integer.valueOf(mainTokens[0]);
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    throw new SemverException("Invalid version (no major version): " + value);
                }
                try {
                    minor = Integer.valueOf(mainTokens[1]);
                }
                catch (IndexOutOfBoundsException e) {
                    if (type == SemverType.STRICT) {
                        throw new SemverException("Invalid version (no minor version): " + value);
                    }
                }
                catch (NumberFormatException e) {
                    if (type == SemverType.NPM && ("x".equalsIgnoreCase(mainTokens[1]) || "*".equals(mainTokens[1]))) break block23;
                    throw new SemverException("Invalid version (no minor version): " + value);
                }
            }
            try {
                patch = Integer.valueOf(mainTokens[2]);
            }
            catch (IndexOutOfBoundsException e) {
                if (type == SemverType.STRICT) {
                    throw new SemverException("Invalid version (no patch version): " + value);
                }
            }
            catch (NumberFormatException e) {
                if (type != SemverType.NPM || !"x".equalsIgnoreCase(mainTokens[2]) && !"*".equals(mainTokens[2])) {
                    throw new SemverException("Invalid version (no patch version): " + value);
                }
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new SemverException("The version is invalid: " + value);
        }
        this.minor = minor;
        this.patch = patch;
        String[] suffix = new String[]{};
        try {
            if (tokens[1].endsWith("+")) {
                throw new SemverException("The build cannot be empty.");
            }
            tmp = tokens[1].split("\\+");
            if (tmp.length == 2) {
                suffix = tmp[0].split("\\.");
                build = tmp[1];
            } else {
                suffix = tokens[1].split("\\.");
            }
        }
        catch (IndexOutOfBoundsException ignored) {
            // empty catch block
        }
        this.suffixTokens = suffix;
        this.build = build;
        this.validate(type);
    }

    private void validate(SemverType type) {
        if (this.minor == null && type == SemverType.STRICT) {
            throw new SemverException("Invalid version (no minor version): " + this.value);
        }
        if (this.patch == null && type == SemverType.STRICT) {
            throw new SemverException("Invalid version (no patch version): " + this.value);
        }
    }

    public boolean satisfies(Requirement requirement) {
        return requirement.isSatisfiedBy(this);
    }

    public boolean satisfies(String requirement) {
        Requirement req;
        switch (this.type) {
            case STRICT: {
                req = Requirement.buildStrict(requirement);
                break;
            }
            case LOOSE: {
                req = Requirement.buildLoose(requirement);
                break;
            }
            case NPM: {
                req = Requirement.buildNPM(requirement);
                break;
            }
            default: {
                throw new SemverException("Invalid requirement type: " + (Object)((Object)this.type));
            }
        }
        return this.satisfies(req);
    }

    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(new Semver(version, this.getType()));
    }

    public boolean isGreaterThan(Semver version) {
        int otherPatch;
        int otherMinor;
        if (this.getMajor() > version.getMajor()) {
            return true;
        }
        if (this.getMajor() < version.getMajor()) {
            return false;
        }
        int n = otherMinor = version.getMinor() != null ? version.getMinor() : 0;
        if (this.getMinor() != null && this.getMinor() > otherMinor) {
            return true;
        }
        if (this.getMinor() != null && this.getMinor() < otherMinor) {
            return false;
        }
        int n2 = otherPatch = version.getPatch() != null ? version.getPatch() : 0;
        if (this.getPatch() != null && this.getPatch() > otherPatch) {
            return true;
        }
        if (this.getPatch() != null && this.getPatch() < otherPatch) {
            return false;
        }
        String[] tokens1 = this.getSuffixTokens();
        String[] tokens2 = version.getSuffixTokens();
        if (tokens1.length == 0 && tokens2.length > 0) {
            return true;
        }
        if (tokens2.length == 0 && tokens1.length > 0) {
            return false;
        }
        for (int i = 0; i < tokens1.length && i < tokens2.length; ++i) {
            int cmp;
            try {
                int t1 = Integer.valueOf(tokens1[i]);
                int t2 = Integer.valueOf(tokens2[i]);
                cmp = t1 - t2;
            }
            catch (NumberFormatException e) {
                cmp = tokens1[i].compareToIgnoreCase(tokens2[i]);
            }
            if (cmp < 0) {
                return false;
            }
            if (cmp <= 0) continue;
            return true;
        }
        return tokens1.length > tokens2.length;
    }

    public boolean isLowerThan(String version) {
        return this.isLowerThan(new Semver(version));
    }

    public boolean isLowerThan(Semver version) {
        return !this.isGreaterThan(version) && !this.isEquivalentTo(version);
    }

    public boolean isEquivalentTo(String version) {
        return this.isEquivalentTo(new Semver(version));
    }

    public boolean isEquivalentTo(Semver version) {
        Semver sem1 = this.getBuild() == null ? this : new Semver(this.getValue().replace("+" + this.getBuild(), ""));
        Semver sem2 = version.getBuild() == null ? version : new Semver(version.getValue().replace("+" + version.getBuild(), ""));
        return sem1.isEqualTo(sem2);
    }

    public boolean isEqualTo(String version) {
        return this.isEqualTo(new Semver(version));
    }

    public boolean isEqualTo(Semver version) {
        return this.equals(version);
    }

    public boolean isStable() {
        return this.getMajor() != null && this.getMajor() > 0 && (this.getSuffixTokens() == null || this.getSuffixTokens().length == 0);
    }

    public VersionDiff diff(String version) {
        return this.diff(new Semver(version));
    }

    public VersionDiff diff(Semver version) {
        if (!Objects.equals(this.major, version.getMajor())) {
            return VersionDiff.MAJOR;
        }
        if (!Objects.equals(this.minor, version.getMinor())) {
            return VersionDiff.MINOR;
        }
        if (!Objects.equals(this.patch, version.getPatch())) {
            return VersionDiff.PATCH;
        }
        if (!this.areSameSuffixes(version.getSuffixTokens())) {
            return VersionDiff.SUFFIX;
        }
        if (!Objects.equals(this.build, version.getBuild())) {
            return VersionDiff.BUILD;
        }
        return VersionDiff.NONE;
    }

    private boolean areSameSuffixes(String[] suffixTokens) {
        if (this.suffixTokens == null && suffixTokens == null) {
            return true;
        }
        if (this.suffixTokens == null || suffixTokens == null) {
            return false;
        }
        if (this.suffixTokens.length != suffixTokens.length) {
            return false;
        }
        for (int i = 0; i < this.suffixTokens.length; ++i) {
            if (this.suffixTokens[i].equals(suffixTokens[i])) continue;
            return false;
        }
        return true;
    }

    public Semver withIncMajor() {
        return this.withIncMajor(1);
    }

    public Semver withIncMajor(int increment) {
        return this.withInc(increment, 0, 0);
    }

    public Semver withIncMinor() {
        return this.withIncMinor(1);
    }

    public Semver withIncMinor(int increment) {
        return this.withInc(0, increment, 0);
    }

    public Semver withIncPatch() {
        return this.withIncPatch(1);
    }

    public Semver withIncPatch(int increment) {
        return this.withInc(0, 0, increment);
    }

    private Semver withInc(int majorInc, int minorInc, int patchInc) {
        Integer minor = this.minor;
        Integer patch = this.patch;
        if (this.minor != null) {
            minor = minor + minorInc;
        }
        if (this.patch != null) {
            patch = patch + patchInc;
        }
        return this.with(this.major + majorInc, minor, patch, true, true);
    }

    public Semver withClearedSuffix() {
        return this.with(this.major, this.minor, this.patch, false, true);
    }

    public Semver withClearedBuild() {
        return this.with(this.major, this.minor, this.patch, true, false);
    }

    public Semver withClearedSuffixAndBuild() {
        return this.with(this.major, this.minor, this.patch, false, false);
    }

    public Semver nextMajor() {
        return this.with(this.major + 1, 0, 0, false, false);
    }

    public Semver nextMinor() {
        return this.with(this.major, this.minor + 1, 0, false, false);
    }

    public Semver nextPatch() {
        return this.with(this.major, this.minor, this.patch + 1, false, false);
    }

    private Semver with(int major, Integer minor, Integer patch, boolean suffix, boolean build) {
        StringBuilder sb = new StringBuilder().append(major);
        if (this.minor != null) {
            sb.append(".").append(minor);
        }
        if (this.patch != null) {
            sb.append(".").append(patch);
        }
        if (suffix) {
            boolean first = true;
            for (String suffixToken : this.suffixTokens) {
                if (first) {
                    sb.append("-");
                    first = false;
                } else {
                    sb.append(".");
                }
                sb.append(suffixToken);
            }
        }
        if (this.build != null && build) {
            sb.append("+").append(this.build);
        }
        return new Semver(sb.toString(), this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Semver)) {
            return false;
        }
        Semver version = (Semver)o;
        return this.value.equals(version.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(Semver version) {
        if (this.isGreaterThan(version)) {
            return 1;
        }
        if (this.equals(version)) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return "Semver(" + this.value + ")";
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public String[] getSuffixTokens() {
        return this.suffixTokens;
    }

    public String getBuild() {
        return this.build;
    }

    public SemverType getType() {
        return this.type;
    }

    public static enum SemverType {
        STRICT,
        LOOSE,
        NPM;

    }

    public static enum VersionDiff {
        NONE,
        MAJOR,
        MINOR,
        PATCH,
        SUFFIX,
        BUILD;

    }
}

