/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.emoji;

import com.vdurmont.emoji.Fitzpatrick;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Emoji {
    private final String description;
    private final boolean supportsFitzpatrick;
    private final List<String> aliases;
    private final List<String> tags;
    private final String unicode;
    private final String htmlDec;
    private final String htmlHex;

    protected Emoji(String description, boolean supportsFitzpatrick, List<String> aliases, List<String> tags, byte ... bytes) {
        this.description = description;
        this.supportsFitzpatrick = supportsFitzpatrick;
        this.aliases = Collections.unmodifiableList(aliases);
        this.tags = Collections.unmodifiableList(tags);
        try {
            this.unicode = new String(bytes, "UTF-8");
            int htmlCode = Character.codePointAt(this.unicode, 0);
            this.htmlDec = "&#" + htmlCode + ";";
            this.htmlHex = "&#x" + Integer.toHexString(htmlCode) + ";";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean supportsFitzpatrick() {
        return this.supportsFitzpatrick;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public String getUnicode(Fitzpatrick fitzpatrick) {
        if (!this.supportsFitzpatrick()) {
            throw new UnsupportedOperationException("Cannot get the unicode with a fitzpatrick modifier, the emoji doesn't support fitzpatrick.");
        }
        if (fitzpatrick == null) {
            return this.getUnicode();
        }
        return this.getUnicode() + fitzpatrick.unicode;
    }

    public String getHtmlDecimal() {
        return this.htmlDec;
    }

    public String getHtmlHexidecimal() {
        return this.htmlHex;
    }

    public String toString() {
        return "Emoji{description='" + this.description + '\'' + ", supportsFitzpatrick=" + this.supportsFitzpatrick + ", aliases=" + this.aliases + ", tags=" + this.tags + ", unicode='" + this.unicode + '\'' + ", htmlDec='" + this.htmlDec + '\'' + ", htmlHex='" + this.htmlHex + '\'' + '}';
    }
}

