/*
 * Decompiled with CFR 0.152.
 */
package com.vdian.salon;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import com.vdian.uikit.view.TransitionController;
import java.util.ArrayList;
import java.util.List;

public abstract class SalonView
extends RelativeLayout {
    protected static final int CHILD_SIZE = 3;
    protected static final int CHILD_MARGIN = 20;
    protected static final float ZOOM_RANGE = 3.0f;
    protected float mOffset = 0.0f;
    protected ViewGroup mContainer;
    protected int mChildIndex = 0;
    protected View[] mExhibits = new View[3];
    protected float[] mDxs = new float[3];
    protected float[] mDys = new float[3];
    protected float[] mScales = new float[3];
    protected int mUrlIndex = 0;
    protected List<String> mUrls;
    protected boolean didLayout = false;
    protected boolean doConsume = false;
    protected boolean doSpring = false;
    protected boolean doZoom = false;
    protected float zoomX = 0.0f;
    protected float zoomY = 0.0f;
    protected SalonDelegate mDelegate;
    protected SalonAnimation mAnimator;

    public SalonView(Context context) {
        super(context);
        this.init();
    }

    public SalonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SalonView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void init() {
        this.mContainer = new RelativeLayout(this.getContext());
        this.mContainer.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addView((View)this.mContainer);
        for (int i = 0; i < 3; ++i) {
            this.mExhibits[i] = this.onCreateExhibit(this.getContext());
            this.mExhibits[i].setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.mContainer.addView(this.mExhibits[i]);
        }
        this.mDelegate = new SalonDelegate();
    }

    public void display(int index, List<String> urls) {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        this.mOffset = 0.0f;
        this.mChildIndex = 0;
        this.mUrlIndex = index;
        this.mUrls = urls;
        for (int d = 0; d <= 1; ++d) {
            int l = (3 + this.mChildIndex - d) % 3;
            this.mDxs[l] = 0.0f;
            this.mDys[l] = 0.0f;
            this.mScales[l] = 1.0f;
            ((SalonExhibit)this.mExhibits[l]).setMatrix(this.mDxs[l], this.mDys[l], this.mScales[l]);
            String lUrl = null;
            if (this.mUrlIndex - d >= 0 && this.mUrlIndex - d < this.mUrls.size()) {
                lUrl = this.mUrls.get(this.mUrlIndex - d);
            }
            ((SalonExhibit)this.mExhibits[l]).loadUrl(lUrl);
            if (d == 0) continue;
            int r = (3 + this.mChildIndex + d) % 3;
            this.mDxs[r] = 0.0f;
            this.mDys[r] = 0.0f;
            this.mScales[r] = 1.0f;
            ((SalonExhibit)this.mExhibits[r]).setMatrix(this.mDxs[r], this.mDys[r], this.mScales[r]);
            String rUrl = null;
            if (this.mUrlIndex + d >= 0 && this.mUrlIndex + d < this.mUrls.size()) {
                rUrl = this.mUrls.get(this.mUrlIndex + d);
            }
            ((SalonExhibit)this.mExhibits[r]).loadUrl(rUrl);
        }
        this.update();
    }

    protected boolean update() {
        boolean reset = false;
        if (this.didLayout) {
            while (Math.abs(this.mOffset) >= (float)this.getWidth() + 20.0f * this.getContext().getResources().getDisplayMetrics().density) {
                int direction;
                int n = direction = this.mOffset > 0.0f ? 1 : -1;
                if (direction < 0 && this.mUrlIndex <= 0 || direction > 0 && this.mUrlIndex >= this.mUrls.size() - 1) break;
                this.mDxs[this.mChildIndex] = 0.0f;
                this.mDys[this.mChildIndex] = 0.0f;
                this.mScales[this.mChildIndex] = 1.0f;
                ((SalonExhibit)this.mExhibits[this.mChildIndex]).setMatrix(this.mDxs[this.mChildIndex], this.mDys[this.mChildIndex], this.mScales[this.mChildIndex]);
                String url = null;
                int d = (direction > 0 ? 1 : -1) * 2;
                if (this.mUrlIndex + d >= 0 && this.mUrlIndex + d < this.mUrls.size()) {
                    url = this.mUrls.get(this.mUrlIndex + d);
                }
                ((SalonExhibit)this.mExhibits[(3 + this.mChildIndex - (direction > 0 ? 1 : -1) * 3 / 2) % 3]).loadUrl(url);
                this.mOffset -= (float)direction * ((float)this.getWidth() + 20.0f * this.getContext().getResources().getDisplayMetrics().density);
                this.mChildIndex = (3 + this.mChildIndex + direction) % 3;
                this.mUrlIndex += direction;
                reset = true;
            }
            for (int d = 0; d <= 1; ++d) {
                this.mExhibits[(3 + this.mChildIndex - d) % 3].setTranslationX((float)(-d) * ((float)this.getWidth() + 20.0f * this.getContext().getResources().getDisplayMetrics().density));
                if (d == 0) continue;
                this.mExhibits[(3 + this.mChildIndex + d) % 3].setTranslationX((float)d * ((float)this.getWidth() + 20.0f * this.getContext().getResources().getDisplayMetrics().density));
            }
            this.mContainer.scrollTo((int)this.mOffset, 0);
            this.onUpdate((float)this.mUrlIndex + this.mOffset / ((float)this.getWidth() + 20.0f * this.getContext().getResources().getDisplayMetrics().density), this.mUrls != null ? this.mUrls.size() : 0);
        }
        return reset;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.didLayout = true;
        this.update();
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        return this.mDelegate.dispatchTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mDelegate.onInterceptTouchEvent(event);
    }

    protected void permitTouchEvent(boolean permit) {
        this.mDelegate.permitTouchEvent(permit);
    }

    protected void down() {
        this.doConsume = false;
        this.doSpring = false;
        this.doZoom = false;
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
    }

    protected void premove(boolean x, boolean y) {
        float ratio = ((SalonExhibit)this.mExhibits[this.mChildIndex]).getRatio();
        if (ratio > 0.0f) {
            if (this.mScales[this.mChildIndex] < 1.0f || this.mScales[this.mChildIndex] > 3.0f || this.mDxs[this.mChildIndex] != this.reform(true, ratio, this.mScales[this.mChildIndex], this.mDxs[this.mChildIndex]) || this.mDys[this.mChildIndex] != this.reform(false, ratio, this.mScales[this.mChildIndex], this.mDys[this.mChildIndex])) {
                this.doSpring = true;
            } else if (this.mOffset == 0.0f && y && this.overflow(false, ratio, this.mScales[this.mChildIndex]) > 0.0f && this.overflow(true, ratio, this.mScales[this.mChildIndex]) <= 0.0f) {
                this.doConsume = true;
            }
        }
    }

    protected void move(float dx, float dy, float px, float py, float sk) {
        float ratio = ((SalonExhibit)this.mExhibits[this.mChildIndex]).getRatio();
        if (this.mOffset != 0.0f || ratio <= 0.0f) {
            if (this.mUrlIndex <= 0 && this.mOffset < 0.0f || this.mUrlIndex >= this.mUrls.size() - 1 && this.mOffset > 0.0f) {
                float k = ((float)this.getWidth() - Math.abs(this.mOffset)) / (float)this.getWidth();
                if (k <= 0.0f) {
                    dx = 0.0f;
                } else if (k < 1.0f) {
                    dx *= (float)Math.pow(k, 4.3);
                }
            }
            float tmp = this.mOffset;
            this.mOffset -= dx;
            if (this.mOffset * tmp < 0.0f) {
                this.mOffset = 0.0f;
            }
            this.update();
        } else {
            float ks;
            float kx = ((float)this.getWidth() - Math.abs(this.mDxs[this.mChildIndex] - this.reform(true, ratio, this.mScales[this.mChildIndex], this.mDxs[this.mChildIndex]))) / (float)this.getWidth();
            if (kx <= 0.0f) {
                dx = 0.0f;
            } else if (kx < 1.0f) {
                dx *= (float)Math.pow(kx, 4.3);
            }
            float ky = ((float)this.getHeight() - Math.abs(this.mDys[this.mChildIndex] - this.reform(false, ratio, this.mScales[this.mChildIndex], this.mDys[this.mChildIndex]))) / (float)this.getHeight();
            if (ky <= 0.0f) {
                dy = 0.0f;
            } else if (ky < 1.0f) {
                dy *= (float)Math.pow(ky, 4.3);
            }
            float f = this.mScales[this.mChildIndex] < 1.0f ? this.mScales[this.mChildIndex] : (ks = this.mScales[this.mChildIndex] > 3.0f ? 2.0f - this.mScales[this.mChildIndex] / 3.0f : 1.0f);
            if (ks <= 0.0f) {
                sk = 1.0f;
            } else if (ks < 1.0f) {
                sk = (float)(1.0 + (double)(sk - 1.0f) * Math.pow(ks, 4.3 * (this.mScales[this.mChildIndex] < 1.0f ? 1.0 : 0.5)));
            }
            dy += (this.mDys[this.mChildIndex] + (float)(this.getHeight() / 2) - py) * (sk - 1.0f) + this.mDys[this.mChildIndex];
            dx += (this.mDxs[this.mChildIndex] + (float)(this.getWidth() / 2) - px) * (sk - 1.0f) + this.mDxs[this.mChildIndex];
            if ((sk *= this.mScales[this.mChildIndex]) != this.mScales[this.mChildIndex]) {
                this.doConsume = false;
                this.doSpring = true;
            } else {
                if (this.doConsume) {
                    dx = this.mDxs[this.mChildIndex];
                }
                if (!this.doSpring) {
                    if (this.overflow(false, ratio, this.mScales[this.mChildIndex]) <= 0.0f) {
                        dy = this.mDys[this.mChildIndex];
                    }
                    float rx = this.reform(true, ratio, this.mScales[this.mChildIndex], dx);
                    float ry = this.reform(false, ratio, this.mScales[this.mChildIndex], dy);
                    if (dx != rx) {
                        this.mOffset -= dx - rx;
                        dx = rx;
                        dy = ry;
                        this.update();
                    } else if (dy != ry) {
                        this.doSpring = true;
                    }
                }
            }
            this.mScales[this.mChildIndex] = sk;
            this.mDxs[this.mChildIndex] = dx;
            this.mDys[this.mChildIndex] = dy;
            ((SalonExhibit)this.mExhibits[this.mChildIndex]).setMatrix(this.mDxs[this.mChildIndex], this.mDys[this.mChildIndex], this.mScales[this.mChildIndex]);
        }
    }

    protected void up(final float vx, final float vy) {
        final float ratio = ((SalonExhibit)this.mExhibits[this.mChildIndex]).getRatio();
        if (this.mOffset != 0.0f) {
            int direction = 0;
            if (Math.abs(vx) > 0.4f * this.getContext().getResources().getDisplayMetrics().density) {
                if (vx < 0.0f) {
                    if (this.mOffset > 0.0f) {
                        direction = 1;
                    }
                } else if (this.mOffset < 0.0f) {
                    direction = -1;
                }
            } else if (Math.abs(this.mOffset) > ((float)this.getWidth() + 20.0f * this.getContext().getResources().getDisplayMetrics().density) / 2.0f) {
                direction = this.mOffset > 0.0f ? 1 : -1;
            }
            if (direction < 0 && this.mUrlIndex <= 0 || direction > 0 && this.mUrlIndex >= this.mUrls.size() - 1) {
                direction = 0;
            }
            final float sOffset = this.mOffset;
            final float eOffset = direction == 0 ? 0.0f : (direction > 0 ? (float)this.getWidth() + 20.0f * this.getContext().getResources().getDisplayMetrics().density : (float)(-this.getWidth()) - 20.0f * this.getContext().getResources().getDisplayMetrics().density);
            this.mAnimator = new SalonAnimation((long)(300.0f + 100.0f * Math.abs(eOffset - sOffset) / (float)this.getWidth()), (TimeInterpolator)new Interpolator(){

                public float getInterpolation(float input) {
                    if (input > 0.0f && input < 1.0f) {
                        input = 1.0f - (1.0f - input) * (1.0f - input);
                        input = (float)(Math.cos((double)(input + 1.0f) * Math.PI) / 2.0) + 0.5f;
                    }
                    return input;
                }
            }){

                @Override
                protected void display(SalonAnimation animation, float value, long time) {
                    SalonView.this.mOffset = sOffset * (1.0f - value) + eOffset * value;
                    if (SalonView.this.update()) {
                        animation.cancel();
                    }
                }
            }.start();
        } else if (ratio > 0.0f) {
            if (this.doZoom) {
                float eDy;
                float eDx;
                float eScale;
                final float sScale = this.mScales[this.mChildIndex];
                final float sDx = this.mDxs[this.mChildIndex];
                final float sDy = this.mDys[this.mChildIndex];
                if (sScale <= 1.0f) {
                    eScale = 3.0f;
                    float tDx = (sDx + (float)(this.getWidth() / 2) - this.zoomX) * (eScale / sScale - 1.0f);
                    eDx = this.reform(true, ratio, 3.0f, tDx);
                    float tDy = (sDy + (float)(this.getHeight() / 2) - this.zoomY) * (eScale / sScale - 1.0f);
                    eDy = this.reform(false, ratio, 3.0f, tDy);
                } else {
                    eScale = 1.0f;
                    eDx = 0.0f;
                    eDy = 0.0f;
                }
                this.mAnimator = new SalonAnimation((long)(150.0f + 150.0f * Math.abs(eScale - sScale) / 2.0f), (TimeInterpolator)new AccelerateDecelerateInterpolator()){

                    @Override
                    protected void display(SalonAnimation animation, float value, long time) {
                        SalonView.this.mScales[SalonView.this.mChildIndex] = sScale * (1.0f - value) + eScale * value;
                        SalonView.this.mDxs[SalonView.this.mChildIndex] = sDx * (1.0f - value) + eDx * value;
                        SalonView.this.mDys[SalonView.this.mChildIndex] = sDy * (1.0f - value) + eDy * value;
                        ((SalonExhibit)SalonView.this.mExhibits[SalonView.this.mChildIndex]).setMatrix(SalonView.this.mDxs[SalonView.this.mChildIndex], SalonView.this.mDys[SalonView.this.mChildIndex], SalonView.this.mScales[SalonView.this.mChildIndex]);
                    }
                }.start();
            } else if (this.mScales[this.mChildIndex] < 1.0f) {
                final float sScale = this.mScales[this.mChildIndex];
                float eScale = 1.0f;
                final float sDx = this.mDxs[this.mChildIndex];
                float eDx = 0.0f;
                final float sDy = this.mDys[this.mChildIndex];
                float eDy = 0.0f;
                this.mAnimator = new SalonAnimation((long)(200.0f + 100.0f * (1.0f - sScale)), (TimeInterpolator)new DecelerateInterpolator()){

                    @Override
                    protected void display(SalonAnimation animation, float value, long time) {
                        SalonView.this.mScales[SalonView.this.mChildIndex] = sScale * (1.0f - value) + 1.0f * value;
                        SalonView.this.mDxs[SalonView.this.mChildIndex] = sDx * (1.0f - value) + 0.0f * value;
                        SalonView.this.mDys[SalonView.this.mChildIndex] = sDy * (1.0f - value) + 0.0f * value;
                        ((SalonExhibit)SalonView.this.mExhibits[SalonView.this.mChildIndex]).setMatrix(SalonView.this.mDxs[SalonView.this.mChildIndex], SalonView.this.mDys[SalonView.this.mChildIndex], SalonView.this.mScales[SalonView.this.mChildIndex]);
                    }
                }.start();
            } else if (this.mScales[this.mChildIndex] > 3.0f) {
                final float sScale = this.mScales[this.mChildIndex];
                float eScale = 3.0f;
                final float sDx = this.mDxs[this.mChildIndex];
                float tDx = sDx * 3.0f / sScale;
                final float eDx = this.reform(true, ratio, 3.0f, tDx);
                final float sDy = this.mDys[this.mChildIndex];
                float tDy = sDy * 3.0f / sScale;
                final float eDy = this.reform(false, ratio, 3.0f, tDy);
                this.mAnimator = new SalonAnimation((long)(200.0f + 100.0f * (sScale - 3.0f) / 3.0f), (TimeInterpolator)new DecelerateInterpolator()){

                    @Override
                    protected void display(SalonAnimation animation, float value, long time) {
                        SalonView.this.mScales[SalonView.this.mChildIndex] = sScale * (1.0f - value) + 3.0f * value;
                        SalonView.this.mDxs[SalonView.this.mChildIndex] = sDx * (1.0f - value) + eDx * value;
                        SalonView.this.mDys[SalonView.this.mChildIndex] = sDy * (1.0f - value) + eDy * value;
                        ((SalonExhibit)SalonView.this.mExhibits[SalonView.this.mChildIndex]).setMatrix(SalonView.this.mDxs[SalonView.this.mChildIndex], SalonView.this.mDys[SalonView.this.mChildIndex], SalonView.this.mScales[SalonView.this.mChildIndex]);
                    }
                }.start();
            } else {
                this.mAnimator = new SalonAnimation(Long.MAX_VALUE, null){
                    protected PhysicalCalculator xCalculator;
                    protected PhysicalCalculator yCalculator;
                    {
                        super(duration, interpolator);
                        this.xCalculator = new PhysicalCalculator(SalonView.this.overflow(true, ratio, SalonView.this.mScales[SalonView.this.mChildIndex]), SalonView.this.mDxs[SalonView.this.mChildIndex], vx);
                        this.yCalculator = new PhysicalCalculator(SalonView.this.overflow(false, ratio, SalonView.this.mScales[SalonView.this.mChildIndex]), SalonView.this.mDys[SalonView.this.mChildIndex], vy);
                    }

                    @Override
                    protected void display(SalonAnimation animation, float value, long time) {
                        boolean xEnd = this.xCalculator.calculate(time);
                        boolean yEnd = this.yCalculator.calculate(time);
                        if (xEnd && yEnd) {
                            animation.cancel();
                        }
                        SalonView.this.mDxs[SalonView.this.mChildIndex] = this.xCalculator.load;
                        SalonView.this.mDys[SalonView.this.mChildIndex] = this.yCalculator.load;
                        ((SalonExhibit)SalonView.this.mExhibits[SalonView.this.mChildIndex]).setMatrix(SalonView.this.mDxs[SalonView.this.mChildIndex], SalonView.this.mDys[SalonView.this.mChildIndex], SalonView.this.mScales[SalonView.this.mChildIndex]);
                    }

                    class UnderDamping {
                        protected double tension;
                        protected double friction;
                        protected double x0;
                        protected double v0;
                        public long t1;
                        public double v1;

                        public UnderDamping(double tension, double friction) {
                            this.tension = tension;
                            this.friction = friction;
                        }

                        public UnderDamping set(double x0, double v0) {
                            this.x0 = x0;
                            this.v0 = v0;
                            if (x0 == 0.0 && v0 == 0.0) {
                                this.t1 = 0L;
                                this.v1 = 0.0;
                            } else {
                                double angle;
                                if (x0 == 0.0) {
                                    angle = Math.PI;
                                } else {
                                    double denominator = v0 / x0 + this.friction / 2.0;
                                    double d = angle = denominator == 0.0 ? 1.5707963267948966 : Math.atan(-Math.sqrt(this.tension - this.friction * this.friction / 4.0) / denominator);
                                    if (angle <= 0.0) {
                                        angle += Math.PI;
                                    }
                                }
                                this.t1 = (long)(angle / Math.sqrt(this.tension - this.friction * this.friction / 4.0));
                                this.v1 = ((-(this.friction / 2.0) * v0 - this.tension * x0) / Math.sqrt(this.tension - this.friction * this.friction / 4.0) * Math.sin(Math.sqrt(this.tension - this.friction * this.friction / 4.0) * (double)this.t1) + v0 * Math.cos(Math.sqrt(this.tension - this.friction * this.friction / 4.0) * (double)this.t1)) * Math.pow(Math.E, -this.friction / 2.0 * (double)this.t1);
                            }
                            return this;
                        }

                        public double get(long t) {
                            return ((this.v0 + this.friction / 2.0 * this.x0) / Math.sqrt(this.tension - this.friction * this.friction / 4.0) * Math.sin(Math.sqrt(this.tension - this.friction * this.friction / 4.0) * (double)t) + this.x0 * Math.cos(Math.sqrt(this.tension - this.friction * this.friction / 4.0) * (double)t)) * Math.pow(Math.E, -this.friction / 2.0 * (double)t);
                        }
                    }

                    class MixedFriction {
                        protected double coefficient;
                        protected double vLimit;
                        public double v0;
                        public boolean overflow;
                        public long t1;
                        public double xov1;

                        public MixedFriction(double coefficient, double vLimit) {
                            this.coefficient = coefficient;
                            this.vLimit = vLimit;
                        }

                        public MixedFriction set(double xLimit, double v0) {
                            this.v0 = v0;
                            if (v0 == 0.0) {
                                this.overflow = false;
                                this.t1 = 0L;
                                this.xov1 = 0.0;
                            } else if (xLimit <= 0.0) {
                                this.overflow = true;
                                this.t1 = 0L;
                                this.xov1 = v0;
                            } else {
                                double xMax = this.get(Long.MAX_VALUE);
                                if (Math.abs(xMax) <= xLimit) {
                                    this.overflow = false;
                                    this.t1 = Math.abs(v0) > this.vLimit ? (long)(Math.log(Math.abs(v0) / this.vLimit) / (this.coefficient / this.vLimit) + this.vLimit / this.coefficient) : (long)(Math.abs(v0) / this.coefficient);
                                    this.xov1 = xMax;
                                } else {
                                    this.overflow = true;
                                    if (Math.abs(v0) > this.vLimit) {
                                        double xLeave = xLimit - (Math.abs(v0) - this.vLimit) / (this.coefficient / this.vLimit);
                                        if (xLeave <= 0.0) {
                                            this.t1 = (long)(-Math.log(1.0 - this.coefficient / this.vLimit * xLimit / Math.abs(v0)) / (this.coefficient / this.vLimit));
                                            this.xov1 = (double)(v0 > 0.0 ? 1 : -1) * (Math.abs(v0) - this.coefficient / this.vLimit * xLimit);
                                        } else {
                                            this.t1 = (long)(Math.log(Math.abs(v0) / this.vLimit) / (this.coefficient / this.vLimit) + (this.vLimit - Math.sqrt(Math.max(0.0, this.vLimit * this.vLimit - 2.0 * this.coefficient * xLeave))) / this.coefficient);
                                            this.xov1 = (double)(v0 > 0.0 ? 1 : -1) * Math.sqrt(Math.max(0.0, this.vLimit * this.vLimit - 2.0 * this.coefficient * xLeave));
                                        }
                                    } else {
                                        this.t1 = (long)((Math.abs(v0) - Math.sqrt(Math.max(0.0, v0 * v0 - 2.0 * this.coefficient * xLimit))) / this.coefficient);
                                        this.xov1 = (double)(v0 > 0.0 ? 1 : -1) * Math.sqrt(Math.max(0.0, v0 * v0 - 2.0 * this.coefficient * xLimit));
                                    }
                                }
                            }
                            return this;
                        }

                        public double get(long t) {
                            if (t != Long.MAX_VALUE && Math.abs(this.v0) * Math.pow(Math.E, -(this.coefficient / this.vLimit) * (double)t) >= this.vLimit) {
                                return this.v0 / (this.coefficient / this.vLimit) * (1.0 - Math.pow(Math.E, -(this.coefficient / this.vLimit) * (double)t));
                            }
                            double dv = this.vLimit;
                            double dx = (Math.abs(this.v0) - this.vLimit) / (this.coefficient / this.vLimit);
                            double dt = t;
                            if (dx < 0.0) {
                                dv = Math.abs(this.v0);
                                dx = 0.0;
                            } else {
                                dt -= Math.log(Math.abs(this.v0) / this.vLimit) / (this.coefficient / this.vLimit);
                            }
                            dt = Math.max(dt, 0.0);
                            dt = Math.min(dt, dv / this.coefficient);
                            return this.v0 > 0.0 ? dx : -(dx += -(this.coefficient / 2.0) * dt * dt + dv * dt);
                        }
                    }

                    class PhysicalCalculator {
                        protected MixedFriction friction;
                        protected UnderDamping damping;
                        protected int type;
                        protected long time;
                        protected float overflow;
                        protected float save;
                        public float load;

                        public PhysicalCalculator(float overflow, float origin, float velocity) {
                            this.friction = new MixedFriction(8.0E-4 * (double)SalonView.this.getContext().getResources().getDisplayMetrics().density, 0.125 * (double)SalonView.this.getContext().getResources().getDisplayMetrics().density);
                            this.damping = new UnderDamping(2.5E-4, 0.0266);
                            this.overflow = overflow;
                            this.save = this.load = origin;
                            this.time = 0L;
                            if (this.save >= -overflow / 2.0f && this.save <= overflow / 2.0f) {
                                this.type = 0;
                                this.friction.set(velocity < 0.0f ? (double)(this.save + overflow / 2.0f) : (double)(-(this.save - overflow / 2.0f)), velocity);
                            } else {
                                this.type = 1;
                                float offset = this.save - (overflow <= 0.0f ? 0.0f : (this.save < 0.0f ? -overflow / 2.0f : overflow / 2.0f));
                                this.damping.set(offset, offset != 0.0f ? (double)velocity : 0.0);
                            }
                        }

                        public boolean calculate(long t) {
                            long delta = t - this.time;
                            switch (this.type) {
                                case 0: {
                                    if (delta < this.friction.t1) {
                                        this.load = this.save + (float)this.friction.get(delta);
                                        return false;
                                    }
                                    if (this.friction.overflow) {
                                        this.save = this.load = this.overflow <= 0.0f ? 0.0f : (this.friction.v0 < 0.0 ? -this.overflow / 2.0f : this.overflow / 2.0f);
                                        this.type = 1;
                                        this.time = t - (delta - this.friction.t1);
                                        double v = this.friction.xov1;
                                        if (this.overflow <= 0.0f) {
                                            double k = 0.75;
                                            double b = 0.025 * (double)SalonView.this.getContext().getResources().getDisplayMetrics().density;
                                            if (v > 0.0) {
                                                if ((v = k * v - b) < 0.0) {
                                                    v = 0.0;
                                                }
                                            } else if ((v = k * v + b) > 0.0) {
                                                v = 0.0;
                                            }
                                        }
                                        this.damping.set(0.0, v);
                                        return this.calculate(t);
                                    }
                                    if (this.overflow <= 0.0f) {
                                        this.load = 0.0f;
                                    } else {
                                        this.load = this.save + (float)this.friction.xov1;
                                        if (this.load < -this.overflow / 2.0f) {
                                            this.load = -this.overflow / 2.0f;
                                        } else if (this.load > this.overflow / 2.0f) {
                                            this.load = this.overflow / 2.0f;
                                        }
                                    }
                                    return true;
                                }
                                case 1: {
                                    if (delta < this.damping.t1) {
                                        this.load = (this.overflow <= 0.0f ? 0.0f : (this.save < 0.0f ? -this.overflow / 2.0f : this.overflow / 2.0f)) + (float)this.damping.get(delta);
                                        return false;
                                    }
                                    this.save = this.load = this.overflow <= 0.0f ? 0.0f : (this.save < 0.0f ? -this.overflow / 2.0f : this.overflow / 2.0f);
                                    this.type = 0;
                                    this.time = t - (delta - this.damping.t1);
                                    this.friction.set(this.damping.v1 < 0.0 ? (double)(this.save + this.overflow / 2.0f) : (double)(-(this.save - this.overflow / 2.0f)), this.damping.v1);
                                    return this.calculate(t);
                                }
                            }
                            return false;
                        }
                    }
                }.start();
            }
        }
    }

    protected float overflow(boolean x, float ratio, float scale) {
        return x ? (ratio * (float)this.getHeight() <= (float)this.getWidth() ? scale * (float)this.getHeight() * ratio - (float)this.getWidth() : (scale - 1.0f) * (float)this.getWidth()) : (ratio * (float)this.getHeight() >= (float)this.getWidth() ? scale * (float)this.getWidth() / ratio - (float)this.getHeight() : (scale - 1.0f) * (float)this.getHeight());
    }

    protected float reform(boolean x, float ratio, float scale, float delta) {
        float overflow = this.overflow(x, ratio, scale);
        if (overflow <= 0.0f) {
            return 0.0f;
        }
        if (delta < -overflow / 2.0f) {
            return -overflow / 2.0f;
        }
        if (delta > overflow / 2.0f) {
            return overflow / 2.0f;
        }
        return delta;
    }

    protected abstract void onUpdate(float var1, int var2);

    protected abstract void onClick(float var1, float var2);

    protected abstract void onDoubleClick(float var1, float var2);

    protected abstract void onLongClick(float var1, float var2);

    protected abstract View onCreateExhibit(Context var1);

    protected abstract class SalonAnimation
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnPreDrawListener {
        protected boolean isAttached = false;
        protected boolean hasInit = false;
        protected int mStage = -1;
        protected long mTime = 0L;
        protected long mDuration;
        protected TimeInterpolator mInterpolator;
        protected TransitionController mAnimation;

        public SalonAnimation(long duration, TimeInterpolator interpolator) {
            this.mDuration = duration;
            this.mInterpolator = interpolator;
        }

        public SalonAnimation start() {
            if (this.mStage == -1) {
                this.mStage = 0;
                this.mAnimation = new TransitionController(new TransitionController.TransitionListener(){

                    public float speed(float value, float target) {
                        return 1.0f / (float)SalonAnimation.this.mDuration;
                    }

                    public void display(View self, float value) {
                        SalonAnimation.this.display(SalonAnimation.this, SalonAnimation.this.mInterpolator == null ? value : SalonAnimation.this.mInterpolator.getInterpolation(value), SalonAnimation.this.mTime);
                        if (SalonAnimation.this.mAnimation.getValue() == 1.0f && SalonAnimation.this.mStage == 0) {
                            SalonAnimation.this.mStage = 1;
                            SalonAnimation.this.onEnd();
                        }
                    }
                }, (View)SalonView.this){

                    protected long reduce(long time) {
                        SalonAnimation.this.mTime += time;
                        return super.reduce(time);
                    }
                };
                this.mAnimation.setTarget(1.0f);
                this.onStart();
            }
            return this;
        }

        public SalonAnimation cancel() {
            if (this.mStage == 0) {
                this.mStage = 1;
                this.onCancel();
                this.onEnd();
            }
            return this;
        }

        protected void onStart() {
            this.onViewAttachedToWindow(null);
            SalonView.this.addOnAttachStateChangeListener(this);
        }

        protected void onCancel() {
        }

        protected void onEnd() {
            SalonView.this.removeOnAttachStateChangeListener(this);
            this.onViewDetachedFromWindow(null);
        }

        public void onViewAttachedToWindow(View v) {
            if (this.isAttached) {
                return;
            }
            this.isAttached = true;
            SalonView.this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }

        public void onViewDetachedFromWindow(View v) {
            if (!this.isAttached) {
                return;
            }
            this.isAttached = false;
            SalonView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }

        public boolean onPreDraw() {
            if (!this.hasInit) {
                this.hasInit = true;
                this.mAnimation.initDisplay();
            }
            this.mAnimation.computeScroll();
            return true;
        }

        protected abstract void display(SalonAnimation var1, float var2, long var3);
    }

    protected class SalonDelegate
    extends Handler {
        protected boolean mPermit = true;
        protected int mConsume = 0;
        protected boolean doIntercept = false;
        protected List<Integer> touchPointId = new ArrayList<Integer>();
        protected List<Float> touchPointX = new ArrayList<Float>();
        protected List<Float> touchPointY = new ArrayList<Float>();
        protected float downX = 0.0f;
        protected float downY = 0.0f;
        protected float deltaX = 0.0f;
        protected float deltaY = 0.0f;
        protected float pivotX = 0.0f;
        protected float pivotY = 0.0f;
        protected float scaleK = 1.0f;
        protected float absX = 0.0f;
        protected float absY = 0.0f;
        protected float velocityX = 0.0f;
        protected float velocityY = 0.0f;
        protected VelocityTracker mTracker;
        protected float scaleLimit;
        protected float absLimit;
        protected float doubleLimit;
        protected boolean doCancel = false;
        protected boolean doMove = false;
        protected float clickX = 0.0f;
        protected float clickY = 0.0f;
        protected boolean singleClick = false;
        protected boolean doubleClick = false;
        protected boolean longClick = false;

        public SalonDelegate() {
            this.scaleLimit = 50.0f * SalonView.this.getContext().getResources().getDisplayMetrics().density;
            this.absLimit = 4.0f * SalonView.this.getContext().getResources().getDisplayMetrics().density;
            this.doubleLimit = 50.0f * SalonView.this.getContext().getResources().getDisplayMetrics().density;
            SalonView.this.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                }

                public void onViewDetachedFromWindow(View v) {
                    SalonDelegate.this.removeMessages(0);
                    SalonDelegate.this.removeMessages(1);
                }
            });
        }

        public boolean dispatchTouchEvent(MotionEvent event) {
            if (event.getAction() == 0) {
                if (!this.mPermit) {
                    this.mConsume = -1;
                } else {
                    this.doIntercept = false;
                    if (SalonView.super.dispatchTouchEvent(event)) {
                        this.mConsume = 0;
                    } else {
                        this.mConsume = 1;
                        this.delegateTouchEvent(event);
                    }
                }
            } else {
                switch (this.mConsume) {
                    case 0: {
                        SalonView.super.dispatchTouchEvent(event);
                        break;
                    }
                    case 1: {
                        this.delegateTouchEvent(event);
                    }
                }
            }
            return true;
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            boolean b = SalonView.super.onInterceptTouchEvent(event);
            return b || this.doIntercept;
        }

        public void permitTouchEvent(boolean permit) {
            if (this.mPermit == permit) {
                return;
            }
            this.mPermit = permit;
            if (!this.mPermit) {
                this.doIntercept = true;
                if (!this.doCancel) {
                    this.doCancel = true;
                    this.singleClick = false;
                    this.removeMessages(0);
                    this.removeMessages(1);
                    if (this.touchPointId.size() != 0) {
                        SalonView.this.up(0.0f, 0.0f);
                    }
                }
            }
        }

        protected void delegateTouchEvent(MotionEvent event) {
            if (this.mTracker == null) {
                this.mTracker = VelocityTracker.obtain();
            }
            this.mTracker.addMovement(event);
            switch (event.getAction()) {
                case 1: {
                    this.mTracker.computeCurrentVelocity(1);
                    this.velocityX = this.mTracker.getXVelocity();
                    this.velocityY = this.mTracker.getYVelocity();
                }
                case 3: {
                    this.mTracker.recycle();
                    this.mTracker = null;
                }
            }
            int action = event.getAction();
            int masked = event.getActionMasked();
            if (action == 0 || masked == 5) {
                if (action == 0) {
                    this.touchPointId.clear();
                    this.touchPointX.clear();
                    this.touchPointY.clear();
                    this.downX = event.getX();
                    this.downY = event.getY();
                    this.absX = 0.0f;
                    this.absY = 0.0f;
                }
                this.touchPointId.add(event.getPointerId(event.getActionIndex()));
                this.touchPointX.add(Float.valueOf(event.getX(event.getActionIndex())));
                this.touchPointY.add(Float.valueOf(event.getY(event.getActionIndex())));
            }
            if (action == 2) {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.pivotX = 0.0f;
                this.pivotY = 0.0f;
                this.scaleK = 1.0f;
                boolean b = false;
                float oldX = 0.0f;
                float oldY = 0.0f;
                float newX = 0.0f;
                float newY = 0.0f;
                for (int i = 0; i < this.touchPointId.size(); ++i) {
                    int index = event.findPointerIndex(this.touchPointId.get(i).intValue());
                    if (index == -1) continue;
                    if (!b) {
                        b = true;
                        oldX = this.touchPointX.get(i).floatValue();
                        oldY = this.touchPointY.get(i).floatValue();
                        newX = event.getX(index);
                        newY = event.getY(index);
                        this.deltaX = newX - oldX;
                        this.deltaY = newY - oldY;
                        this.pivotX = oldX;
                        this.pivotY = oldY;
                        this.touchPointX.set(i, Float.valueOf(newX));
                        this.touchPointY.set(i, Float.valueOf(newY));
                        continue;
                    }
                    float oldDistance = (float)Math.sqrt((this.touchPointX.get(i).floatValue() - oldX) * (this.touchPointX.get(i).floatValue() - oldX) + (this.touchPointY.get(i).floatValue() - oldY) * (this.touchPointY.get(i).floatValue() - oldY));
                    float newDistance = (float)Math.sqrt((event.getX(index) - newX) * (event.getX(index) - newX) + (event.getY(index) - newY) * (event.getY(index) - newY));
                    oldDistance = oldDistance < this.scaleLimit ? this.scaleLimit : oldDistance;
                    newDistance = newDistance < this.scaleLimit ? this.scaleLimit : newDistance;
                    this.scaleK *= newDistance / oldDistance;
                    this.touchPointX.set(i, Float.valueOf(event.getX(index)));
                    this.touchPointY.set(i, Float.valueOf(event.getY(index)));
                }
                this.absX += Math.abs(this.deltaX);
                this.absY += Math.abs(this.deltaY);
            }
            if (action == 1 || masked == 6) {
                int id = event.getPointerId(event.getActionIndex());
                for (int i = this.touchPointId.size() - 1; i >= 0; --i) {
                    if (this.touchPointId.get(i) != id) continue;
                    this.touchPointId.remove(i);
                    this.touchPointX.remove(i);
                    this.touchPointY.remove(i);
                }
            }
            if (action == 3) {
                this.touchPointId.clear();
                this.touchPointX.clear();
                this.touchPointY.clear();
            }
            if (event.getAction() == 0) {
                this.doCancel = false;
                this.doMove = false;
                this.doubleClick = this.singleClick;
                this.singleClick = false;
                this.longClick = false;
                this.removeMessages(0);
                this.sendEmptyMessageDelayed(1, 500L);
                SalonView.this.down();
            } else if (!this.doCancel) {
                switch (event.getAction()) {
                    case 2: {
                        if (this.doMove) {
                            SalonView.this.move(this.deltaX, this.deltaY, this.pivotX, this.pivotY, this.scaleK);
                            break;
                        }
                        if (!(this.absX > this.absLimit) && !(this.absY > this.absLimit)) break;
                        this.doMove = true;
                        this.removeMessages(1);
                        SalonView.this.premove(this.absX > this.absY, this.absY > this.absX);
                        break;
                    }
                    case 1: {
                        if (this.doMove) {
                            SalonView.this.up(this.velocityX, this.velocityY);
                        } else {
                            if (!this.longClick) {
                                if (this.doubleClick && Math.sqrt((this.clickX - event.getX()) * (this.clickX - event.getX()) + (this.clickY - event.getY()) * (this.clickY - event.getY())) < (double)this.doubleLimit) {
                                    SalonView.this.onDoubleClick(event.getX(), event.getY());
                                } else {
                                    this.singleClick = true;
                                    this.clickX = event.getX();
                                    this.clickY = event.getY();
                                    this.sendEmptyMessageDelayed(0, 250L);
                                }
                            }
                            SalonView.this.up(0.0f, 0.0f);
                        }
                        this.removeMessages(1);
                        break;
                    }
                    case 3: {
                        SalonView.this.up(0.0f, 0.0f);
                        this.removeMessages(1);
                        break;
                    }
                    default: {
                        if (this.doMove) break;
                        this.doMove = true;
                        this.removeMessages(1);
                        SalonView.this.premove(this.absX > this.absY, this.absY > this.absX);
                    }
                }
            }
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    SalonView.this.onClick(this.clickX, this.clickY);
                    this.singleClick = false;
                    break;
                }
                case 1: {
                    SalonView.this.onLongClick(this.downX, this.downY);
                    this.longClick = true;
                }
            }
        }
    }

    public static interface SalonExhibit {
        public void loadUrl(String var1);

        public float getRatio();

        public void setMatrix(float var1, float var2, float var3);
    }
}

