package com.vccorp.imaloader.playerIma.object;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;


public class Ads implements Parcelable {
    @SerializedName("height")
    @Expose
    private Integer height;
    @SerializedName("width")
    @Expose
    private Integer width;
    @SerializedName("skipoffset")
    @Expose
    private Integer skipoffset;
    @SerializedName("isAddLinkSSP")
    @Expose
    private Boolean isAddLinkSSP;
    @SerializedName("tag")
    @Expose
    private String tag;
    @SerializedName("offset")
    @Expose
    private String offset;
    //
    @SerializedName("repeat")

    private boolean repeat;
    @SerializedName("repeatTime")

    private int repeatTime;
    //
    @SerializedName("durationLogical")
    @Expose
    private String durationLogical;
    @SerializedName("durationValue")
    @Expose
    private String durationValue;

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getSkipoffset() {
        if (skipoffset == null) {
            return 0;
        }
        return skipoffset;
    }

    public void setSkipoffset(Integer skipoffset) {
        this.skipoffset = skipoffset;
    }

    public Boolean getAddLinkSSP() {
        return isAddLinkSSP;
    }

    public void setAddLinkSSP(Boolean addLinkSSP) {
        isAddLinkSSP = addLinkSSP;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getOffset() {
        return offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public boolean isRepeat() {
        return repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public int getRepeatTime() {
        return repeatTime;
    }

    public void setRepeatTime(int repeatTime) {
        this.repeatTime = repeatTime;
    }

    public String getDurationLogical() {
        return durationLogical;
    }

    public void setDurationLogical(String durationLogical) {
        this.durationLogical = durationLogical;
    }

    public String getDurationValue() {
        return durationValue;
    }

    public void setDurationValue(String durationValue) {
        this.durationValue = durationValue;
    }

    protected Ads(Parcel in) {
        if (in.readByte() == 0) {
            height = null;
        } else {
            height = in.readInt();
        }
        if (in.readByte() == 0) {
            width = null;
        } else {
            width = in.readInt();
        }
        if (in.readByte() == 0) {
            skipoffset = null;
        } else {
            skipoffset = in.readInt();
        }
        byte tmpIsAddLinkSSP = in.readByte();
        isAddLinkSSP = tmpIsAddLinkSSP == 0 ? null : tmpIsAddLinkSSP == 1;
        tag = in.readString();
        offset = in.readString();
        repeat = in.readByte() != 0;
        repeatTime = in.readInt();
        durationLogical = in.readString();
        durationValue = in.readString();
    }

    public static final Creator<Ads> CREATOR = new Creator<Ads>() {
        @Override
        public Ads createFromParcel(Parcel in) {
            return new Ads(in);
        }

        @Override
        public Ads[] newArray(int size) {
            return new Ads[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (height == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(height);
        }
        if (width == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(width);
        }
        if (skipoffset == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(skipoffset);
        }
        dest.writeByte((byte) (isAddLinkSSP == null ? 0 : isAddLinkSSP ? 1 : 2));
        dest.writeString(tag);
        dest.writeString(offset);
        dest.writeByte((byte) (repeat ? 1 : 0));
        dest.writeInt(repeatTime);
        dest.writeString(durationLogical);
        dest.writeString(durationValue);
    }
}
