package com.vccorp.imaloader.playerIma.baseRetrofit;

import android.util.Log;

import com.vccorp.imaloader.playerIma.object.AdList;
import com.vccorp.imaloader.playerIma.object.Ads;
import com.vccorp.imaloader.playerIma.object.Advertising;

import java.util.ArrayList;
import java.util.Map;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LoadAds {
    public static final String BASE_REQUEST_ADS = "https://media1.admicro.vn/cms/";

    private static final String TAG = LoadAds.class.getName();
    public static ArrayList<Ads> arrListAds;

    public static ArrayList<Ads> loadAds(String baseUrl) {
        arrListAds = new ArrayList<>();
        Call<AdList> call = (Call<AdList>) APIRequestAds.builderGetTime(BASE_REQUEST_ADS).getListAdverts(baseUrl);
        call.enqueue(new Callback<AdList>() {
            @Override
            public void onResponse(Call<AdList> call, Response<AdList> response) {
                if (response.isSuccessful() && response.body() != null) {
                    AdList obj = response.body();
                    Advertising adver = obj.getAdvertising();
                    Map<String, Ads> maps = adver.getAdSlot();
                    for (String mapKey : maps.keySet()) {
                        Log.d("Map", "mapKey : " + mapKey + " , mapValue : "
                                + maps.get(mapKey).getTag());

                        arrListAds.add(maps.get(mapKey));
                    }
//                            parserXMLFromUrl(arrListAds.get(0).getTag().
//                                    substring(arrListAds.get(0).getTag().lastIndexOf("/") + 1));
                    Log.i(TAG, "JSON1 parser OK");
                } else {
                    Log.i(TAG, "JSON1 err: parser");
                }


            }

            @Override
            public void onFailure(Call<AdList> call, Throwable t) {
                Log.i(TAG, "JSON1 err: " + t.getMessage());

            }
        });
        return arrListAds;
    }

//        public void parserXMLFromUrl(String url) {
//        Call<VAST> call = APIRequestXML.builderGetTime().getAds1(url);
//        call.enqueue(new Callback<VAST>() {
//            @Override
//            public void onResponse(Call<VAST> call, Response<VAST> response) {
//
//                VAST vast = response.body();
//
//                Log.i(TAG, "Response: " + vast);
//            }
//
//            @Override
//            public void onFailure(Call<VAST> call, Throwable t) {
//                Log.i(TAG, "onFailure: " + t.getMessage());
//            }
//        });
//    }
}
