/*
 * Decompiled with CFR 0.152.
 */
package com.vaynberg.wicket.select2;

import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.Response;
import com.vaynberg.wicket.select2.Select2ChoiceBaseComponent;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.http.WebResponse;
import org.json.JSONException;
import org.json.JSONWriter;

abstract class AbstractSelect2Choice<T, M>
extends Select2ChoiceBaseComponent<M>
implements IResourceListener {
    private ChoiceProvider<T> provider;

    public AbstractSelect2Choice(String id) {
        this(id, null, null);
    }

    public AbstractSelect2Choice(String id, IModel<M> model) {
        this(id, model, null);
    }

    public AbstractSelect2Choice(String id, ChoiceProvider<T> provider) {
        this(id, null, provider);
    }

    public AbstractSelect2Choice(String id, IModel<M> model, ChoiceProvider<T> provider) {
        super(id, model);
        this.provider = provider;
    }

    public final void setProvider(ChoiceProvider<T> provider) {
        this.provider = provider;
    }

    public final ChoiceProvider<T> getProvider() {
        if (this.provider == null) {
            throw new IllegalStateException("Select2 choice component: " + this.getId() + " does not have a ChoiceProvider set");
        }
        return this.provider;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.getSettings().getAjax().setUrl(this.urlFor(IResourceListener.INTERFACE, null));
    }

    public void onResourceRequested() {
        Request request = this.getRequestCycle().getRequest();
        IRequestParameters params = request.getRequestParameters();
        String term = params.getParameterValue("term").toOptionalString();
        int page = params.getParameterValue("page").toInt(1);
        Response response = new Response();
        this.getProvider().query(term, --page, response);
        WebResponse webResponse = (WebResponse)this.getRequestCycle().getResponse();
        webResponse.setContentType("application/json");
        OutputStreamWriter out = new OutputStreamWriter(webResponse.getOutputStream(), this.getRequest().getCharset());
        JSONWriter json = new JSONWriter((Appendable)out);
        try {
            json.object().key("results").array();
            this.addValues(json, response);
            json.endArray().key("more").value((Object)response.getHasMore()).endObject();
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not write Json response", e);
        }
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write Json to servlet response", e);
        }
    }

    protected void onDetach() {
        this.getProvider().detach();
        super.onDetach();
    }

    protected boolean getStatelessHint() {
        return false;
    }

    protected void addValues(JSONWriter json, Iterable<T> response) throws JSONException {
        for (T item : response) {
            json.object();
            this.getProvider().toJson(item, json);
            json.endObject();
        }
    }
}

