/*
 * Decompiled with CFR 0.152.
 */
package com.vaynberg.wicket.select2;

import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.GroupedValue;
import com.vaynberg.wicket.select2.Select2MultiChoice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.model.IModel;
import org.json.JSONException;
import org.json.JSONWriter;

public class Select2GroupedMultiChoice<T extends GroupedValue>
extends Select2MultiChoice<T> {
    private static final String UNGROUPED = "UNGROUPED";

    public Select2GroupedMultiChoice(String id, IModel<Collection<T>> model, ChoiceProvider<T> provider) {
        super(id, model, provider);
    }

    public Select2GroupedMultiChoice(String id, IModel<Collection<T>> model) {
        super(id, model);
    }

    public Select2GroupedMultiChoice(String id) {
        super(id);
    }

    @Override
    protected void addValues(JSONWriter json, Iterable<T> response) throws JSONException {
        Map<String, List<T>> groupedItems = this.groupItems(response);
        for (Map.Entry<String, List<T>> entry : groupedItems.entrySet()) {
            if (UNGROUPED.equals(entry.getKey())) {
                super.addValues(json, (Iterable)entry.getValue());
                continue;
            }
            json.object().key("text").value((Object)entry.getKey()).key("children").array();
            super.addValues(json, (Iterable)entry.getValue());
            json.endArray().endObject();
        }
    }

    protected Map<String, List<T>> groupItems(Iterable<T> response) {
        HashMap<String, List<T>> groupedItems = new HashMap<String, List<T>>();
        for (final GroupedValue item : response) {
            String key;
            String group = item.getGroup();
            String string = key = group == null || group.isEmpty() ? UNGROUPED : group;
            if (groupedItems.containsKey(key)) {
                ((List)groupedItems.get(key)).add(item);
                continue;
            }
            groupedItems.put(key, new ArrayList<T>(){
                {
                    this.add(item);
                }
            });
        }
        return groupedItems;
    }
}

